/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.eql;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackFeatureSet;

public class EqlFeatureSetUsage
extends XPackFeatureSet.Usage {
    private final Map<String, Object> stats;

    public EqlFeatureSetUsage(StreamInput in) throws IOException {
        super(in);
        this.stats = in.readMap();
    }

    public EqlFeatureSetUsage(Map<String, Object> stats) {
        super("eql", true, true);
        this.stats = stats;
    }

    public Map<String, Object> stats() {
        return this.stats;
    }

    @Override
    protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.innerXContent(builder, params);
        if (this.enabled) {
            for (Map.Entry<String, Object> entry : this.stats.entrySet()) {
                builder.field(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeGenericMap(this.stats);
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_7_9_0;
    }
}

