/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.enrich.action;

import java.io.IOException;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class ExecuteEnrichPolicyStatus
implements Task.Status {
    public static final String NAME = "enrich-policy-execution";
    private static final String PHASE_FIELD = "phase";
    private static final String STEP_FIELD = "step";
    private final String phase;
    private final String step;

    public ExecuteEnrichPolicyStatus(String phase) {
        this.phase = phase;
        this.step = null;
    }

    public ExecuteEnrichPolicyStatus(ExecuteEnrichPolicyStatus status, String step) {
        this.phase = status.phase;
        this.step = step;
    }

    public ExecuteEnrichPolicyStatus(StreamInput in) throws IOException {
        this.phase = in.readString();
        this.step = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_7_16_0) ? in.readOptionalString() : null;
    }

    public String getPhase() {
        return this.phase;
    }

    public boolean isCompleted() {
        return "COMPLETE".equals(this.phase);
    }

    public String getStep() {
        return this.step;
    }

    public String getWriteableName() {
        return NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.phase);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_7_16_0)) {
            out.writeOptionalString(this.step);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(PHASE_FIELD, this.phase);
        if (this.step != null) {
            builder.field(STEP_FIELD, this.step);
        }
        builder.endObject();
        return builder;
    }

    public static final class PolicyPhases {
        public static final String SCHEDULED = "SCHEDULED";
        public static final String RUNNING = "RUNNING";
        public static final String COMPLETE = "COMPLETE";
        public static final String FAILED = "FAILED";
        public static final String CANCELLED = "CANCELLED";

        private PolicyPhases() {
        }
    }
}

