/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.enrich.action;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.tasks.TaskInfo;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class EnrichStatsAction
extends ActionType<Response> {
    public static final EnrichStatsAction INSTANCE = new EnrichStatsAction();
    public static final String NAME = "cluster:monitor/xpack/enrich/stats";

    private EnrichStatsAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final List<ExecutingPolicy> executingPolicies;
        private final List<CoordinatorStats> coordinatorStats;
        private final List<CacheStats> cacheStats;

        public Response(List<ExecutingPolicy> executingPolicies, List<CoordinatorStats> coordinatorStats, List<CacheStats> cacheStats) {
            this.executingPolicies = executingPolicies;
            this.coordinatorStats = coordinatorStats;
            this.cacheStats = cacheStats;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.executingPolicies = in.readCollectionAsList(ExecutingPolicy::new);
            this.coordinatorStats = in.readCollectionAsList(CoordinatorStats::new);
            this.cacheStats = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_7_16_0) ? in.readCollectionAsList(CacheStats::new) : null;
        }

        public List<ExecutingPolicy> getExecutingPolicies() {
            return this.executingPolicies;
        }

        public List<CoordinatorStats> getCoordinatorStats() {
            return this.coordinatorStats;
        }

        public List<CacheStats> getCacheStats() {
            return this.cacheStats;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.executingPolicies);
            out.writeCollection(this.coordinatorStats);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_7_16_0)) {
                out.writeCollection(this.cacheStats);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startArray("executing_policies");
            for (ExecutingPolicy policy : this.executingPolicies) {
                builder.startObject();
                policy.toXContent(builder, params);
                builder.endObject();
            }
            builder.endArray();
            builder.startArray("coordinator_stats");
            for (CoordinatorStats entry : this.coordinatorStats) {
                builder.startObject();
                entry.toXContent(builder, params);
                builder.endObject();
            }
            builder.endArray();
            if (this.cacheStats != null) {
                builder.startArray("cache_stats");
                for (CacheStats cacheStat : this.cacheStats) {
                    builder.startObject();
                    cacheStat.toXContent(builder, params);
                    builder.endObject();
                }
                builder.endArray();
            }
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return this.executingPolicies.equals(response.executingPolicies) && this.coordinatorStats.equals(response.coordinatorStats) && Objects.equals(this.cacheStats, response.cacheStats);
        }

        public int hashCode() {
            return Objects.hash(this.executingPolicies, this.coordinatorStats, this.cacheStats);
        }

        public static class ExecutingPolicy
        implements Writeable,
        ToXContentFragment {
            private final String name;
            private final TaskInfo taskInfo;

            public ExecutingPolicy(String name, TaskInfo taskInfo) {
                this.name = name;
                this.taskInfo = taskInfo;
            }

            ExecutingPolicy(StreamInput in) throws IOException {
                this(in.readString(), TaskInfo.from((StreamInput)in));
            }

            public String getName() {
                return this.name;
            }

            public TaskInfo getTaskInfo() {
                return this.taskInfo;
            }

            public void writeTo(StreamOutput out) throws IOException {
                out.writeString(this.name);
                this.taskInfo.writeTo(out);
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.field("name", this.name);
                builder.startObject("task");
                builder.value((ToXContent)this.taskInfo);
                builder.endObject();
                return builder;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                ExecutingPolicy that = (ExecutingPolicy)o;
                return this.name.equals(that.name) && this.taskInfo.equals((Object)that.taskInfo);
            }

            public int hashCode() {
                return Objects.hash(this.name, this.taskInfo);
            }
        }

        public static class CoordinatorStats
        implements Writeable,
        ToXContentFragment {
            private final String nodeId;
            private final int queueSize;
            private final int remoteRequestsCurrent;
            private final long remoteRequestsTotal;
            private final long executedSearchesTotal;

            public CoordinatorStats(String nodeId, int queueSize, int remoteRequestsCurrent, long remoteRequestsTotal, long executedSearchesTotal) {
                this.nodeId = nodeId;
                this.queueSize = queueSize;
                this.remoteRequestsCurrent = remoteRequestsCurrent;
                this.remoteRequestsTotal = remoteRequestsTotal;
                this.executedSearchesTotal = executedSearchesTotal;
            }

            public CoordinatorStats(StreamInput in) throws IOException {
                this(in.readString(), in.readVInt(), in.readVInt(), in.readVLong(), in.readVLong());
            }

            public String getNodeId() {
                return this.nodeId;
            }

            public int getQueueSize() {
                return this.queueSize;
            }

            public int getRemoteRequestsCurrent() {
                return this.remoteRequestsCurrent;
            }

            public long getRemoteRequestsTotal() {
                return this.remoteRequestsTotal;
            }

            public long getExecutedSearchesTotal() {
                return this.executedSearchesTotal;
            }

            public void writeTo(StreamOutput out) throws IOException {
                out.writeString(this.nodeId);
                out.writeVInt(this.queueSize);
                out.writeVInt(this.remoteRequestsCurrent);
                out.writeVLong(this.remoteRequestsTotal);
                out.writeVLong(this.executedSearchesTotal);
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.field("node_id", this.nodeId);
                builder.field("queue_size", this.queueSize);
                builder.field("remote_requests_current", this.remoteRequestsCurrent);
                builder.field("remote_requests_total", this.remoteRequestsTotal);
                builder.field("executed_searches_total", this.executedSearchesTotal);
                return builder;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                CoordinatorStats stats = (CoordinatorStats)o;
                return Objects.equals(this.nodeId, stats.nodeId) && this.queueSize == stats.queueSize && this.remoteRequestsCurrent == stats.remoteRequestsCurrent && this.remoteRequestsTotal == stats.remoteRequestsTotal && this.executedSearchesTotal == stats.executedSearchesTotal;
            }

            public int hashCode() {
                return Objects.hash(this.nodeId, this.queueSize, this.remoteRequestsCurrent, this.remoteRequestsTotal, this.executedSearchesTotal);
            }
        }

        public static class CacheStats
        implements Writeable,
        ToXContentFragment {
            private final String nodeId;
            private final long count;
            private final long hits;
            private final long misses;
            private final long evictions;

            public CacheStats(String nodeId, long count, long hits, long misses, long evictions) {
                this.nodeId = nodeId;
                this.count = count;
                this.hits = hits;
                this.misses = misses;
                this.evictions = evictions;
            }

            public CacheStats(StreamInput in) throws IOException {
                this(in.readString(), in.readVLong(), in.readVLong(), in.readVLong(), in.readVLong());
            }

            public String getNodeId() {
                return this.nodeId;
            }

            public long getCount() {
                return this.count;
            }

            public long getHits() {
                return this.hits;
            }

            public long getMisses() {
                return this.misses;
            }

            public long getEvictions() {
                return this.evictions;
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.field("node_id", this.nodeId);
                builder.field("count", this.count);
                builder.field("hits", this.hits);
                builder.field("misses", this.misses);
                builder.field("evictions", this.evictions);
                return builder;
            }

            public void writeTo(StreamOutput out) throws IOException {
                out.writeString(this.nodeId);
                out.writeVLong(this.count);
                out.writeVLong(this.hits);
                out.writeVLong(this.misses);
                out.writeVLong(this.evictions);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                CacheStats that = (CacheStats)o;
                return this.count == that.count && this.hits == that.hits && this.misses == that.misses && this.evictions == that.evictions && this.nodeId.equals(that.nodeId);
            }

            public int hashCode() {
                return Objects.hash(this.nodeId, this.count, this.hits, this.misses, this.evictions);
            }
        }
    }

    public static class Request
    extends MasterNodeRequest<Request> {
        public Request() {
        }

        public Request(StreamInput in) throws IOException {
            super(in);
        }

        public ActionRequestValidationException validate() {
            return null;
        }
    }
}

