/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ccr.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.Transports;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ccr.ShardFollowNodeTaskStatus;

public class FollowStatsAction
extends ActionType<StatsResponses> {
    public static final String NAME = "cluster:monitor/ccr/follow_stats";
    public static final FollowStatsAction INSTANCE = new FollowStatsAction();

    private FollowStatsAction() {
        super(NAME, StatsResponses::new);
    }

    public static class StatsResponse
    implements Writeable,
    ToXContentObject {
        private final ShardFollowNodeTaskStatus status;

        public ShardFollowNodeTaskStatus status() {
            return this.status;
        }

        public StatsResponse(ShardFollowNodeTaskStatus status) {
            this.status = status;
        }

        public StatsResponse(StreamInput in) throws IOException {
            this.status = new ShardFollowNodeTaskStatus(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.status.writeTo(out);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StatsResponse that = (StatsResponse)o;
            return Objects.equals(this.status, that.status);
        }

        public int hashCode() {
            return Objects.hash(this.status);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return this.status.toXContent(builder, params);
        }
    }

    public static class StatsRequest
    extends BaseTasksRequest<StatsRequest>
    implements IndicesRequest {
        private String[] indices;

        public StatsRequest() {
        }

        public StatsRequest(StreamInput in) throws IOException {
            super(in);
            this.indices = in.readOptionalStringArray();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalStringArray(this.indices);
        }

        public String[] indices() {
            return this.indices;
        }

        public void setIndices(String[] indices) {
            this.indices = indices;
        }

        public IndicesOptions indicesOptions() {
            return IndicesOptions.strictExpand();
        }

        public boolean match(Task task) {
            throw new UnsupportedOperationException();
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            StatsRequest that = (StatsRequest)((Object)o);
            return Arrays.equals(this.indices, that.indices);
        }

        public int hashCode() {
            return Arrays.hashCode(this.indices);
        }
    }

    public static class StatsResponses
    extends BaseTasksResponse
    implements ChunkedToXContentObject {
        private final List<StatsResponse> statsResponse;

        public List<StatsResponse> getStatsResponses() {
            return this.statsResponse;
        }

        public StatsResponses(List<TaskOperationFailure> taskFailures, List<? extends FailedNodeException> nodeFailures, List<StatsResponse> statsResponse) {
            super(taskFailures, nodeFailures);
            this.statsResponse = statsResponse;
        }

        public StatsResponses(StreamInput in) throws IOException {
            super(in);
            this.statsResponse = in.readCollectionAsList(StatsResponse::new);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeCollection(this.statsResponse);
        }

        public Iterator<ToXContent> toXContentChunked(ToXContent.Params outerParams) {
            Transports.assertNotTransportThread((String)"collecting responses into a map may be expensive");
            TreeMap<String, Map<Integer, StatsResponse>> taskResponsesByIndex = new TreeMap<String, Map<Integer, StatsResponse>>();
            for (StatsResponse response : this.statsResponse) {
                taskResponsesByIndex.computeIfAbsent(response.status().followerIndex(), k -> new TreeMap()).put(response.status().getShardId(), response);
            }
            return StatsResponses.innerToXContentChunked(taskResponsesByIndex);
        }

        private static Iterator<ToXContent> innerToXContentChunked(Map<String, Map<Integer, StatsResponse>> taskResponsesByIndex) {
            return Iterators.concat((Iterator[])new Iterator[]{Iterators.single((builder, params) -> builder.startObject().startArray("indices")), Iterators.flatMap(taskResponsesByIndex.entrySet().iterator(), indexEntry -> Iterators.concat((Iterator[])new Iterator[]{Iterators.single((builder, params) -> builder.startObject().field("index", (String)indexEntry.getKey()).startArray("shards")), ((Map)indexEntry.getValue()).values().iterator(), Iterators.single((builder, params) -> builder.endArray().endObject())})), Iterators.single((builder, params) -> builder.endArray().endObject())});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            StatsResponses that = (StatsResponses)((Object)o);
            return Objects.equals(this.statsResponse, that.statsResponse);
        }

        public int hashCode() {
            return Objects.hash(this.statsResponse);
        }
    }
}

