/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.action;

import java.util.Collection;
import java.util.LongSummaryStatistics;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.rollover.RolloverConfiguration;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.protocol.xpack.XPackUsageRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureResponse;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureTransportAction;
import org.elasticsearch.xpack.core.datastreams.DataStreamLifecycleFeatureSetUsage;

public class DataStreamLifecycleUsageTransportAction
extends XPackUsageFeatureTransportAction {
    @Inject
    public DataStreamLifecycleUsageTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(XPackUsageFeatureAction.DATA_STREAM_LIFECYCLE.name(), transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver);
    }

    protected void masterOperation(Task task, XPackUsageRequest request, ClusterState state, ActionListener<XPackUsageFeatureResponse> listener) {
        Collection<DataStream> dataStreams = state.metadata().dataStreams().values();
        Tuple<Long, LongSummaryStatistics> stats = DataStreamLifecycleUsageTransportAction.calculateStats(dataStreams);
        long minRetention = ((LongSummaryStatistics)stats.v2()).getCount() == 0L ? 0L : ((LongSummaryStatistics)stats.v2()).getMin();
        long maxRetention = ((LongSummaryStatistics)stats.v2()).getCount() == 0L ? 0L : ((LongSummaryStatistics)stats.v2()).getMax();
        double averageRetention = ((LongSummaryStatistics)stats.v2()).getAverage();
        RolloverConfiguration rolloverConfiguration = (RolloverConfiguration)this.clusterService.getClusterSettings().get(DataStreamLifecycle.CLUSTER_LIFECYCLE_DEFAULT_ROLLOVER_SETTING);
        String rolloverConfigString = rolloverConfiguration.toString();
        DataStreamLifecycleFeatureSetUsage.LifecycleStats lifecycleStats = new DataStreamLifecycleFeatureSetUsage.LifecycleStats((Long)stats.v1(), minRetention, maxRetention, averageRetention, ((RolloverConfiguration)DataStreamLifecycle.CLUSTER_LIFECYCLE_DEFAULT_ROLLOVER_SETTING.getDefault(null)).toString().equals(rolloverConfigString));
        DataStreamLifecycleFeatureSetUsage usage = new DataStreamLifecycleFeatureSetUsage(lifecycleStats);
        listener.onResponse((Object)new XPackUsageFeatureResponse(usage));
    }

    public static Tuple<Long, LongSummaryStatistics> calculateStats(Collection<DataStream> dataStreams) {
        long dataStreamsWithLifecycles = 0L;
        LongSummaryStatistics retentionStats = new LongSummaryStatistics();
        for (DataStream dataStream : dataStreams) {
            if (dataStream.getLifecycle() == null || !dataStream.getLifecycle().isEnabled()) continue;
            ++dataStreamsWithLifecycles;
            if (dataStream.getLifecycle().getEffectiveDataRetention() == null) continue;
            retentionStats.accept(dataStream.getLifecycle().getEffectiveDataRetention().getMillis());
        }
        return new Tuple((Object)dataStreamsWithLifecycles, (Object)retentionStats);
    }
}

