/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core;

import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.health.stats.HealthApiStatsAction;
import org.elasticsearch.protocol.xpack.XPackUsageRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.HealthApiFeatureSetUsage;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureResponse;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureTransportAction;

public class HealthApiUsageTransportAction
extends XPackUsageFeatureTransportAction {
    private final Client client;

    @Inject
    public HealthApiUsageTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client) {
        super(XPackUsageFeatureAction.HEALTH.name(), transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver);
        this.client = client;
    }

    protected void masterOperation(Task task, XPackUsageRequest request, ClusterState state, ActionListener<XPackUsageFeatureResponse> listener) {
        ContextPreservingActionListener preservingListener = ContextPreservingActionListener.wrapPreservingContext(listener, (ThreadContext)this.client.threadPool().getThreadContext());
        if (state.nodesIfRecovered().getMinNodeVersion().onOrAfter((VersionId)Version.V_8_7_0)) {
            HealthApiStatsAction.Request statsRequest = new HealthApiStatsAction.Request();
            statsRequest.setParentTask(this.clusterService.localNode().getId(), task.getId());
            this.client.execute((ActionType)HealthApiStatsAction.INSTANCE, (ActionRequest)statsRequest, preservingListener.delegateFailureAndWrap((l, r) -> {
                HealthApiFeatureSetUsage usage = new HealthApiFeatureSetUsage(true, true, r.getStats());
                l.onResponse((Object)new XPackUsageFeatureResponse(usage));
            }));
        } else {
            HealthApiFeatureSetUsage usage = new HealthApiFeatureSetUsage(false, true, null);
            preservingListener.onResponse((Object)new XPackUsageFeatureResponse(usage));
        }
    }
}

