/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.aggregations.bucket.timeseries;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.aggregations.bucket.timeseries.ParsedTimeSeries;
import org.elasticsearch.aggregations.bucket.timeseries.TimeSeriesAggregationBuilder;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.mapper.TimeSeriesIdFieldMapper;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.ParsedMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.IteratorAndCurrent;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class InternalTimeSeries
extends InternalMultiBucketAggregation<InternalTimeSeries, InternalBucket> {
    private static final ObjectParser<ParsedTimeSeries, Void> PARSER = new ObjectParser(ParsedTimeSeries.class.getSimpleName(), true, ParsedTimeSeries::new);
    private final List<InternalBucket> buckets;
    private final boolean keyed;
    private transient Map<String, InternalBucket> bucketMap;

    public InternalTimeSeries(String name, List<InternalBucket> buckets, boolean keyed, Map<String, Object> metadata) {
        super(name, metadata);
        this.buckets = buckets;
        this.keyed = keyed;
    }

    public InternalTimeSeries(StreamInput in) throws IOException {
        super(in);
        this.keyed = in.readBoolean();
        int size = in.readVInt();
        ArrayList<InternalBucket> buckets = new ArrayList<InternalBucket>(size);
        for (int i = 0; i < size; ++i) {
            buckets.add(new InternalBucket(in, this.keyed));
        }
        this.buckets = buckets;
        this.bucketMap = null;
    }

    public String getWriteableName() {
        return "time_series";
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.keyed) {
            builder.startObject(Aggregation.CommonFields.BUCKETS.getPreferredName());
        } else {
            builder.startArray(Aggregation.CommonFields.BUCKETS.getPreferredName());
        }
        for (InternalBucket bucket : this.buckets) {
            bucket.toXContent(builder, params);
        }
        if (this.keyed) {
            builder.endObject();
        } else {
            builder.endArray();
        }
        return builder;
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.keyed);
        out.writeCollection(this.buckets);
    }

    public InternalAggregation reduce(List<InternalAggregation> aggregations, AggregationReduceContext reduceContext) {
        int initialCapacity = aggregations.stream().map(value -> (InternalTimeSeries)((Object)value)).mapToInt(value -> value.getBuckets().size()).max().getAsInt();
        PriorityQueue<IteratorAndCurrent<InternalBucket>> pq = new PriorityQueue<IteratorAndCurrent<InternalBucket>>(aggregations.size()){

            protected boolean lessThan(IteratorAndCurrent<InternalBucket> a, IteratorAndCurrent<InternalBucket> b) {
                return ((InternalBucket)a.current()).key.compareTo(((InternalBucket)b.current()).key) < 0;
            }
        };
        for (InternalAggregation aggregation : aggregations) {
            InternalTimeSeries timeSeries = (InternalTimeSeries)aggregation;
            if (timeSeries.buckets.isEmpty()) continue;
            IteratorAndCurrent iterator = new IteratorAndCurrent(timeSeries.buckets.iterator());
            pq.add((Object)iterator);
        }
        InternalTimeSeries reduced = new InternalTimeSeries(this.name, new ArrayList<InternalBucket>(initialCapacity), this.keyed, this.getMetadata());
        Integer size = reduceContext.builder() instanceof TimeSeriesAggregationBuilder ? Integer.valueOf(((TimeSeriesAggregationBuilder)reduceContext.builder()).getSize()) : null;
        ArrayList<InternalBucket> bucketsWithSameKey = new ArrayList<InternalBucket>(aggregations.size());
        BytesRef prevTsid = null;
        while (pq.size() > 0) {
            InternalBucket reducedBucket;
            reduceContext.consumeBucketsAndMaybeBreak(1);
            bucketsWithSameKey.clear();
            while (bucketsWithSameKey.isEmpty() || ((InternalBucket)((Object)bucketsWithSameKey.get((int)0))).key.equals((Object)((InternalBucket)((IteratorAndCurrent)pq.top()).current()).key)) {
                IteratorAndCurrent iterator = (IteratorAndCurrent)pq.top();
                bucketsWithSameKey.add((InternalBucket)iterator.current());
                if (iterator.hasNext()) {
                    iterator.next();
                    pq.updateTop();
                    continue;
                }
                pq.pop();
                if (pq.size() != 0) continue;
                break;
            }
            if (bucketsWithSameKey.size() == 1) {
                reducedBucket = (InternalBucket)((Object)bucketsWithSameKey.get(0));
                reducedBucket.aggregations = InternalAggregations.reduce(List.of(reducedBucket.aggregations), (AggregationReduceContext)reduceContext);
            } else {
                reducedBucket = this.reduceBucket(bucketsWithSameKey, reduceContext);
            }
            BytesRef tsid = reducedBucket.key;
            assert (prevTsid == null || tsid.compareTo(prevTsid) > 0);
            reduced.buckets.add(reducedBucket);
            if (size != null && reduced.buckets.size() >= size) break;
            prevTsid = tsid;
        }
        return reduced;
    }

    public InternalTimeSeries create(List<InternalBucket> buckets) {
        return new InternalTimeSeries(this.name, buckets, this.keyed, this.metadata);
    }

    public InternalBucket createBucket(InternalAggregations aggregations, InternalBucket prototype) {
        return new InternalBucket(prototype.key, prototype.docCount, aggregations, prototype.keyed);
    }

    protected InternalBucket reduceBucket(List<InternalBucket> buckets, AggregationReduceContext context) {
        InternalBucket reduced = null;
        ArrayList<InternalAggregations> aggregationsList = new ArrayList<InternalAggregations>(buckets.size());
        for (InternalBucket bucket : buckets) {
            if (reduced == null) {
                reduced = new InternalBucket(bucket.key, bucket.docCount, bucket.aggregations, bucket.keyed);
            } else {
                reduced.docCount += bucket.docCount;
            }
            aggregationsList.add(bucket.aggregations);
        }
        reduced.aggregations = InternalAggregations.reduce(aggregationsList, (AggregationReduceContext)context);
        return reduced;
    }

    public List<InternalBucket> getBuckets() {
        return this.buckets;
    }

    public InternalBucket getBucketByKey(String key) {
        if (this.bucketMap == null) {
            this.bucketMap = new HashMap<String, InternalBucket>(this.buckets.size());
            for (InternalBucket bucket : this.buckets) {
                this.bucketMap.put(bucket.getKeyAsString(), bucket);
            }
        }
        return this.bucketMap.get(key);
    }

    static {
        ParsedMultiBucketAggregation.declareMultiBucketAggregationFields(PARSER, parser -> ParsedTimeSeries.ParsedBucket.fromXContent(parser, false), parser -> ParsedTimeSeries.ParsedBucket.fromXContent(parser, true));
    }

    public static class InternalBucket
    extends InternalMultiBucketAggregation.InternalBucket {
        protected long bucketOrd;
        protected final boolean keyed;
        protected final BytesRef key;
        protected long docCount;
        protected InternalAggregations aggregations;

        public InternalBucket(BytesRef key, long docCount, InternalAggregations aggregations, boolean keyed) {
            this.key = key;
            this.docCount = docCount;
            this.aggregations = aggregations;
            this.keyed = keyed;
        }

        public InternalBucket(StreamInput in, boolean keyed) throws IOException {
            this.keyed = keyed;
            this.key = in.readBytesRef();
            this.docCount = in.readVLong();
            this.aggregations = InternalAggregations.readFrom((StreamInput)in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeBytesRef(this.key);
            out.writeVLong(this.docCount);
            this.aggregations.writeTo(out);
        }

        public Map<String, Object> getKey() {
            return TimeSeriesIdFieldMapper.decodeTsid((BytesRef)this.key);
        }

        public String getKeyAsString() {
            return this.getKey().toString();
        }

        public long getDocCount() {
            return this.docCount;
        }

        public InternalAggregations getAggregations() {
            return this.aggregations;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            Object key = this.getKey();
            if (this.keyed) {
                builder.startObject(key.toString());
            } else {
                builder.startObject();
            }
            builder.field(Aggregation.CommonFields.KEY.getPreferredName(), (Map)key);
            builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.docCount);
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
                return false;
            }
            InternalBucket that = (InternalBucket)((Object)other);
            return Objects.equals(this.key, that.key) && Objects.equals(this.keyed, that.keyed) && Objects.equals(this.docCount, that.docCount) && Objects.equals(this.aggregations, that.aggregations);
        }

        public int hashCode() {
            return Objects.hash(((Object)((Object)this)).getClass(), this.key, this.keyed, this.docCount, this.aggregations);
        }
    }
}

