/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.sort;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class SortValue
implements NamedWriteable,
Comparable<SortValue> {
    private static final SortValue EMPTY_SORT_VALUE = new EmptySortValue();

    public static SortValue from(double d) {
        if (Double.isNaN(d)) {
            return new EmptySortValue();
        }
        return new DoubleSortValue(d);
    }

    public static SortValue from(long l) {
        return new LongSortValue(l);
    }

    public static SortValue from(BytesRef bytes) {
        return new BytesSortValue(bytes);
    }

    public static SortValue empty() {
        return EMPTY_SORT_VALUE;
    }

    public static List<NamedWriteableRegistry.Entry> namedWriteables() {
        return Arrays.asList(new NamedWriteableRegistry.Entry(SortValue.class, "double", DoubleSortValue::new), new NamedWriteableRegistry.Entry(SortValue.class, "long", LongSortValue::new), new NamedWriteableRegistry.Entry(SortValue.class, "bytes", BytesSortValue::new), new NamedWriteableRegistry.Entry(SortValue.class, "empty", EmptySortValue::new));
    }

    private SortValue() {
    }

    @Override
    public final int compareTo(SortValue other) {
        int typeComparison = this.typeComparisonKey() - other.typeComparisonKey();
        return typeComparison == 0 ? this.compareToSameType(other) : typeComparison;
    }

    public final XContentBuilder toXContent(XContentBuilder builder, DocValueFormat format) throws IOException {
        if (format == DocValueFormat.RAW) {
            return this.rawToXContent(builder);
        }
        return builder.value(this.format(format));
    }

    public abstract Object getKey();

    public abstract String format(DocValueFormat var1);

    protected abstract XContentBuilder rawToXContent(XContentBuilder var1) throws IOException;

    protected abstract int compareToSameType(SortValue var1);

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();

    protected abstract int typeComparisonKey();

    public abstract Number numberValue();

    private static class EmptySortValue
    extends SortValue {
        public static final String NAME = "empty";
        private static final String EMPTY_STRING = "";
        private int sortValue = 0;

        private EmptySortValue() {
        }

        private EmptySortValue(StreamInput ignoredIn) {
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
        }

        @Override
        public Object getKey() {
            return EMPTY_STRING;
        }

        @Override
        public String format(DocValueFormat format) {
            return EMPTY_STRING;
        }

        @Override
        protected XContentBuilder rawToXContent(XContentBuilder builder) throws IOException {
            return builder;
        }

        @Override
        protected int compareToSameType(SortValue obj) {
            return 0;
        }

        @Override
        public boolean equals(Object obj) {
            return obj != null && false != this.getClass().equals(obj.getClass());
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public String toString() {
            return EMPTY_STRING;
        }

        @Override
        public int typeComparisonKey() {
            return this.sortValue;
        }

        @Override
        public Number numberValue() {
            return null;
        }
    }

    private static class DoubleSortValue
    extends SortValue {
        public static final String NAME = "double";
        private static final int SORT_VALUE = -2;
        private final double key;

        private DoubleSortValue(double key) {
            this.key = key;
        }

        private DoubleSortValue(StreamInput in) throws IOException {
            this.key = in.readDouble();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeDouble(this.key);
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public String format(DocValueFormat format) {
            return format.format(this.key).toString();
        }

        @Override
        protected XContentBuilder rawToXContent(XContentBuilder builder) throws IOException {
            return builder.value(this.key);
        }

        @Override
        protected int compareToSameType(SortValue obj) {
            DoubleSortValue other = (DoubleSortValue)obj;
            return Double.compare(this.key, other.key);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            DoubleSortValue other = (DoubleSortValue)obj;
            return this.key == other.key;
        }

        @Override
        public int hashCode() {
            return Double.hashCode(this.key);
        }

        @Override
        public String toString() {
            return Double.toString(this.key);
        }

        @Override
        public int typeComparisonKey() {
            return -2;
        }

        @Override
        public Number numberValue() {
            return this.key;
        }
    }

    private static class LongSortValue
    extends SortValue {
        public static final String NAME = "long";
        private static final int SORT_VALUE = -1;
        private final long key;

        LongSortValue(long key) {
            this.key = key;
        }

        private LongSortValue(StreamInput in) throws IOException {
            this.key = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.key);
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public String format(DocValueFormat format) {
            return format.format(this.key).toString();
        }

        @Override
        protected XContentBuilder rawToXContent(XContentBuilder builder) throws IOException {
            return builder.value(this.key);
        }

        @Override
        protected int compareToSameType(SortValue obj) {
            LongSortValue other = (LongSortValue)obj;
            return Long.compare(this.key, other.key);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            LongSortValue other = (LongSortValue)obj;
            return this.key == other.key;
        }

        @Override
        public int hashCode() {
            return Long.hashCode(this.key);
        }

        @Override
        public String toString() {
            return Long.toString(this.key);
        }

        @Override
        public int typeComparisonKey() {
            return -1;
        }

        @Override
        public Number numberValue() {
            return this.key;
        }
    }

    private static class BytesSortValue
    extends SortValue {
        public static final String NAME = "bytes";
        private static final int SORT_VALUE = -3;
        private final BytesRef key;

        BytesSortValue(BytesRef key) {
            this.key = key;
        }

        private BytesSortValue(StreamInput in) throws IOException {
            this.key = in.readBytesRef();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (out.getTransportVersion().before(TransportVersions.V_7_11_0)) {
                throw new IllegalArgumentException("transport versions before [7110099] can't handle non-numeric sort values, attempted to send to [" + out.getTransportVersion() + "]");
            }
            out.writeBytesRef(this.key);
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public String format(DocValueFormat format) {
            return format.format(this.key).toString();
        }

        @Override
        protected XContentBuilder rawToXContent(XContentBuilder builder) throws IOException {
            return builder.value(this.key.utf8ToString());
        }

        @Override
        protected int compareToSameType(SortValue obj) {
            BytesSortValue other = (BytesSortValue)obj;
            return this.key.compareTo(other.key);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            BytesSortValue other = (BytesSortValue)obj;
            return this.key.equals((Object)other.key);
        }

        @Override
        public int hashCode() {
            return this.key.hashCode();
        }

        @Override
        public String toString() {
            return this.key.toString();
        }

        @Override
        public int typeComparisonKey() {
            return -3;
        }

        @Override
        public Number numberValue() {
            return Double.NaN;
        }
    }
}

