/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile.dfs;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.search.profile.AbstractProfileBreakdown;
import org.elasticsearch.search.profile.ProfileResult;
import org.elasticsearch.search.profile.SearchProfileDfsPhaseResult;
import org.elasticsearch.search.profile.Timer;
import org.elasticsearch.search.profile.dfs.DfsTimingType;
import org.elasticsearch.search.profile.query.QueryProfileShardResult;
import org.elasticsearch.search.profile.query.QueryProfiler;

public class DfsProfiler
extends AbstractProfileBreakdown<DfsTimingType> {
    private long startTime;
    private long totalTime;
    private final List<QueryProfiler> knnQueryProfilers = new ArrayList<QueryProfiler>();

    public DfsProfiler() {
        super(DfsTimingType.class);
    }

    public void start() {
        this.startTime = System.nanoTime();
    }

    public void stop() {
        this.totalTime = System.nanoTime() - this.startTime;
    }

    public Timer startTimer(DfsTimingType dfsTimingType) {
        Timer newTimer = this.getNewTimer(dfsTimingType);
        newTimer.start();
        return newTimer;
    }

    public QueryProfiler addQueryProfiler() {
        QueryProfiler queryProfiler = new QueryProfiler();
        this.knnQueryProfilers.add(queryProfiler);
        return queryProfiler;
    }

    public SearchProfileDfsPhaseResult buildDfsPhaseResults() {
        ProfileResult dfsProfileResult = new ProfileResult("statistics", "collect term statistics", this.toBreakdownMap(), this.toDebugMap(), this.totalTime, List.of());
        if (this.knnQueryProfilers.size() > 0) {
            ArrayList<QueryProfileShardResult> queryProfileShardResult = new ArrayList<QueryProfileShardResult>(this.knnQueryProfilers.size());
            for (QueryProfiler queryProfiler : this.knnQueryProfilers) {
                queryProfileShardResult.add(new QueryProfileShardResult(queryProfiler.getTree(), queryProfiler.getRewriteTime(), queryProfiler.getCollectorResult()));
            }
            return new SearchProfileDfsPhaseResult(dfsProfileResult, queryProfileShardResult);
        }
        return new SearchProfileDfsPhaseResult(dfsProfileResult, null);
    }
}

