/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.search.profile.ProfileResult;
import org.elasticsearch.search.profile.SearchProfileDfsPhaseResult;
import org.elasticsearch.search.profile.SearchProfileQueryPhaseResult;
import org.elasticsearch.search.profile.SearchProfileShardResult;
import org.elasticsearch.search.profile.aggregation.AggregationProfileShardResult;
import org.elasticsearch.search.profile.query.QueryProfileShardResult;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public final class SearchProfileResults
implements Writeable,
ToXContentFragment {
    private static final Logger logger = LogManager.getLogger(SearchProfileResults.class);
    private static final String ID_FIELD = "id";
    private static final String NODE_ID_FIELD = "node_id";
    private static final String CLUSTER_FIELD = "cluster";
    private static final String INDEX_NAME_FIELD = "index";
    private static final String SHARD_ID_FIELD = "shard_id";
    private static final String SHARDS_FIELD = "shards";
    public static final String PROFILE_FIELD = "profile";
    private final Map<String, SearchProfileShardResult> shardResults;
    private static final Pattern SHARD_ID_DECOMPOSITION = Pattern.compile("\\[([^]]+)\\]\\[([^]]+)\\]\\[(\\d+)\\]");

    public SearchProfileResults(Map<String, SearchProfileShardResult> shardResults) {
        this.shardResults = Collections.unmodifiableMap(shardResults);
    }

    public SearchProfileResults(StreamInput in) throws IOException {
        this.shardResults = in.getTransportVersion().onOrAfter(TransportVersions.V_7_16_0) ? in.readMap(SearchProfileShardResult::new) : in.readMap(i -> new SearchProfileShardResult(new SearchProfileQueryPhaseResult(i), null));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_7_16_0)) {
            out.writeMap(this.shardResults, StreamOutput::writeWriteable);
        } else {
            out.writeMap(this.shardResults, (o, r) -> r.getQueryPhase().writeTo(o));
        }
    }

    public Map<String, SearchProfileShardResult> getShardResults() {
        return this.shardResults;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(PROFILE_FIELD).startArray(SHARDS_FIELD);
        TreeSet<String> sortedKeys = new TreeSet<String>(this.shardResults.keySet());
        for (String key : sortedKeys) {
            builder.startObject();
            builder.field(ID_FIELD, key);
            ShardProfileId shardProfileId = SearchProfileResults.parseCompositeProfileShardId(key);
            if (shardProfileId != null) {
                builder.field(NODE_ID_FIELD, shardProfileId.nodeId());
                builder.field(SHARD_ID_FIELD, shardProfileId.shardId());
                builder.field(INDEX_NAME_FIELD, shardProfileId.indexName());
                String cluster = shardProfileId.clusterName();
                if (cluster == null) {
                    cluster = "(local)";
                }
                builder.field(CLUSTER_FIELD, cluster);
            }
            SearchProfileShardResult shardResult = this.shardResults.get(key);
            shardResult.toXContent(builder, params);
            builder.endObject();
        }
        builder.endArray().endObject();
        return builder;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SearchProfileResults other = (SearchProfileResults)obj;
        return this.shardResults.equals(other.shardResults);
    }

    public int hashCode() {
        return this.shardResults.hashCode();
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public static SearchProfileResults fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser);
        HashMap<String, SearchProfileShardResult> profileResults = new HashMap<String, SearchProfileShardResult>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.START_ARRAY) {
                if (SHARDS_FIELD.equals(parser.currentName())) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        SearchProfileResults.parseProfileResultsEntry(parser, profileResults);
                    }
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            if (token != XContentParser.Token.START_OBJECT) continue;
            parser.skipChildren();
        }
        return new SearchProfileResults(profileResults);
    }

    private static void parseProfileResultsEntry(XContentParser parser, Map<String, SearchProfileShardResult> searchProfileResults) throws IOException {
        XContentParser.Token token = parser.currentToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser);
        SearchProfileDfsPhaseResult searchProfileDfsPhaseResult = null;
        ArrayList<QueryProfileShardResult> queryProfileResults = new ArrayList<QueryProfileShardResult>();
        AggregationProfileShardResult aggProfileShardResult = null;
        ProfileResult fetchResult = null;
        String id = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (ID_FIELD.equals(currentFieldName)) {
                    id = parser.text();
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if ("searches".equals(currentFieldName)) {
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        queryProfileResults.add(QueryProfileShardResult.fromXContent(parser));
                    }
                    continue;
                }
                if ("aggregations".equals(currentFieldName)) {
                    aggProfileShardResult = AggregationProfileShardResult.fromXContent(parser);
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("dfs".equals(currentFieldName)) {
                    searchProfileDfsPhaseResult = SearchProfileDfsPhaseResult.fromXContent(parser);
                    continue;
                }
                if ("fetch".equals(currentFieldName)) {
                    fetchResult = ProfileResult.fromXContent(parser);
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            parser.skipChildren();
        }
        SearchProfileShardResult result = new SearchProfileShardResult(new SearchProfileQueryPhaseResult(queryProfileResults, aggProfileShardResult), fetchResult);
        result.getQueryPhase().setSearchProfileDfsPhaseResult(searchProfileDfsPhaseResult);
        searchProfileResults.put(id, result);
    }

    static ShardProfileId parseCompositeProfileShardId(String compositeId) {
        assert (!Strings.isNullOrEmpty(compositeId)) : "An empty id should not be passed to parseCompositeProfileShardId";
        Matcher m = SHARD_ID_DECOMPOSITION.matcher(compositeId);
        if (m.find()) {
            String nodeId = m.group(1);
            String indexName = m.group(2);
            int shardId = Integer.parseInt(m.group(3));
            String cluster = null;
            if (indexName.contains(":")) {
                String[] tokens = indexName.split(":", 2);
                cluster = tokens[0];
                indexName = tokens[1];
            }
            return new ShardProfileId(nodeId, indexName, shardId, cluster);
        }
        assert (false) : "Unable to match input against expected pattern of [nodeId][indexName][shardId]. Input: " + compositeId;
        logger.warn("Unable to match input against expected pattern of [nodeId][indexName][shardId]. Input: {}", (Object)compositeId);
        return null;
    }

    record ShardProfileId(String nodeId, String indexName, int shardId, @Nullable String clusterName) {
    }
}

