/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import java.io.IOException;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.index.fieldvisitor.LeafStoredFieldLoader;
import org.elasticsearch.index.fieldvisitor.StoredFieldLoader;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.search.lookup.SourceProvider;

class StoredFieldSourceProvider
implements SourceProvider {
    private final StoredFieldLoader storedFieldLoader;
    private volatile LeafStoredFieldSourceProvider[] leaves;

    StoredFieldSourceProvider(StoredFieldLoader storedFieldLoader) {
        this.storedFieldLoader = storedFieldLoader;
    }

    @Override
    public Source getSource(LeafReaderContext ctx, int doc) throws IOException {
        LeafStoredFieldSourceProvider[] leaves = this.getLeavesUnderLock(this.findParentContext(ctx));
        if (leaves[ctx.ord] == null) {
            leaves[ctx.ord] = new LeafStoredFieldSourceProvider(this.storedFieldLoader.getLoader(ctx, null));
        }
        return leaves[ctx.ord].getSource(doc);
    }

    private IndexReaderContext findParentContext(LeafReaderContext ctx) {
        if (ctx.parent != null) {
            return ctx.parent;
        }
        assert (ctx.isTopLevel);
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LeafStoredFieldSourceProvider[] getLeavesUnderLock(IndexReaderContext parentCtx) {
        if (this.leaves == null) {
            StoredFieldSourceProvider storedFieldSourceProvider = this;
            synchronized (storedFieldSourceProvider) {
                if (this.leaves == null) {
                    this.leaves = new LeafStoredFieldSourceProvider[parentCtx.leaves().size()];
                }
            }
        }
        return this.leaves;
    }

    private static class LeafStoredFieldSourceProvider {
        final LeafStoredFieldLoader leafStoredFieldLoader;
        int doc = -1;
        Source source;

        private LeafStoredFieldSourceProvider(LeafStoredFieldLoader leafStoredFieldLoader) {
            this.leafStoredFieldLoader = leafStoredFieldLoader;
        }

        Source getSource(int doc) throws IOException {
            if (this.doc == doc) {
                return this.source;
            }
            this.doc = doc;
            this.leafStoredFieldLoader.advanceTo(doc);
            this.source = Source.fromBytes(this.leafStoredFieldLoader.source());
            return this.source;
        }
    }
}

