/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.index.fieldvisitor.LeafStoredFieldLoader;
import org.elasticsearch.index.fieldvisitor.StoredFieldLoader;
import org.elasticsearch.index.mapper.IdLoader;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.search.LeafNestedDocuments;
import org.elasticsearch.search.NestedDocuments;
import org.elasticsearch.search.SearchContextSourcePrinter;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.fetch.FetchContext;
import org.elasticsearch.search.fetch.FetchPhaseDocsIterator;
import org.elasticsearch.search.fetch.FetchPhaseExecutionException;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.FetchSubPhaseProcessor;
import org.elasticsearch.search.fetch.PreloadedFieldLookupProvider;
import org.elasticsearch.search.fetch.StoredFieldsSpec;
import org.elasticsearch.search.fetch.subphase.InnerHitsContext;
import org.elasticsearch.search.fetch.subphase.InnerHitsPhase;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.search.lookup.SourceProvider;
import org.elasticsearch.search.profile.ProfileResult;
import org.elasticsearch.search.profile.Profilers;
import org.elasticsearch.search.profile.Timer;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.xcontent.XContentType;

public class FetchPhase {
    private static final Logger LOGGER = LogManager.getLogger(FetchPhase.class);
    private final FetchSubPhase[] fetchSubPhases;

    public FetchPhase(List<FetchSubPhase> fetchSubPhases) {
        this.fetchSubPhases = fetchSubPhases.toArray(new FetchSubPhase[fetchSubPhases.size() + 1]);
        this.fetchSubPhases[fetchSubPhases.size()] = new InnerHitsPhase(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(SearchContext context) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("{}", (Object)new SearchContextSourcePrinter(context));
        }
        if (context.isCancelled()) {
            throw new TaskCancelledException("cancelled");
        }
        if (context.docIdsToLoad() == null || context.docIdsToLoad().length == 0) {
            SearchHits hits = new SearchHits(new SearchHit[0], context.queryResult().getTotalHits(), context.queryResult().getMaxScore());
            context.fetchResult().shardResult(hits, null);
            return;
        }
        Profiler profiler = context.getProfilers() == null ? Profiler.NOOP : Profilers.startProfilingFetchPhase();
        SearchHits hits = null;
        try {
            hits = this.buildSearchHits(context, profiler);
        }
        finally {
            ProfileResult profileResult = profiler.finish();
            if (hits != null) {
                context.fetchResult().shardResult(hits, profileResult);
            }
        }
    }

    private SearchHits buildSearchHits(final SearchContext context, final Profiler profiler) {
        FetchContext fetchContext = new FetchContext(context);
        final SourceLoader sourceLoader = context.newSourceLoader();
        final PreloadedSourceProvider sourceProvider = new PreloadedSourceProvider();
        final PreloadedFieldLookupProvider fieldLookupProvider = new PreloadedFieldLookupProvider();
        context.getSearchExecutionContext().setLookupProviders(sourceProvider, ctx -> fieldLookupProvider);
        final List<FetchSubPhaseProcessor> processors = this.getProcessors(context.shardTarget(), fetchContext, profiler);
        StoredFieldsSpec storedFieldsSpec = StoredFieldsSpec.build(processors, FetchSubPhaseProcessor::storedFieldsSpec);
        storedFieldsSpec = storedFieldsSpec.merge(new StoredFieldsSpec(false, false, sourceLoader.requiredStoredFields()));
        final StoredFieldLoader storedFieldLoader = profiler.storedFields(StoredFieldLoader.fromSpec(storedFieldsSpec));
        final IdLoader idLoader = context.newIdLoader();
        final boolean requiresSource = storedFieldsSpec.requiresSource();
        final NestedDocuments nestedDocuments = context.getSearchExecutionContext().getNestedDocuments();
        FetchPhaseDocsIterator docsIterator = new FetchPhaseDocsIterator(){
            LeafReaderContext ctx;
            LeafNestedDocuments leafNestedDocuments;
            LeafStoredFieldLoader leafStoredFieldLoader;
            SourceLoader.Leaf leafSourceLoader;
            IdLoader.Leaf leafIdLoader;

            @Override
            protected void setNextReader(LeafReaderContext ctx, int[] docsInLeaf) throws IOException {
                Timer timer = profiler.startNextReader();
                this.ctx = ctx;
                this.leafNestedDocuments = nestedDocuments.getLeafNestedDocuments(ctx);
                this.leafStoredFieldLoader = storedFieldLoader.getLoader(ctx, docsInLeaf);
                this.leafSourceLoader = sourceLoader.leaf(ctx.reader(), docsInLeaf);
                this.leafIdLoader = idLoader.leaf(this.leafStoredFieldLoader, ctx.reader(), docsInLeaf);
                fieldLookupProvider.setNextReader(ctx);
                for (FetchSubPhaseProcessor processor : processors) {
                    processor.setNextReader(ctx);
                }
                if (timer != null) {
                    timer.stop();
                }
            }

            @Override
            protected SearchHit nextDoc(int doc) throws IOException {
                if (context.isCancelled()) {
                    throw new TaskCancelledException("cancelled");
                }
                FetchSubPhase.HitContext hit = FetchPhase.prepareHitContext(context, requiresSource, profiler, this.leafNestedDocuments, this.leafStoredFieldLoader, doc, this.ctx, this.leafSourceLoader, this.leafIdLoader);
                sourceProvider.source = hit.source();
                fieldLookupProvider.storedFields = hit.loadedFields();
                for (FetchSubPhaseProcessor processor : processors) {
                    processor.process(hit);
                }
                return hit.hit();
            }
        };
        SearchHit[] hits = docsIterator.iterate(context.shardTarget(), context.searcher().getIndexReader(), context.docIdsToLoad());
        if (context.isCancelled()) {
            throw new TaskCancelledException("cancelled");
        }
        TotalHits totalHits = context.getTotalHits();
        return new SearchHits(hits, totalHits, context.getMaxScore());
    }

    List<FetchSubPhaseProcessor> getProcessors(SearchShardTarget target, FetchContext context, Profiler profiler) {
        try {
            ArrayList<FetchSubPhaseProcessor> processors = new ArrayList<FetchSubPhaseProcessor>();
            for (FetchSubPhase fsp : this.fetchSubPhases) {
                FetchSubPhaseProcessor processor = fsp.getProcessor(context);
                if (processor == null) continue;
                processors.add(profiler.profile(fsp.getClass().getSimpleName(), "", processor));
            }
            return processors;
        }
        catch (Exception e) {
            throw new FetchPhaseExecutionException(target, "Error building fetch sub-phases", e);
        }
    }

    private static FetchSubPhase.HitContext prepareHitContext(SearchContext context, boolean requiresSource, Profiler profiler, LeafNestedDocuments nestedDocuments, LeafStoredFieldLoader leafStoredFieldLoader, int docId, LeafReaderContext subReaderContext, SourceLoader.Leaf sourceLoader, IdLoader.Leaf idLoader) throws IOException {
        if (nestedDocuments.advance(docId - subReaderContext.docBase) == null) {
            return FetchPhase.prepareNonNestedHitContext(requiresSource, profiler, leafStoredFieldLoader, docId, subReaderContext, sourceLoader, idLoader);
        }
        return FetchPhase.prepareNestedHitContext(context, requiresSource, profiler, docId, nestedDocuments, subReaderContext, leafStoredFieldLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FetchSubPhase.HitContext prepareNonNestedHitContext(boolean requiresSource, Profiler profiler, LeafStoredFieldLoader leafStoredFieldLoader, int docId, LeafReaderContext subReaderContext, SourceLoader.Leaf sourceLoader, IdLoader.Leaf idLoader) throws IOException {
        Source source;
        int subDocId = docId - subReaderContext.docBase;
        leafStoredFieldLoader.advanceTo(subDocId);
        String id = idLoader.getId(subDocId);
        if (id == null) {
            SearchHit hit = new SearchHit(docId, null);
            Source source2 = Source.lazy(FetchPhase.lazyStoredSourceLoader(profiler, subReaderContext, subDocId));
            return new FetchSubPhase.HitContext(hit, subReaderContext, subDocId, Map.of(), source2);
        }
        SearchHit hit = new SearchHit(docId, id);
        if (requiresSource) {
            Timer timer = profiler.startLoadingSource();
            try {
                source = sourceLoader.source(leafStoredFieldLoader, subDocId);
            }
            finally {
                if (timer != null) {
                    timer.stop();
                }
            }
        } else {
            source = Source.lazy(FetchPhase.lazyStoredSourceLoader(profiler, subReaderContext, subDocId));
        }
        return new FetchSubPhase.HitContext(hit, subReaderContext, subDocId, leafStoredFieldLoader.storedFields(), source);
    }

    private static Supplier<Source> lazyStoredSourceLoader(Profiler profiler, LeafReaderContext ctx, int doc) {
        return () -> {
            StoredFieldLoader rootLoader = profiler.storedFields(StoredFieldLoader.create(true, Collections.emptySet()));
            try {
                LeafStoredFieldLoader leafRootLoader = rootLoader.getLoader(ctx, null);
                leafRootLoader.advanceTo(doc);
                return Source.fromBytes(leafRootLoader.source());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    private static FetchSubPhase.HitContext prepareNestedHitContext(SearchContext context, boolean requiresSource, Profiler profiler, int topDocId, LeafNestedDocuments nestedInfo, LeafReaderContext subReaderContext, LeafStoredFieldLoader childFieldLoader) throws IOException {
        String rootId;
        Source rootSource = Source.empty(XContentType.JSON);
        if (context instanceof InnerHitsContext.InnerHitSubContext) {
            InnerHitsContext.InnerHitSubContext innerHitsContext = (InnerHitsContext.InnerHitSubContext)context;
            rootId = innerHitsContext.getRootId();
            if (requiresSource) {
                rootSource = innerHitsContext.getRootLookup();
            }
        } else {
            StoredFieldLoader rootLoader = profiler.storedFields(StoredFieldLoader.create(requiresSource, Collections.emptySet()));
            LeafStoredFieldLoader leafRootLoader = rootLoader.getLoader(subReaderContext, null);
            leafRootLoader.advanceTo(nestedInfo.rootDoc());
            rootId = leafRootLoader.id();
            if (requiresSource && leafRootLoader.source() != null) {
                rootSource = Source.fromBytes(leafRootLoader.source());
            }
        }
        childFieldLoader.advanceTo(nestedInfo.doc());
        SearchHit.NestedIdentity nestedIdentity = nestedInfo.nestedIdentity();
        assert (nestedIdentity != null);
        Source nestedSource = nestedIdentity.extractSource(rootSource);
        SearchHit hit = new SearchHit(topDocId, rootId, nestedIdentity);
        return new FetchSubPhase.HitContext(hit, subReaderContext, nestedInfo.doc(), childFieldLoader.storedFields(), nestedSource);
    }

    static interface Profiler {
        public static final Profiler NOOP = new Profiler(){

            @Override
            public ProfileResult finish() {
                return null;
            }

            @Override
            public StoredFieldLoader storedFields(StoredFieldLoader storedFieldLoader) {
                return storedFieldLoader;
            }

            @Override
            public FetchSubPhaseProcessor profile(String type, String description, FetchSubPhaseProcessor processor) {
                return processor;
            }

            @Override
            public Timer startLoadingSource() {
                return null;
            }

            @Override
            public Timer startNextReader() {
                return null;
            }

            public String toString() {
                return "noop";
            }
        };

        public ProfileResult finish();

        public FetchSubPhaseProcessor profile(String var1, String var2, FetchSubPhaseProcessor var3);

        public StoredFieldLoader storedFields(StoredFieldLoader var1);

        public Timer startLoadingSource();

        public Timer startNextReader();
    }

    private static class PreloadedSourceProvider
    implements SourceProvider {
        Source source;

        private PreloadedSourceProvider() {
        }

        @Override
        public Source getSource(LeafReaderContext ctx, int doc) throws IOException {
            return this.source;
        }
    }
}

