/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.function.IntSupplier;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.PriorityQueue;
import org.apache.lucene.util.ThreadInterruptedException;
import org.elasticsearch.common.lucene.search.function.MinScoreScorer;
import org.elasticsearch.index.IndexSortConfig;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.BucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.sort.SortOrder;

public class TimeSeriesIndexSearcher {
    private static final int CHECK_CANCELLED_SCORER_INTERVAL = 2048;
    private final ContextIndexSearcher searcher;
    private final List<Runnable> cancellations;
    private final boolean tsidReverse;
    private final boolean timestampReverse;
    private Float minimumScore = null;

    public TimeSeriesIndexSearcher(IndexSearcher searcher, List<Runnable> cancellations) {
        try {
            this.searcher = new ContextIndexSearcher(searcher.getIndexReader(), searcher.getSimilarity(), searcher.getQueryCache(), searcher.getQueryCachingPolicy(), false, searcher.getExecutor(), 1, -1);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.cancellations = cancellations;
        cancellations.forEach(this.searcher::addQueryCancellation);
        assert (IndexSortConfig.TIME_SERIES_SORT.length == 2);
        assert (IndexSortConfig.TIME_SERIES_SORT[0].getField().equals("_tsid"));
        assert (IndexSortConfig.TIME_SERIES_SORT[1].getField().equals("@timestamp"));
        this.tsidReverse = IndexSortConfig.TIME_SERIES_SORT[0].getOrder() == SortOrder.DESC;
        this.timestampReverse = IndexSortConfig.TIME_SERIES_SORT[1].getOrder() == SortOrder.DESC;
    }

    public void setMinimumScore(Float minimumScore) {
        this.minimumScore = minimumScore;
    }

    public void search(Query query, BucketCollector bucketCollector) throws IOException {
        query = this.searcher.rewrite(query);
        Weight weight = this.searcher.createWeight(query, bucketCollector.scoreMode(), 1.0f);
        if (this.searcher.getExecutor() == null) {
            this.search(bucketCollector, weight);
            bucketCollector.postCollection();
            return;
        }
        FutureTask<Void> task = new FutureTask<Void>(() -> {
            this.search(bucketCollector, weight);
            bucketCollector.postCollection();
            return null;
        });
        this.searcher.getExecutor().execute(task);
        try {
            task.get();
        }
        catch (InterruptedException e) {
            throw new ThreadInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)throwable;
                throw runtimeException;
            }
            throw new RuntimeException(e.getCause());
        }
    }

    private void search(BucketCollector bucketCollector, Weight weight) throws IOException {
        int seen = 0;
        int[] tsidOrd = new int[1];
        ArrayList<LeafWalker> leafWalkers = new ArrayList<LeafWalker>();
        for (LeafReaderContext leaf : this.searcher.getIndexReader().leaves()) {
            Scorer scorer;
            if (++seen % 2048 == 0) {
                this.checkCancelled();
            }
            if ((scorer = weight.scorer(leaf)) != null) {
                LeafWalker leafWalker;
                if (this.minimumScore != null) {
                    scorer = new MinScoreScorer(weight, scorer, this.minimumScore.floatValue());
                }
                if ((leafWalker = new LeafWalker(leaf, scorer, bucketCollector, () -> tsidOrd[0])).nextDoc() == Integer.MAX_VALUE) continue;
                leafWalkers.add(leafWalker);
                continue;
            }
            bucketCollector.getLeafCollector(new AggregationExecutionContext(leaf, null, null, null));
        }
        PriorityQueue<LeafWalker> queue = new PriorityQueue<LeafWalker>(this.searcher.getIndexReader().leaves().size()){

            protected boolean lessThan(LeafWalker a, LeafWalker b) {
                if (TimeSeriesIndexSearcher.this.timestampReverse) {
                    return a.timestamp > b.timestamp;
                }
                return a.timestamp < b.timestamp;
            }
        };
        while (this.populateQueue(leafWalkers, queue)) {
            do {
                if (++seen % 2048 == 0) {
                    this.checkCancelled();
                }
                LeafWalker walker = (LeafWalker)queue.top();
                walker.collectCurrent();
                if (walker.nextDoc() == Integer.MAX_VALUE || walker.shouldPop()) {
                    queue.pop();
                    continue;
                }
                queue.updateTop();
            } while (queue.size() > 0);
            tsidOrd[0] = tsidOrd[0] + 1;
        }
    }

    public void setProfiler(SearchContext context) {
        if (context.getProfilers() != null && context.getProfilers().getCurrentQueryProfiler() != null) {
            this.searcher.setProfiler(context.getProfilers().getCurrentQueryProfiler());
        }
    }

    private boolean populateQueue(List<LeafWalker> leafWalkers, PriorityQueue<LeafWalker> queue) throws IOException {
        BytesRef currentTsid = null;
        assert (queue.size() == 0);
        Iterator<LeafWalker> it = leafWalkers.iterator();
        while (it.hasNext()) {
            int comp;
            LeafWalker leafWalker = it.next();
            if (leafWalker.docId == Integer.MAX_VALUE) {
                it.remove();
                continue;
            }
            BytesRef tsid = leafWalker.getTsid();
            if (currentTsid == null) {
                currentTsid = tsid;
            }
            if ((comp = tsid.compareTo(currentTsid)) == 0) {
                queue.add((Object)leafWalker);
                continue;
            }
            if ((!this.tsidReverse || comp <= 0) && (this.tsidReverse || comp >= 0)) continue;
            queue.clear();
            queue.add((Object)leafWalker);
            currentTsid = tsid;
        }
        assert (TimeSeriesIndexSearcher.queueAllHaveTsid(queue, currentTsid));
        return queue.size() > 0;
    }

    private static boolean queueAllHaveTsid(PriorityQueue<LeafWalker> queue, BytesRef tsid) throws IOException {
        for (LeafWalker leafWalker : queue) {
            BytesRef walkerId = leafWalker.tsids.lookupOrd(leafWalker.tsids.ordValue());
            assert (walkerId.equals((Object)tsid)) : tsid.utf8ToString() + " != " + walkerId.utf8ToString();
        }
        return true;
    }

    private void checkCancelled() {
        for (Runnable r : this.cancellations) {
            r.run();
        }
    }

    private static class LeafWalker {
        private final LeafBucketCollector collector;
        private final Bits liveDocs;
        private final DocIdSetIterator iterator;
        private final SortedDocValues tsids;
        private final SortedNumericDocValues timestamps;
        private final BytesRefBuilder scratch = new BytesRefBuilder();
        private final Scorer scorer;
        int docId = -1;
        int tsidOrd;
        long timestamp;

        LeafWalker(LeafReaderContext context, Scorer scorer, BucketCollector bucketCollector, IntSupplier tsidOrdSupplier) throws IOException {
            AggregationExecutionContext aggCtx = new AggregationExecutionContext(context, () -> ((BytesRefBuilder)this.scratch).get(), () -> this.timestamp, tsidOrdSupplier);
            this.collector = bucketCollector.getLeafCollector(aggCtx);
            this.liveDocs = context.reader().getLiveDocs();
            this.collector.setScorer((Scorable)scorer);
            this.scorer = scorer;
            this.iterator = scorer.iterator();
            this.tsids = DocValues.getSorted((LeafReader)context.reader(), (String)"_tsid");
            this.timestamps = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)"@timestamp");
        }

        void collectCurrent() throws IOException {
            assert (this.tsids.docID() == this.docId);
            assert (this.timestamps.docID() == this.docId);
            this.collector.collect(this.docId);
        }

        int nextDoc() throws IOException {
            if (this.docId == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            do {
                this.docId = this.iterator.nextDoc();
            } while (this.docId != Integer.MAX_VALUE && this.isInvalidDoc(this.docId));
            if (this.docId != Integer.MAX_VALUE) {
                this.timestamp = this.timestamps.nextValue();
            }
            return this.docId;
        }

        BytesRef getTsid() throws IOException {
            this.tsidOrd = this.tsids.ordValue();
            this.scratch.copyBytes(this.tsids.lookupOrd(this.tsidOrd));
            return this.scratch.get();
        }

        private boolean isInvalidDoc(int docId) throws IOException {
            return this.liveDocs != null && !this.liveDocs.get(docId) || !this.tsids.advanceExact(docId) || !this.timestamps.advanceExact(docId);
        }

        boolean shouldPop() throws IOException {
            return this.tsidOrd != this.tsids.ordValue();
        }
    }
}

