/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import java.io.IOException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.IndexOrdinalsFieldData;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.RangeFieldMapper;
import org.elasticsearch.script.AggregationScript;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.FieldContext;
import org.elasticsearch.search.aggregations.support.MissingValues;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum CoreValuesSourceType implements ValuesSourceType
{
    NUMERIC{

        @Override
        public ValuesSource getEmpty() {
            return ValuesSource.Numeric.EMPTY;
        }

        @Override
        public ValuesSource getScript(AggregationScript.LeafFactory script, ValueType scriptValueType) {
            return new ValuesSource.Numeric.Script(script, scriptValueType);
        }

        @Override
        public ValuesSource getField(FieldContext fieldContext, AggregationScript.LeafFactory script) {
            if (!(fieldContext.indexFieldData() instanceof IndexNumericFieldData)) {
                throw new IllegalArgumentException("Expected numeric type on field [" + fieldContext.field() + "], but got [" + fieldContext.fieldType().typeName() + "]");
            }
            ValuesSource.Numeric dataSource = new ValuesSource.Numeric.FieldData((IndexNumericFieldData)fieldContext.indexFieldData());
            if (script != null) {
                dataSource = new ValuesSource.Numeric.WithScript(dataSource, script);
            }
            return dataSource;
        }

        @Override
        public ValuesSource replaceMissing(ValuesSource valuesSource, Object rawMissing, DocValueFormat docValueFormat, AggregationContext context) {
            Number missing = rawMissing instanceof Number ? (Number)((Number)rawMissing) : (Number)docValueFormat.parseDouble(rawMissing.toString(), false, context::nowInMillis);
            return MissingValues.replaceMissing((ValuesSource.Numeric)valuesSource, missing);
        }

        @Override
        public DocValueFormat getFormatter(String format, ZoneId tz) {
            if (format == null) {
                return DocValueFormat.RAW;
            }
            return new DocValueFormat.Decimal(format);
        }
    }
    ,
    KEYWORD{

        @Override
        public ValuesSource getEmpty() {
            return ValuesSource.Bytes.WithOrdinals.EMPTY;
        }

        @Override
        public ValuesSource getScript(AggregationScript.LeafFactory script, ValueType scriptValueType) {
            return new ValuesSource.Bytes.Script(script);
        }

        @Override
        public ValuesSource getField(FieldContext fieldContext, AggregationScript.LeafFactory script) {
            IndexFieldData<?> indexFieldData = fieldContext.indexFieldData();
            ValuesSource.Bytes dataSource = indexFieldData instanceof IndexOrdinalsFieldData ? new ValuesSource.Bytes.WithOrdinals.FieldData((IndexOrdinalsFieldData)indexFieldData) : new ValuesSource.Bytes.FieldData(indexFieldData);
            if (script != null) {
                dataSource = new ValuesSource.Bytes.WithScript(dataSource, script);
            }
            return dataSource;
        }

        @Override
        public ValuesSource replaceMissing(ValuesSource valuesSource, Object rawMissing, DocValueFormat docValueFormat, AggregationContext context) {
            BytesRef missing = docValueFormat.parseBytesRef(rawMissing.toString());
            if (valuesSource instanceof ValuesSource.Bytes.WithOrdinals) {
                return MissingValues.replaceMissing((ValuesSource.Bytes.WithOrdinals)valuesSource, missing);
            }
            return MissingValues.replaceMissing((ValuesSource.Bytes)valuesSource, missing);
        }
    }
    ,
    GEOPOINT{

        @Override
        public ValuesSource getEmpty() {
            return ValuesSource.GeoPoint.EMPTY;
        }

        @Override
        public ValuesSource getScript(AggregationScript.LeafFactory script, ValueType scriptValueType) {
            throw new AggregationExecutionException("value source of type [" + this.value() + "] is not supported by scripts");
        }

        @Override
        public ValuesSource getField(FieldContext fieldContext, AggregationScript.LeafFactory script) {
            IndexFieldData<?> indexFieldData = fieldContext.indexFieldData();
            if (indexFieldData instanceof IndexGeoPointFieldData) {
                IndexGeoPointFieldData pointFieldData = (IndexGeoPointFieldData)indexFieldData;
                return new ValuesSource.GeoPoint.Fielddata(pointFieldData);
            }
            throw new IllegalArgumentException("Expected geo_point type on field [" + fieldContext.field() + "], but got [" + fieldContext.fieldType().typeName() + "]");
        }

        @Override
        public ValuesSource replaceMissing(ValuesSource valuesSource, Object rawMissing, DocValueFormat docValueFormat, AggregationContext context) {
            GeoPoint missing = new GeoPoint(rawMissing.toString());
            return MissingValues.replaceMissing((ValuesSource.GeoPoint)valuesSource, missing);
        }

        @Override
        public DocValueFormat getFormatter(String format, ZoneId tz) {
            return DocValueFormat.GEOHASH;
        }
    }
    ,
    RANGE{

        @Override
        public ValuesSource getEmpty() {
            throw new IllegalArgumentException("Can't deal with unmapped ValuesSource type " + this.value());
        }

        @Override
        public ValuesSource getScript(AggregationScript.LeafFactory script, ValueType scriptValueType) {
            throw new AggregationExecutionException("value source of type [" + this.value() + "] is not supported by scripts");
        }

        @Override
        public ValuesSource getField(FieldContext fieldContext, AggregationScript.LeafFactory script) {
            MappedFieldType fieldType = fieldContext.fieldType();
            if (!(fieldType instanceof RangeFieldMapper.RangeFieldType)) {
                throw new IllegalArgumentException("Asked for range ValuesSource, but field is of type " + fieldType.name());
            }
            RangeFieldMapper.RangeFieldType rangeFieldType = (RangeFieldMapper.RangeFieldType)fieldType;
            return new ValuesSource.Range(fieldContext.indexFieldData(), rangeFieldType.rangeType());
        }

        @Override
        public ValuesSource replaceMissing(ValuesSource valuesSource, Object rawMissing, DocValueFormat docValueFormat, AggregationContext context) {
            throw new IllegalArgumentException("Can't apply missing values on a " + valuesSource.getClass());
        }
    }
    ,
    IP{

        @Override
        public ValuesSource getEmpty() {
            return KEYWORD.getEmpty();
        }

        @Override
        public ValuesSource getScript(AggregationScript.LeafFactory script, ValueType scriptValueType) {
            return KEYWORD.getScript(script, scriptValueType);
        }

        @Override
        public ValuesSource getField(FieldContext fieldContext, AggregationScript.LeafFactory script) {
            return KEYWORD.getField(fieldContext, script);
        }

        @Override
        public ValuesSource replaceMissing(ValuesSource valuesSource, Object rawMissing, DocValueFormat docValueFormat, AggregationContext context) {
            return KEYWORD.replaceMissing(valuesSource, rawMissing, docValueFormat, context);
        }

        @Override
        public DocValueFormat getFormatter(String format, ZoneId tz) {
            return DocValueFormat.IP;
        }
    }
    ,
    DATE{

        @Override
        public ValuesSource getEmpty() {
            return NUMERIC.getEmpty();
        }

        @Override
        public ValuesSource getScript(AggregationScript.LeafFactory script, ValueType scriptValueType) {
            return NUMERIC.getScript(script, scriptValueType);
        }

        @Override
        public ValuesSource getField(FieldContext fieldContext, AggregationScript.LeafFactory script) {
            ValuesSource.Numeric dataSource = this.fieldData(fieldContext);
            if (script != null) {
                return new ValuesSource.Numeric.WithScript(dataSource, script);
            }
            return dataSource;
        }

        private ValuesSource.Numeric fieldData(final FieldContext fieldContext) {
            if (!(fieldContext.indexFieldData() instanceof IndexNumericFieldData)) {
                throw new IllegalArgumentException("Expected numeric type on field [" + fieldContext.field() + "], but got [" + fieldContext.fieldType().typeName() + "]");
            }
            if (!(fieldContext.fieldType() instanceof DateFieldMapper.DateFieldType)) {
                return new ValuesSource.Numeric.FieldData((IndexNumericFieldData)fieldContext.indexFieldData());
            }
            return new ValuesSource.Numeric.FieldData((IndexNumericFieldData)fieldContext.indexFieldData()){

                @Override
                public Function<Rounding, Rounding.Prepared> roundingPreparer(AggregationContext context) throws IOException {
                    final DateFieldMapper.DateFieldType dft = (DateFieldMapper.DateFieldType)fieldContext.fieldType();
                    final long[] range = new long[]{Long.MIN_VALUE, Long.MAX_VALUE};
                    if (fieldContext.fieldType().isIndexed()) {
                        log.trace("Attempting to apply index bound date rounding");
                        byte[] min = PointValues.getMinPackedValue((IndexReader)context.searcher().getIndexReader(), (String)fieldContext.field());
                        if (min != null) {
                            byte[] max = PointValues.getMaxPackedValue((IndexReader)context.searcher().getIndexReader(), (String)fieldContext.field());
                            range[0] = dft.resolution().parsePointAsMillis(min);
                            range[1] = dft.resolution().parsePointAsMillis(max);
                        }
                    }
                    log.trace("Bounds after index bound date rounding: {}, {}", (Object)range[0], (Object)range[1]);
                    boolean isMultiValue = false;
                    for (LeafReaderContext leaf : context.searcher().getLeafContexts()) {
                        if (fieldContext.fieldType().isIndexed()) {
                            PointValues pointValues = leaf.reader().getPointValues(fieldContext.field());
                            if (pointValues == null || pointValues.size() == (long)pointValues.getDocCount()) continue;
                            isMultiValue = true;
                            continue;
                        }
                        if (!fieldContext.fieldType().hasDocValues() || DocValues.unwrapSingleton((SortedNumericDocValues)leaf.reader().getSortedNumericDocValues(fieldContext.field())) != null) continue;
                        isMultiValue = true;
                    }
                    if (context.query() != null && !isMultiValue) {
                        log.trace("Attempting to apply query bound rounding");
                        context.query().visit(new QueryVisitor(){

                            public QueryVisitor getSubVisitor(BooleanClause.Occur occur, Query parent) {
                                switch (occur) {
                                    case MUST: 
                                    case FILTER: {
                                        return this;
                                    }
                                }
                                return QueryVisitor.EMPTY_VISITOR;
                            }

                            public boolean acceptField(String field) {
                                return field.equals(fieldContext.fieldType().name());
                            }

                            public void visitLeaf(Query query) {
                                if (query instanceof PointRangeQuery) {
                                    PointRangeQuery prq = (PointRangeQuery)query;
                                    range[0] = Math.max(range[0], dft.resolution().parsePointAsMillis(prq.getLowerPoint()));
                                    range[1] = Math.min(range[1], dft.resolution().parsePointAsMillis(prq.getUpperPoint()));
                                }
                            }
                        });
                    }
                    log.trace("Bounds after query bound date rounding: {}, {}", (Object)range[0], (Object)range[1]);
                    if (range[0] == Long.MIN_VALUE && range[1] == Long.MAX_VALUE) {
                        log.trace("Unable to find rounding bounds");
                        return Rounding::prepareForUnknown;
                    }
                    if (range[0] > range[1]) {
                        return Rounding::prepareForUnknown;
                    }
                    return rounding -> rounding.prepare(range[0], range[1]);
                }
            };
        }

        @Override
        public ValuesSource replaceMissing(ValuesSource valuesSource, Object rawMissing, DocValueFormat docValueFormat, AggregationContext context) {
            return NUMERIC.replaceMissing(valuesSource, rawMissing, docValueFormat, context);
        }

        @Override
        public DocValueFormat getFormatter(String format, ZoneId tz) {
            return new DocValueFormat.DateTime(format == null ? DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER : DateFormatter.forPattern(format), tz == null ? ZoneOffset.UTC : tz, DateFieldMapper.Resolution.MILLISECONDS);
        }
    }
    ,
    BOOLEAN{

        @Override
        public ValuesSource getEmpty() {
            return NUMERIC.getEmpty();
        }

        @Override
        public ValuesSource getScript(AggregationScript.LeafFactory script, ValueType scriptValueType) {
            return NUMERIC.getScript(script, scriptValueType);
        }

        @Override
        public ValuesSource getField(FieldContext fieldContext, AggregationScript.LeafFactory script) {
            return NUMERIC.getField(fieldContext, script);
        }

        @Override
        public ValuesSource replaceMissing(ValuesSource valuesSource, Object rawMissing, DocValueFormat docValueFormat, AggregationContext context) {
            return NUMERIC.replaceMissing(valuesSource, rawMissing, docValueFormat, context);
        }

        @Override
        public DocValueFormat getFormatter(String format, ZoneId tz) {
            return DocValueFormat.BOOLEAN;
        }
    };

    public static final Logger log;
    public static List<ValuesSourceType> ALL_CORE;

    public static ValuesSourceType fromString(String name) {
        return CoreValuesSourceType.valueOf(name.trim().toUpperCase(Locale.ROOT));
    }

    public String value() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    @Override
    public String typeName() {
        return this.value();
    }

    static {
        log = LogManager.getLogger(CoreValuesSourceType.class);
        ALL_CORE = Arrays.asList(CoreValuesSourceType.values());
    }
}

