/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.HdrHistogram.DoubleHistogram;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.AbstractHDRPercentilesAggregator;
import org.elasticsearch.search.aggregations.metrics.InternalHDRPercentileRanks;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

class HDRPercentileRanksAggregator
extends AbstractHDRPercentilesAggregator {
    HDRPercentileRanksAggregator(String name, ValuesSourceConfig config, AggregationContext context, Aggregator parent, double[] percents, int numberOfSignificantValueDigits, boolean keyed, DocValueFormat format, Map<String, Object> metadata) throws IOException {
        super(name, config, context, parent, percents, numberOfSignificantValueDigits, keyed, format, metadata);
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        DoubleHistogram state = this.getState(owningBucketOrdinal);
        if (state == null) {
            return this.buildEmptyAggregation();
        }
        return new InternalHDRPercentileRanks(this.name, this.keys, state, this.keyed, this.format, this.metadata());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return InternalHDRPercentileRanks.empty(this.name, this.keys, this.keyed, this.format, this.metadata());
    }

    @Override
    public double metric(String name, long bucketOrd) {
        DoubleHistogram state = this.getState(bucketOrd);
        if (state == null) {
            return Double.NaN;
        }
        return InternalHDRPercentileRanks.percentileRank(state, Double.valueOf(name));
    }
}

