/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.composite;

import java.io.IOException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceConfig;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceParserHelper;
import org.elasticsearch.search.aggregations.bucket.composite.DateHistogramValuesSource;
import org.elasticsearch.search.aggregations.bucket.composite.MissingOrder;
import org.elasticsearch.search.aggregations.bucket.composite.RoundingValuesSource;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.DateIntervalConsumer;
import org.elasticsearch.search.aggregations.bucket.histogram.DateIntervalWrapper;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class DateHistogramValuesSourceBuilder
extends CompositeValuesSourceBuilder<DateHistogramValuesSourceBuilder>
implements DateIntervalConsumer<DateHistogramValuesSourceBuilder> {
    static final String TYPE = "date_histogram";
    static final ValuesSourceRegistry.RegistryKey<DateHistogramCompositeSupplier> REGISTRY_KEY = new ValuesSourceRegistry.RegistryKey<DateHistogramCompositeSupplier>("date_histogram", DateHistogramCompositeSupplier.class);
    static final ObjectParser<DateHistogramValuesSourceBuilder, String> PARSER = ObjectParser.fromBuilder((String)"date_histogram", DateHistogramValuesSourceBuilder::new);
    private ZoneId timeZone = null;
    private DateIntervalWrapper dateHistogramInterval = new DateIntervalWrapper();
    private long offset = 0L;

    public DateHistogramValuesSourceBuilder(String name) {
        super(name);
    }

    protected DateHistogramValuesSourceBuilder(StreamInput in) throws IOException {
        super(in);
        this.dateHistogramInterval = new DateIntervalWrapper(in);
        this.timeZone = in.readOptionalZoneId();
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_7_6_0)) {
            this.offset = in.readLong();
        }
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        this.dateHistogramInterval.writeTo(out);
        out.writeOptionalZoneId(this.timeZone);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_7_6_0)) {
            out.writeLong(this.offset);
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.dateHistogramInterval.toXContent(builder, params);
        if (this.timeZone != null) {
            builder.field("time_zone", this.timeZone.toString());
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.dateHistogramInterval, this.timeZone);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        DateHistogramValuesSourceBuilder other = (DateHistogramValuesSourceBuilder)obj;
        return Objects.equals(this.dateHistogramInterval, other.dateHistogramInterval) && Objects.equals(this.timeZone, other.timeZone);
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public DateHistogramValuesSourceBuilder calendarInterval(DateHistogramInterval interval) {
        this.dateHistogramInterval.calendarInterval(interval);
        return this;
    }

    @Override
    public DateHistogramValuesSourceBuilder fixedInterval(DateHistogramInterval interval) {
        this.dateHistogramInterval.fixedInterval(interval);
        return this;
    }

    public DateHistogramInterval getIntervalAsCalendar() {
        if (this.dateHistogramInterval.getIntervalType().equals(DateIntervalWrapper.IntervalTypeEnum.CALENDAR)) {
            return this.dateHistogramInterval.getAsCalendarInterval();
        }
        return null;
    }

    public DateHistogramInterval getIntervalAsFixed() {
        if (this.dateHistogramInterval.getIntervalType().equals(DateIntervalWrapper.IntervalTypeEnum.FIXED)) {
            return this.dateHistogramInterval.getAsFixedInterval();
        }
        return null;
    }

    public DateHistogramValuesSourceBuilder timeZone(ZoneId timeZone) {
        if (timeZone == null) {
            throw new IllegalArgumentException("[timeZone] must not be null: [" + this.name + "]");
        }
        this.timeZone = timeZone;
        return this;
    }

    @Override
    public ZoneId timeZone() {
        return this.timeZone;
    }

    public long offset() {
        return this.offset;
    }

    public DateHistogramValuesSourceBuilder offset(long offset) {
        this.offset = offset;
        return this;
    }

    public static void register(ValuesSourceRegistry.Builder builder) {
        builder.register(REGISTRY_KEY, List.of(CoreValuesSourceType.DATE, CoreValuesSourceType.NUMERIC), (valuesSourceConfig, rounding, name, hasScript, format, missingBucket, missingOrder, order) -> {
            ValuesSource.Numeric numeric = (ValuesSource.Numeric)valuesSourceConfig.getValuesSource();
            Rounding.Prepared preparedRounding = rounding.prepareForUnknown();
            RoundingValuesSource vs = new RoundingValuesSource(numeric, preparedRounding);
            DocValueFormat docValueFormat = format == null ? DocValueFormat.RAW : valuesSourceConfig.format();
            MappedFieldType fieldType = valuesSourceConfig.fieldType();
            return new CompositeValuesSourceConfig(name, fieldType, vs, docValueFormat, order, missingBucket, missingOrder, hasScript, (bigArrays, reader, size, addRequestCircuitBreakerBytes, compositeValuesSourceConfig) -> {
                RoundingValuesSource roundingValuesSource = (RoundingValuesSource)compositeValuesSourceConfig.valuesSource();
                return new DateHistogramValuesSource(bigArrays, compositeValuesSourceConfig.fieldType(), roundingValuesSource, compositeValuesSourceConfig.format(), compositeValuesSourceConfig.missingBucket(), compositeValuesSourceConfig.missingOrder(), size, compositeValuesSourceConfig.reverseMul());
            });
        }, false);
    }

    @Override
    protected ValuesSourceType getDefaultValuesSourceType() {
        return CoreValuesSourceType.DATE;
    }

    @Override
    protected CompositeValuesSourceConfig innerBuild(ValuesSourceRegistry registry, ValuesSourceConfig config) throws IOException {
        Rounding rounding = this.dateHistogramInterval.createRounding(this.timeZone(), this.offset);
        return registry.getAggregator(REGISTRY_KEY, config).apply(config, rounding, this.name, config.script() != null, this.format(), this.missingBucket(), this.missingOrder(), this.order());
    }

    static {
        PARSER.declareString(CompositeValuesSourceBuilder::format, new ParseField("format", new String[0]));
        DateIntervalWrapper.declareIntervalFields(PARSER);
        PARSER.declareField(DateHistogramValuesSourceBuilder::offset, p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                return p.longValue();
            }
            return DateHistogramAggregationBuilder.parseStringOffset(p.text());
        }, Histogram.OFFSET_FIELD, ObjectParser.ValueType.LONG);
        PARSER.declareField(DateHistogramValuesSourceBuilder::timeZone, p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return ZoneId.of(p.text());
            }
            return ZoneOffset.ofHours(p.intValue());
        }, new ParseField("time_zone", new String[0]), ObjectParser.ValueType.LONG);
        CompositeValuesSourceParserHelper.declareValuesSourceFields(PARSER);
    }

    @FunctionalInterface
    public static interface DateHistogramCompositeSupplier {
        public CompositeValuesSourceConfig apply(ValuesSourceConfig var1, Rounding var2, String var3, boolean var4, String var5, boolean var6, MissingOrder var7, SortOrder var8);
    }
}

