/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.internal.TwoPhaseCollector;

public abstract class BucketCollector {
    public static final BucketCollector NO_OP_BUCKET_COLLECTOR = new BucketCollector(){

        @Override
        public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }

        @Override
        public void preCollection() throws IOException {
        }

        @Override
        public void postCollection() throws IOException {
        }

        @Override
        public ScoreMode scoreMode() {
            return ScoreMode.COMPLETE_NO_SCORES;
        }
    };
    public static final Collector NO_OP_COLLECTOR = new Collector(){

        public LeafCollector getLeafCollector(LeafReaderContext context) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }

        public ScoreMode scoreMode() {
            return ScoreMode.COMPLETE_NO_SCORES;
        }
    };

    public abstract LeafBucketCollector getLeafCollector(AggregationExecutionContext var1) throws IOException;

    public abstract void preCollection() throws IOException;

    public abstract void postCollection() throws IOException;

    public abstract ScoreMode scoreMode();

    public final Collector asCollector() {
        return new BucketCollectorWrapper(this);
    }

    public record BucketCollectorWrapper(BucketCollector bucketCollector) implements TwoPhaseCollector
    {
        public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            return this.bucketCollector.getLeafCollector(new AggregationExecutionContext(context, null, null, null));
        }

        public ScoreMode scoreMode() {
            return this.bucketCollector.scoreMode();
        }

        @Override
        public void doPostCollection() throws IOException {
            this.bucketCollector.postCollection();
        }
    }
}

