/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import org.apache.lucene.index.IndexCommit;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.common.util.concurrent.RunOnce;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.index.engine.Engine;

public class SnapshotIndexCommit
extends AbstractRefCounted {
    private final Engine.IndexCommitRef commitRef;
    private final Runnable releaseInitialRef;
    private final SubscribableListener<Void> completionListeners = new SubscribableListener();

    public SnapshotIndexCommit(Engine.IndexCommitRef commitRef) {
        this.commitRef = commitRef;
        this.releaseInitialRef = new RunOnce(() -> ((SnapshotIndexCommit)this).decRef());
    }

    protected void closeInternal() {
        assert (!this.completionListeners.isDone());
        ActionListener.completeWith(this.completionListeners, () -> {
            this.commitRef.close();
            return null;
        });
    }

    private void onCompletion(ActionListener<Void> completionListener) {
        this.releaseInitialRef.run();
        assert (this.refCount() <= 1);
        this.completionListeners.addListener(completionListener);
    }

    public void onAbort() {
        this.releaseInitialRef.run();
    }

    public IndexCommit indexCommit() {
        assert (this.hasReferences());
        return this.commitRef.getIndexCommit();
    }

    public <T> ActionListener<T> closingBefore(final ActionListener<T> delegate) {
        return new ActionListener<T>(){

            @Override
            public void onResponse(T result) {
                SnapshotIndexCommit.this.onCompletion(delegate.map(ignored -> result));
            }

            @Override
            public void onFailure(final Exception e) {
                SnapshotIndexCommit.this.onCompletion(new ActionListener<Void>(){

                    @Override
                    public void onResponse(Void unused) {
                        delegate.onFailure(e);
                    }

                    @Override
                    public void onFailure(Exception e2) {
                        if (e2 != e) {
                            e.addSuppressed(e2);
                        }
                        delegate.onFailure(e);
                    }
                });
            }
        };
    }
}

