/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.inference;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.VersionedNamedWriteable;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class ModelConfigurations
implements ToXContentObject,
VersionedNamedWriteable {
    public static final String MODEL_ID = "model_id";
    public static final String SERVICE = "service";
    public static final String SERVICE_SETTINGS = "service_settings";
    public static final String TASK_SETTINGS = "task_settings";
    private static final String NAME = "inference_model";
    private final String modelId;
    private final TaskType taskType;
    private final String service;
    private final ServiceSettings serviceSettings;
    private final TaskSettings taskSettings;

    public ModelConfigurations(String modelId, TaskType taskType, String service, ServiceSettings serviceSettings, TaskSettings taskSettings) {
        this.modelId = modelId;
        this.taskType = taskType;
        this.service = service;
        this.serviceSettings = serviceSettings;
        this.taskSettings = taskSettings;
    }

    public ModelConfigurations(StreamInput in) throws IOException {
        this.modelId = in.readString();
        this.taskType = in.readEnum(TaskType.class);
        this.service = in.readString();
        this.serviceSettings = in.readNamedWriteable(ServiceSettings.class);
        this.taskSettings = in.readNamedWriteable(TaskSettings.class);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.modelId);
        out.writeEnum(this.taskType);
        out.writeString(this.service);
        out.writeNamedWriteable(this.serviceSettings);
        out.writeNamedWriteable(this.taskSettings);
    }

    public String getModelId() {
        return this.modelId;
    }

    public TaskType getTaskType() {
        return this.taskType;
    }

    public String getService() {
        return this.service;
    }

    public ServiceSettings getServiceSettings() {
        return this.serviceSettings;
    }

    public TaskSettings getTaskSettings() {
        return this.taskSettings;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(MODEL_ID, this.modelId);
        builder.field(TaskType.NAME, this.taskType.toString());
        builder.field(SERVICE, this.service);
        builder.field(SERVICE_SETTINGS, (ToXContent)this.serviceSettings);
        builder.field(TASK_SETTINGS, (ToXContent)this.taskSettings);
        builder.endObject();
        return builder;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_500_074;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelConfigurations model = (ModelConfigurations)o;
        return Objects.equals(this.modelId, model.modelId) && this.taskType == model.taskType && Objects.equals(this.service, model.service) && Objects.equals(this.serviceSettings, model.serviceSettings) && Objects.equals(this.taskSettings, model.taskSettings);
    }

    public int hashCode() {
        return Objects.hash(this.modelId, this.taskType, this.service, this.serviceSettings, this.taskSettings);
    }
}

