/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.inference;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.inference.InferenceService;
import org.elasticsearch.plugins.InferenceServicePlugin;

public class InferenceServiceRegistry
extends AbstractLifecycleComponent {
    private final Map<String, InferenceService> services;
    private final List<NamedWriteableRegistry.Entry> namedWriteables = new ArrayList<NamedWriteableRegistry.Entry>();

    public InferenceServiceRegistry(List<InferenceServicePlugin> inferenceServicePlugins, InferenceServicePlugin.InferenceServiceFactoryContext factoryContext) {
        this.services = inferenceServicePlugins.stream().flatMap(r -> r.getInferenceServiceFactories().stream()).map(factory -> factory.create(factoryContext)).collect(Collectors.toMap(InferenceService::name, Function.identity()));
        for (InferenceServicePlugin plugin : inferenceServicePlugins) {
            this.namedWriteables.addAll(plugin.getInferenceServiceNamedWriteables());
        }
    }

    public Map<String, InferenceService> getServices() {
        return this.services;
    }

    public Optional<InferenceService> getService(String serviceName) {
        return Optional.ofNullable(this.services.get(serviceName));
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return this.namedWriteables;
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
    }

    @Override
    protected void doClose() throws IOException {
    }
}

