/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import java.io.Closeable;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.LongUnaryOperator;
import java.util.function.Predicate;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.BufferedChecksum;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Version;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.env.ShardLock;
import org.elasticsearch.env.ShardLockObtainFailedException;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.engine.CombinedDeletionPolicy;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.seqno.SequenceNumbers;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.ByteSizeCachingDirectory;
import org.elasticsearch.index.store.ByteSizeDirectory;
import org.elasticsearch.index.store.ImmutableDirectoryException;
import org.elasticsearch.index.store.StoreFileMetadata;
import org.elasticsearch.index.store.StoreStats;
import org.elasticsearch.index.store.VerifyingIndexOutput;
import org.elasticsearch.index.translog.Translog;

public class Store
extends AbstractIndexShardComponent
implements Closeable,
RefCounted {
    @Deprecated
    public static final Setting<Boolean> FORCE_RAM_TERM_DICT = Setting.boolSetting("index.force_memory_term_dictionary", false, Setting.Property.IndexScope, Setting.Property.IndexSettingDeprecatedInV7AndRemovedInV8);
    static final String CODEC = "store";
    static final int CORRUPTED_MARKER_CODEC_VERSION = 2;
    public static final String CORRUPTED_MARKER_NAME_PREFIX = "corrupted_";
    public static final Setting<TimeValue> INDEX_STORE_STATS_REFRESH_INTERVAL_SETTING = Setting.timeSetting("index.store.stats_refresh_interval", TimeValue.timeValueSeconds((long)10L), Setting.Property.IndexScope);
    public static final IOContext READONCE_CHECKSUM = new IOContext(IOContext.READONCE, true);
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final StoreDirectory directory;
    private final ReentrantReadWriteLock metadataLock = new ReentrantReadWriteLock();
    private final ShardLock shardLock;
    private final OnClose onClose;
    private final AbstractRefCounted refCounter = AbstractRefCounted.of(this::closeInternal);

    public Store(ShardId shardId, IndexSettings indexSettings, Directory directory, ShardLock shardLock) {
        this(shardId, indexSettings, directory, shardLock, OnClose.EMPTY);
    }

    public Store(ShardId shardId, IndexSettings indexSettings, Directory directory, ShardLock shardLock, OnClose onClose) {
        super(shardId, indexSettings);
        this.directory = new StoreDirectory(Store.byteSizeDirectory(directory, indexSettings, this.logger), Loggers.getLogger("index.store.deletes", shardId));
        this.shardLock = shardLock;
        this.onClose = onClose;
        assert (onClose != null);
        assert (shardLock != null);
        assert (shardLock.getShardId().equals(shardId));
    }

    public Directory directory() {
        this.ensureOpen();
        return this.directory;
    }

    public SegmentInfos readLastCommittedSegmentsInfo() throws IOException {
        this.failIfCorrupted();
        try {
            return Store.readSegmentsInfo(null, this.directory());
        }
        catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {
            this.markStoreCorrupted((IOException)ex);
            throw ex;
        }
    }

    private static SegmentInfos readSegmentsInfo(IndexCommit commit, Directory directory) throws IOException {
        assert (commit == null || commit.getDirectory() == directory);
        try {
            return commit == null ? Lucene.readSegmentInfos(directory) : Lucene.readSegmentInfos(commit);
        }
        catch (EOFException eof) {
            throw new CorruptIndexException("Read past EOF while reading segment infos", "commit(" + commit + ")", (Throwable)eof);
        }
        catch (IOException exception) {
            throw exception;
        }
        catch (Exception ex) {
            throw new CorruptIndexException("Hit unexpected exception while reading segment infos", "commit(" + commit + ")", (Throwable)ex);
        }
    }

    final void ensureOpen() {
        if (this.refCounter.refCount() <= 0) {
            throw new AlreadyClosedException("store is already closed");
        }
    }

    public MetadataSnapshot getMetadata(IndexCommit commit) throws IOException {
        return this.getMetadata(commit, false);
    }

    public MetadataSnapshot getMetadata(IndexCommit commit, boolean lockDirectory) throws IOException {
        this.ensureOpen();
        this.failIfCorrupted();
        assert (!lockDirectory || commit == null) : "IW lock should not be obtained if there is a commit point available";
        java.util.concurrent.locks.Lock lock = lockDirectory ? this.metadataLock.writeLock() : this.metadataLock.readLock();
        lock.lock();
        try {
            MetadataSnapshot metadataSnapshot;
            block12: {
                Closeable ignored = lockDirectory ? this.directory.obtainLock("write.lock") : () -> {};
                try {
                    metadataSnapshot = MetadataSnapshot.loadFromIndexCommit(commit, (Directory)this.directory, this.logger);
                    if (ignored == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {
                        this.markStoreCorrupted((IOException)ex);
                        throw ex;
                    }
                }
                ignored.close();
            }
            return metadataSnapshot;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameTempFilesSafe(Map<String, String> tempFileMap) throws IOException {
        Object[] entries = tempFileMap.entrySet().toArray(new Map.Entry[0]);
        ArrayUtil.timSort((Object[])entries, (o1, o2) -> {
            String left = (String)o1.getValue();
            String right = (String)o2.getValue();
            if (left.startsWith("segments") || right.startsWith("segments")) {
                if (!left.startsWith("segments")) {
                    return -1;
                }
                if (!right.startsWith("segments")) {
                    return 1;
                }
            }
            return left.compareTo(right);
        });
        this.metadataLock.writeLock().lock();
        try (Lock writeLock = this.directory().obtainLock("write.lock");){
            for (Object entry : entries) {
                String tempFile = (String)entry.getKey();
                String origFile = (String)entry.getValue();
                try {
                    this.directory.deleteFile(origFile);
                }
                catch (FileNotFoundException | NoSuchFileException iOException) {
                }
                catch (Exception ex) {
                    this.logger.debug(() -> "failed to delete file [" + origFile + "]", (Throwable)ex);
                }
                this.directory.rename(tempFile, origFile);
                String remove = tempFileMap.remove(tempFile);
                assert (remove != null);
            }
            this.directory.syncMetaData();
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
    }

    public CheckIndex.Status checkIndex(PrintStream out) throws IOException {
        this.metadataLock.writeLock().lock();
        try {
            CheckIndex.Status status;
            try (CheckIndex checkIndex = new CheckIndex((Directory)this.directory);){
                checkIndex.setThreadCount(1);
                checkIndex.setInfoStream(out);
                status = checkIndex.checkIndex();
            }
            return status;
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
    }

    public StoreStats stats(long reservedBytes, LongUnaryOperator localSizeFunction) throws IOException {
        this.ensureOpen();
        long sizeInBytes = this.directory.estimateSizeInBytes();
        long dataSetSizeInBytes = this.directory.estimateDataSetSizeInBytes();
        return new StoreStats(localSizeFunction.applyAsLong(sizeInBytes), dataSetSizeInBytes, reservedBytes);
    }

    public final void incRef() {
        this.refCounter.incRef();
    }

    public final boolean tryIncRef() {
        return this.refCounter.tryIncRef();
    }

    public final boolean decRef() {
        return this.refCounter.decRef();
    }

    public final boolean hasReferences() {
        return this.refCounter.hasReferences();
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            this.decRef();
            this.logger.debug("store reference count on close: {}", (Object)this.refCounter.refCount());
        }
    }

    public boolean isClosing() {
        return this.isClosed.get();
    }

    private void closeInternal() {
        try (ShardLock c = this.shardLock;){
            try {
                this.directory.innerClose();
            }
            finally {
                this.onClose.accept(this.shardLock);
            }
        }
        catch (IOException e) {
            assert (false) : e;
            this.logger.warn(() -> "exception on closing store for [" + this.shardId + "]", (Throwable)e);
        }
    }

    private static ByteSizeDirectory byteSizeDirectory(Directory directory, IndexSettings indexSettings, Logger logger) {
        if (directory instanceof ByteSizeDirectory) {
            ByteSizeDirectory byteSizeDirectory = (ByteSizeDirectory)directory;
            return byteSizeDirectory;
        }
        TimeValue refreshInterval = indexSettings.getValue(INDEX_STORE_STATS_REFRESH_INTERVAL_SETTING);
        logger.debug("store stats are refreshed with {} [{}]", (Object)INDEX_STORE_STATS_REFRESH_INTERVAL_SETTING.getKey(), (Object)refreshInterval);
        return new ByteSizeCachingDirectory(directory, refreshInterval);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static MetadataSnapshot readMetadataSnapshot(Path indexLocation, ShardId shardId, NodeEnvironment.ShardLocker shardLocker, Logger logger) throws IOException {
        try (ShardLock lock2 = shardLocker.lock(shardId, "read metadata snapshot", TimeUnit.SECONDS.toMillis(5L));){
            MetadataSnapshot metadataSnapshot;
            try (NIOFSDirectory dir = new NIOFSDirectory(indexLocation);){
                Store.failIfCorrupted((Directory)dir);
                metadataSnapshot = MetadataSnapshot.loadFromIndexCommit(null, (Directory)dir, logger);
            }
            return metadataSnapshot;
        }
        catch (IndexNotFoundException lock2) {
        }
        catch (CorruptIndexException ex) {
            logger.info(() -> Strings.format((String)"%s: corrupted", (Object[])new Object[]{shardId}), (Throwable)ex);
        }
        catch (FileNotFoundException | NoSuchFileException ex) {
            logger.info("Failed to open / find files while reading metadata snapshot", (Throwable)ex);
        }
        catch (ShardLockObtainFailedException ex) {
            logger.info(() -> Strings.format((String)"%s: failed to obtain shard lock", (Object[])new Object[]{shardId}), (Throwable)ex);
        }
        return MetadataSnapshot.EMPTY;
    }

    public static void tryOpenIndex(Path indexLocation, ShardId shardId, NodeEnvironment.ShardLocker shardLocker, Logger logger) throws IOException, ShardLockObtainFailedException {
        try (ShardLock lock = shardLocker.lock(shardId, "open index", TimeUnit.SECONDS.toMillis(5L));
             NIOFSDirectory dir = new NIOFSDirectory(indexLocation);){
            Store.failIfCorrupted((Directory)dir);
            SegmentInfos segInfo = Lucene.readSegmentInfos((Directory)dir);
            logger.trace("{} loaded segment info [{}]", (Object)shardId, (Object)segInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexOutput createVerifyingOutput(String fileName, StoreFileMetadata metadata, IOContext context) throws IOException {
        IndexOutput output = this.directory().createOutput(fileName, context);
        boolean success = false;
        try {
            assert (metadata.writtenBy() != null);
            output = new VerifyingIndexOutput(metadata, output);
            success = true;
        }
        finally {
            if (!success) {
                IOUtils.closeWhileHandlingException((Closeable)output);
            }
        }
        return output;
    }

    public static void verify(IndexOutput output) throws IOException {
        if (output instanceof VerifyingIndexOutput) {
            VerifyingIndexOutput verifyingIndexOutput = (VerifyingIndexOutput)output;
            verifyingIndexOutput.verify();
        }
    }

    public IndexInput openVerifyingInput(String filename, IOContext context, StoreFileMetadata metadata) throws IOException {
        assert (metadata.writtenBy() != null);
        return new VerifyingIndexInput(this.directory().openInput(filename, context));
    }

    public static void verify(IndexInput input) throws IOException {
        if (input instanceof VerifyingIndexInput) {
            ((VerifyingIndexInput)input).verify();
        }
    }

    public boolean checkIntegrityNoException(StoreFileMetadata md) {
        return Store.checkIntegrityNoException(md, this.directory());
    }

    public static boolean checkIntegrityNoException(StoreFileMetadata md, Directory directory) {
        try {
            Store.checkIntegrity(md, directory);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void checkIntegrity(StoreFileMetadata md, Directory directory) throws IOException {
        try (IndexInput input = directory.openInput(md.name(), IOContext.READONCE);){
            if (input.length() != md.length()) {
                throw new CorruptIndexException("expected length=" + md.length() + " != actual length: " + input.length() + " : file truncated?", (DataInput)input);
            }
            String checksum = Store.digestToString(CodecUtil.checksumEntireFile((IndexInput)input));
            if (!checksum.equals(md.checksum())) {
                throw new CorruptIndexException("inconsistent metadata: lucene checksum=" + checksum + ", metadata checksum=" + md.checksum(), (DataInput)input);
            }
        }
    }

    public boolean isMarkedCorrupted() throws IOException {
        String[] files;
        this.ensureOpen();
        for (String file : files = this.directory().listAll()) {
            if (!file.startsWith(CORRUPTED_MARKER_NAME_PREFIX)) continue;
            return true;
        }
        return false;
    }

    public void removeCorruptionMarker() throws IOException {
        String[] files;
        this.ensureOpen();
        Directory directory = this.directory();
        IOException firstException = null;
        for (String file : files = directory.listAll()) {
            if (!file.startsWith(CORRUPTED_MARKER_NAME_PREFIX)) continue;
            try {
                directory.deleteFile(file);
            }
            catch (IOException ex) {
                if (firstException == null) {
                    firstException = ex;
                    continue;
                }
                firstException.addSuppressed(ex);
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public void failIfCorrupted() throws IOException {
        this.ensureOpen();
        Store.failIfCorrupted((Directory)this.directory);
    }

    private static void failIfCorrupted(Directory directory) throws IOException {
        String[] files = directory.listAll();
        ArrayList<CorruptIndexException> ex = new ArrayList<CorruptIndexException>();
        for (String file : files) {
            if (!file.startsWith(CORRUPTED_MARKER_NAME_PREFIX)) continue;
            try (ChecksumIndexInput input = directory.openChecksumInput(file, IOContext.READONCE);){
                CodecUtil.checkHeader((DataInput)input, (String)CODEC, (int)2, (int)2);
                int size = input.readVInt();
                byte[] buffer = new byte[size];
                input.readBytes(buffer, 0, buffer.length);
                StreamInput in = StreamInput.wrap(buffer);
                Object t = in.readException();
                if (t instanceof CorruptIndexException) {
                    ex.add((CorruptIndexException)((Object)t));
                } else {
                    ex.add(new CorruptIndexException(((Throwable)t).getMessage(), "preexisting_corruption", t));
                }
                CodecUtil.checkFooter((ChecksumIndexInput)input);
            }
        }
        if (!ex.isEmpty()) {
            ExceptionsHelper.rethrowAndSuppress(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupAndVerify(String reason, MetadataSnapshot sourceMetadata) throws IOException {
        this.metadataLock.writeLock().lock();
        try (Lock writeLock = this.directory.obtainLock("write.lock");){
            for (String existingFile : this.directory.listAll()) {
                if (Store.isAutogenerated(existingFile) || sourceMetadata.contains(existingFile)) continue;
                try {
                    this.directory.deleteFile(reason, existingFile);
                }
                catch (IOException ex) {
                    if (existingFile.startsWith("segments") || existingFile.startsWith(CORRUPTED_MARKER_NAME_PREFIX)) {
                        throw new IllegalStateException("Can't delete " + existingFile + " - cleanup failed", ex);
                    }
                    this.logger.debug(() -> "failed to delete file [" + existingFile + "]", (Throwable)ex);
                }
            }
            this.directory.syncMetaData();
            MetadataSnapshot metadataOrEmpty = this.getMetadata(null);
            this.verifyAfterCleanup(sourceMetadata, metadataOrEmpty);
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
    }

    final void verifyAfterCleanup(MetadataSnapshot sourceMetadata, MetadataSnapshot targetMetadata) {
        RecoveryDiff recoveryDiff = targetMetadata.recoveryDiff(sourceMetadata);
        if (recoveryDiff.identical.size() != recoveryDiff.size()) {
            if (recoveryDiff.missing.isEmpty()) {
                for (StoreFileMetadata meta : recoveryDiff.different) {
                    StoreFileMetadata remote;
                    StoreFileMetadata local = targetMetadata.get(meta.name());
                    if (local.isSame(remote = sourceMetadata.get(meta.name()))) continue;
                    this.logger.debug("Files are different on the recovery target: {} ", (Object)recoveryDiff);
                    throw new IllegalStateException("local version: " + local + " is different from remote version after recovery: " + remote, null);
                }
            } else {
                this.logger.debug("Files are missing on the recovery target: {} ", (Object)recoveryDiff);
                throw new IllegalStateException("Files are missing on the recovery target: [different=" + recoveryDiff.different + ", missing=" + recoveryDiff.missing + "]", null);
            }
        }
    }

    public int refCount() {
        return this.refCounter.refCount();
    }

    public void beforeClose() {
        this.shardLock.setDetails("closing shard");
    }

    public static boolean isAutogenerated(String name) {
        return "write.lock".equals(name);
    }

    public static String digestToString(long digest) {
        return Long.toString(digest, 36);
    }

    public void deleteQuiet(String ... files) {
        this.ensureOpen();
        StoreDirectory directory = this.directory;
        for (String file : files) {
            try {
                directory.deleteFile("Store.deleteQuiet", file);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void markStoreCorrupted(IOException exception) throws IOException {
        this.ensureOpen();
        if (!this.isMarkedCorrupted()) {
            String corruptionMarkerName = CORRUPTED_MARKER_NAME_PREFIX + UUIDs.randomBase64UUID();
            try (IndexOutput output = this.directory().createOutput(corruptionMarkerName, IOContext.DEFAULT);){
                CodecUtil.writeHeader((DataOutput)output, (String)CODEC, (int)2);
                BytesStreamOutput out = new BytesStreamOutput();
                out.writeException(exception);
                BytesReference bytes = out.bytes();
                output.writeVInt(bytes.length());
                BytesRef ref = bytes.toBytesRef();
                output.writeBytes(ref.bytes, ref.offset, ref.length);
                CodecUtil.writeFooter((IndexOutput)output);
            }
            catch (IOException | ImmutableDirectoryException ex) {
                if (exception != null) {
                    ex.addSuppressed(exception);
                }
                if (ex instanceof ImmutableDirectoryException) {
                    this.logger.debug("Can't mark store with an immutable directory as corrupted", (Throwable)ex);
                }
                this.logger.warn("Can't mark store as corrupted", (Throwable)ex);
            }
            this.directory().sync(Collections.singleton(corruptionMarkerName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createEmpty() throws IOException {
        Version luceneVersion = this.indexSettings.getIndexVersionCreated().luceneVersion();
        this.metadataLock.writeLock().lock();
        try (IndexWriter writer = Store.newTemporaryEmptyIndexWriter((Directory)this.directory, luceneVersion);){
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("history_uuid", UUIDs.randomBase64UUID());
            map.put("local_checkpoint", Long.toString(-1L));
            map.put("max_seq_no", Long.toString(-1L));
            map.put("max_unsafe_auto_id_timestamp", "-1");
            Store.updateCommitData(writer, map);
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bootstrapNewHistory() throws IOException {
        this.metadataLock.writeLock().lock();
        try {
            Map userData = this.readLastCommittedSegmentsInfo().getUserData();
            long maxSeqNo = Long.parseLong((String)userData.get("max_seq_no"));
            long localCheckpoint = Long.parseLong((String)userData.get("local_checkpoint"));
            this.bootstrapNewHistory(localCheckpoint, maxSeqNo);
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bootstrapNewHistory(long localCheckpoint, long maxSeqNo) throws IOException {
        this.metadataLock.writeLock().lock();
        try (IndexWriter writer = Store.newTemporaryAppendingIndexWriter((Directory)this.directory, null);){
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("history_uuid", UUIDs.randomBase64UUID());
            map.put("local_checkpoint", Long.toString(localCheckpoint));
            map.put("max_seq_no", Long.toString(maxSeqNo));
            Store.updateCommitData(writer, map);
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associateIndexWithNewTranslog(String translogUUID) throws IOException {
        this.metadataLock.writeLock().lock();
        try (IndexWriter writer = Store.newTemporaryAppendingIndexWriter((Directory)this.directory, null);){
            if (translogUUID.equals(Store.getUserData(writer).get("translog_uuid"))) {
                throw new IllegalArgumentException("a new translog uuid can't be equal to existing one. got [" + translogUUID + "]");
            }
            Store.updateCommitData(writer, Map.of("translog_uuid", translogUUID));
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimUnsafeCommits(Path translogPath) throws IOException {
        block10: {
            this.metadataLock.writeLock().lock();
            try {
                List existingCommits = DirectoryReader.listCommits((Directory)this.directory);
                assert (!existingCommits.isEmpty());
                IndexCommit lastIndexCommit = (IndexCommit)existingCommits.get(existingCommits.size() - 1);
                String translogUUID = (String)lastIndexCommit.getUserData().get("translog_uuid");
                long lastSyncedGlobalCheckpoint = Translog.readGlobalCheckpoint(translogPath, translogUUID);
                IndexCommit startingIndexCommit = CombinedDeletionPolicy.findSafeCommitPoint(existingCommits, lastSyncedGlobalCheckpoint);
                if (startingIndexCommit.equals((Object)lastIndexCommit)) break block10;
                try (IndexWriter writer = Store.newTemporaryAppendingIndexWriter((Directory)this.directory, startingIndexCommit);){
                    Map userData = startingIndexCommit.getUserData();
                    writer.setLiveCommitData(() -> {
                        HashMap<String, String> updatedUserData = new HashMap<String, String>(userData);
                        updatedUserData.put("es_version", IndexVersion.current().toString());
                        return updatedUserData.entrySet().iterator();
                    });
                    writer.commit();
                }
            }
            finally {
                this.metadataLock.writeLock().unlock();
            }
        }
    }

    public Optional<SequenceNumbers.CommitInfo> findSafeIndexCommit(long globalCheckpoint) throws IOException {
        List commits = DirectoryReader.listCommits((Directory)this.directory);
        assert (!commits.isEmpty()) : "no commit found";
        IndexCommit safeCommit = CombinedDeletionPolicy.findSafeCommitPoint(commits, globalCheckpoint);
        SequenceNumbers.CommitInfo commitInfo = SequenceNumbers.loadSeqNoInfoFromLuceneCommit(safeCommit.getUserData().entrySet());
        if (commitInfo.maxSeqNo <= globalCheckpoint) {
            return Optional.of(commitInfo);
        }
        return Optional.empty();
    }

    private static void updateCommitData(IndexWriter writer, Map<String, String> keysToUpdate) throws IOException {
        Map<String, String> userData = Store.getUserData(writer);
        userData.put("es_version", IndexVersion.current().toString());
        userData.putAll(keysToUpdate);
        writer.setLiveCommitData(userData.entrySet());
        writer.commit();
    }

    private static Map<String, String> getUserData(IndexWriter writer) {
        HashMap<String, String> userData = new HashMap<String, String>();
        writer.getLiveCommitData().forEach(e -> userData.put((String)e.getKey(), (String)e.getValue()));
        return userData;
    }

    private static IndexWriter newTemporaryAppendingIndexWriter(Directory dir, IndexCommit commit) throws IOException {
        IndexWriterConfig iwc = Store.newTemporaryIndexWriterConfig().setIndexCommit(commit).setOpenMode(IndexWriterConfig.OpenMode.APPEND);
        return new IndexWriter(dir, iwc);
    }

    private static IndexWriter newTemporaryEmptyIndexWriter(Directory dir, Version luceneVersion) throws IOException {
        IndexWriterConfig iwc = Store.newTemporaryIndexWriterConfig().setOpenMode(IndexWriterConfig.OpenMode.CREATE).setIndexCreatedVersionMajor(luceneVersion.major);
        return new IndexWriter(dir, iwc);
    }

    private static IndexWriterConfig newTemporaryIndexWriterConfig() {
        return Lucene.indexWriterConfigWithNoMerging(null).setSoftDeletesField("__soft_deletes").setCommitOnClose(false);
    }

    public static interface OnClose
    extends Consumer<ShardLock> {
        public static final OnClose EMPTY = new OnClose(){

            @Override
            public void accept(ShardLock Lock2) {
            }
        };
    }

    static final class StoreDirectory
    extends ByteSizeDirectory {
        private final Logger deletesLogger;

        StoreDirectory(ByteSizeDirectory delegateDirectory, Logger deletesLogger) {
            super((Directory)delegateDirectory);
            this.deletesLogger = deletesLogger;
        }

        @Override
        public long estimateSizeInBytes() throws IOException {
            return ((ByteSizeDirectory)this.getDelegate()).estimateSizeInBytes();
        }

        @Override
        public long estimateDataSetSizeInBytes() throws IOException {
            return ((ByteSizeDirectory)this.getDelegate()).estimateDataSetSizeInBytes();
        }

        public void close() {
            assert (false) : "Nobody should close this directory except of the Store itself";
        }

        public void deleteFile(String msg, String name) throws IOException {
            this.deletesLogger.trace("{}: delete file {}", (Object)msg, (Object)name);
            super.deleteFile(name);
        }

        public void deleteFile(String name) throws IOException {
            this.deleteFile("StoreDirectory.deleteFile", name);
        }

        private void innerClose() throws IOException {
            super.close();
        }

        public String toString() {
            return "store(" + this.in.toString() + ")";
        }
    }

    public record MetadataSnapshot(Map<String, StoreFileMetadata> fileMetadataMap, Map<String, String> commitUserData, long numDocs) implements Iterable<StoreFileMetadata>,
    Writeable
    {
        public static final MetadataSnapshot EMPTY = new MetadataSnapshot(Collections.emptyMap(), Collections.emptyMap(), 0L);
        private static final String SEGMENT_INFO_EXTENSION = "si";

        static MetadataSnapshot loadFromIndexCommit(IndexCommit commit, Directory directory, Logger logger) throws IOException {
            Map<String, String> commitUserData;
            long numDocs;
            HashMap<String, StoreFileMetadata> metadataByFile = new HashMap<String, StoreFileMetadata>();
            try {
                SegmentInfos segmentCommitInfos = Store.readSegmentsInfo(commit, directory);
                numDocs = Lucene.getNumDocs(segmentCommitInfos);
                commitUserData = Map.copyOf(segmentCommitInfos.getUserData());
                Version maxVersion = segmentCommitInfos.getMinSegmentLuceneVersion();
                for (SegmentCommitInfo info : segmentCommitInfos) {
                    Version version = info.info.getVersion();
                    if (version == null) {
                        throw new IllegalArgumentException("expected valid version value: " + info.info.toString());
                    }
                    if (version.onOrAfter(maxVersion)) {
                        maxVersion = version;
                    }
                    BytesRef segmentInfoId = StoreFileMetadata.toWriterUuid(info.info.getId());
                    BytesRef segmentCommitInfoId = StoreFileMetadata.toWriterUuid(info.getId());
                    for (String file : info.files()) {
                        MetadataSnapshot.checksumFromLuceneFile(directory, file, metadataByFile, logger, version.toString(), SEGMENT_INFO_EXTENSION.equals(IndexFileNames.getExtension((String)file)), IndexFileNames.parseGeneration((String)file) == 0L ? segmentInfoId : segmentCommitInfoId);
                    }
                }
                if (maxVersion == null) {
                    maxVersion = IndexVersion.MINIMUM_COMPATIBLE.luceneVersion();
                }
                String segmentsFile = segmentCommitInfos.getSegmentsFileName();
                MetadataSnapshot.checksumFromLuceneFile(directory, segmentsFile, metadataByFile, logger, maxVersion.toString(), true, StoreFileMetadata.toWriterUuid(segmentCommitInfos.getId()));
            }
            catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException | IndexNotFoundException ex) {
                throw ex;
            }
            catch (Exception ex) {
                try {
                    logger.warn(() -> Strings.format((String)"failed to build store metadata. checking segment info integrity (with commit [%s])", (Object[])new Object[]{commit == null ? "no" : "yes"}), (Throwable)ex);
                    Lucene.checkSegmentInfoIntegrity(directory);
                }
                catch (Exception inner) {
                    inner.addSuppressed(ex);
                    throw inner;
                }
                throw ex;
            }
            MetadataSnapshot metadataSnapshot = new MetadataSnapshot(Collections.unmodifiableMap(metadataByFile), commitUserData, numDocs);
            assert (metadataSnapshot.fileMetadataMap.isEmpty() || metadataSnapshot.numSegmentFiles() == 1) : "numSegmentFiles: " + metadataSnapshot.numSegmentFiles();
            return metadataSnapshot;
        }

        public static MetadataSnapshot readFrom(StreamInput in) throws IOException {
            Map<String, StoreFileMetadata> metadata = in.readMapValues(StoreFileMetadata::new, StoreFileMetadata::name);
            Map<String, String> commitUserData = in.readMap(StreamInput::readString);
            long numDocs = in.readLong();
            if (metadata.size() == 0 && commitUserData.size() == 0 && numDocs == 0L) {
                return EMPTY;
            }
            return new MetadataSnapshot(metadata, commitUserData, numDocs);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeMapValues(this.fileMetadataMap);
            out.writeMap(this.commitUserData, StreamOutput::writeString);
            out.writeLong(this.numDocs);
        }

        @Nullable
        public IndexVersion getCommitVersion() {
            String version = this.commitUserData.get("es_version");
            return version == null ? null : Engine.readIndexVersion(version);
        }

        public static boolean isReadAsHash(String file) {
            return SEGMENT_INFO_EXTENSION.equals(IndexFileNames.getExtension((String)file)) || file.startsWith("segments_");
        }

        private static void checksumFromLuceneFile(Directory directory, String file, Map<String, StoreFileMetadata> builder, Logger logger, String version, boolean readFileAsHash, BytesRef writerUuid) throws IOException {
            try (IndexInput in = directory.openInput(file, READONCE_CHECKSUM);){
                long footerChecksum;
                BytesRef fileHash;
                long length = in.length();
                if (length < (long)CodecUtil.footerLength()) {
                    throw new CorruptIndexException(org.elasticsearch.common.Strings.format("Cannot retrieve checksum from file: %s file length must be >= %d but was: %d", file, CodecUtil.footerLength(), length), (DataInput)in);
                }
                assert (readFileAsHash == MetadataSnapshot.isReadAsHash(file)) : file;
                if (readFileAsHash) {
                    assert (length <= (long)ByteSizeUnit.MB.toIntBytes(1L)) : file + " has length " + length;
                    fileHash = new BytesRef(Math.toIntExact(length));
                    fileHash.length = fileHash.bytes.length;
                    in.readBytes(fileHash.bytes, fileHash.offset, fileHash.length);
                    CRC32 crc32 = new CRC32();
                    crc32.update(fileHash.bytes, fileHash.offset, fileHash.length - 8);
                    long computedChecksum = crc32.getValue();
                    footerChecksum = CodecUtil.retrieveChecksum((IndexInput)in);
                    if (computedChecksum != footerChecksum) {
                        throw new CorruptIndexException(org.elasticsearch.common.Strings.format("Checksum from footer=%d did not match computed checksum=%d", footerChecksum, computedChecksum), (DataInput)in);
                    }
                } else {
                    fileHash = new BytesRef(BytesRef.EMPTY_BYTES);
                    footerChecksum = CodecUtil.retrieveChecksum((IndexInput)in);
                }
                builder.put(file, new StoreFileMetadata(file, length, Store.digestToString(footerChecksum), version, fileHash, writerUuid));
            }
            catch (Exception ex) {
                logger.debug(() -> "Failed computing metadata for file [" + file + "]", (Throwable)ex);
                throw ex;
            }
        }

        @Override
        public Iterator<StoreFileMetadata> iterator() {
            return this.fileMetadataMap.values().iterator();
        }

        public StoreFileMetadata get(String name) {
            return this.fileMetadataMap.get(name);
        }

        public RecoveryDiff recoveryDiff(MetadataSnapshot targetSnapshot) {
            ArrayList<StoreFileMetadata> perCommitSourceFiles = new ArrayList<StoreFileMetadata>();
            HashMap<String, Tuple> perSegmentSourceFiles = new HashMap<String, Tuple>();
            for (StoreFileMetadata sourceFile : this) {
                if (sourceFile.name().startsWith("_")) {
                    String segmentId = IndexFileNames.parseSegmentName((String)sourceFile.name());
                    boolean isGenerationalFile = IndexFileNames.parseGeneration((String)sourceFile.name()) > 0L;
                    Tuple perSegmentTuple = perSegmentSourceFiles.computeIfAbsent(segmentId, k -> Tuple.tuple(new ArrayList(), new ArrayList()));
                    (isGenerationalFile ? (List)perSegmentTuple.v2() : (List)perSegmentTuple.v1()).add(sourceFile);
                    continue;
                }
                assert (sourceFile.name().startsWith("segments_")) : "unexpected " + sourceFile;
                perCommitSourceFiles.add(sourceFile);
            }
            ArrayList identical = new ArrayList();
            ArrayList different = new ArrayList();
            ArrayList missing = new ArrayList();
            ArrayList tmpIdentical = new ArrayList();
            Predicate<List> groupComparer = sourceGroup -> {
                assert (tmpIdentical.isEmpty()) : "not cleaned up: " + tmpIdentical;
                boolean groupIdentical = true;
                for (StoreFileMetadata sourceFile : sourceGroup) {
                    StoreFileMetadata targetFile = targetSnapshot.get(sourceFile.name());
                    if (targetFile == null) {
                        groupIdentical = false;
                        missing.add(sourceFile);
                        continue;
                    }
                    if (groupIdentical && targetFile.isSame(sourceFile)) {
                        tmpIdentical.add(sourceFile);
                        continue;
                    }
                    groupIdentical = false;
                    different.add(sourceFile);
                }
                if (groupIdentical) {
                    identical.addAll(tmpIdentical);
                } else {
                    different.addAll(tmpIdentical);
                }
                tmpIdentical.clear();
                return groupIdentical;
            };
            Consumer<List> allDifferent = sourceGroup -> {
                for (StoreFileMetadata sourceFile : sourceGroup) {
                    StoreFileMetadata targetFile = targetSnapshot.get(sourceFile.name());
                    if (targetFile == null) {
                        missing.add(sourceFile);
                        continue;
                    }
                    different.add(sourceFile);
                }
            };
            boolean segmentsIdentical = true;
            for (Tuple segmentFiles : perSegmentSourceFiles.values()) {
                List nonGenerationalFiles = (List)segmentFiles.v1();
                List generationalFiles = (List)segmentFiles.v2();
                if (groupComparer.test(nonGenerationalFiles)) {
                    segmentsIdentical = groupComparer.test(generationalFiles) && segmentsIdentical;
                    continue;
                }
                segmentsIdentical = false;
                allDifferent.accept(generationalFiles);
            }
            if (segmentsIdentical) {
                groupComparer.test(perCommitSourceFiles);
            } else {
                allDifferent.accept(perCommitSourceFiles);
            }
            RecoveryDiff recoveryDiff = new RecoveryDiff(Collections.unmodifiableList(identical), Collections.unmodifiableList(different), Collections.unmodifiableList(missing));
            assert (recoveryDiff.size() == this.fileMetadataMap.size()) : "some files are missing: recoveryDiff is [" + recoveryDiff + "] comparing: [" + this.fileMetadataMap + "] to [" + targetSnapshot.fileMetadataMap + "]";
            return recoveryDiff;
        }

        public int size() {
            return this.fileMetadataMap.size();
        }

        public String getHistoryUUID() {
            return this.commitUserData.get("history_uuid");
        }

        public boolean contains(String existingFile) {
            return this.fileMetadataMap.containsKey(existingFile);
        }

        public StoreFileMetadata getSegmentsFile() {
            for (StoreFileMetadata file : this) {
                if (!file.name().startsWith("segments")) continue;
                return file;
            }
            assert (this.fileMetadataMap.isEmpty());
            return null;
        }

        private int numSegmentFiles() {
            int count = 0;
            for (StoreFileMetadata file : this) {
                if (!file.name().startsWith("segments")) continue;
                ++count;
            }
            return count;
        }

        public String getSyncId() {
            return this.commitUserData.get("sync_id");
        }
    }

    static class VerifyingIndexInput
    extends ChecksumIndexInput {
        private final IndexInput input;
        private final Checksum digest;
        private final long checksumPosition;
        private final byte[] checksum = new byte[8];
        private long verifiedPosition = 0L;

        VerifyingIndexInput(IndexInput input) {
            this(input, (Checksum)new BufferedChecksum((Checksum)new CRC32()));
        }

        VerifyingIndexInput(IndexInput input, Checksum digest) {
            super("VerifyingIndexInput(" + input + ")");
            this.input = input;
            this.digest = digest;
            this.checksumPosition = input.length() - 8L;
        }

        public byte readByte() throws IOException {
            long pos = this.input.getFilePointer();
            byte b = this.input.readByte();
            if (++pos > this.verifiedPosition) {
                if (pos <= this.checksumPosition) {
                    this.digest.update(b);
                } else {
                    this.checksum[(int)(pos - this.checksumPosition - 1L)] = b;
                }
                this.verifiedPosition = pos;
            }
            return b;
        }

        public void readBytes(byte[] b, int offset, int len) throws IOException {
            long pos = this.input.getFilePointer();
            this.input.readBytes(b, offset, len);
            if (pos + (long)len > this.verifiedPosition) {
                int alreadyVerified = (int)Math.max(0L, this.verifiedPosition - pos);
                if (pos < this.checksumPosition) {
                    if (pos + (long)len < this.checksumPosition) {
                        this.digest.update(b, offset + alreadyVerified, len - alreadyVerified);
                    } else {
                        int checksumOffset = (int)(this.checksumPosition - pos);
                        if (checksumOffset - alreadyVerified > 0) {
                            this.digest.update(b, offset + alreadyVerified, checksumOffset - alreadyVerified);
                        }
                        System.arraycopy(b, offset + checksumOffset, this.checksum, 0, len - checksumOffset);
                    }
                } else {
                    assert (pos - this.checksumPosition < 8L);
                    System.arraycopy(b, offset, this.checksum, (int)(pos - this.checksumPosition), len);
                }
                this.verifiedPosition = pos + (long)len;
            }
        }

        public long getChecksum() {
            return this.digest.getValue();
        }

        public void seek(long pos) throws IOException {
            if (pos < this.verifiedPosition) {
                this.input.seek(pos);
            } else if (this.verifiedPosition > this.getFilePointer()) {
                this.input.seek(this.verifiedPosition);
                super.seek(pos);
            } else {
                super.seek(pos);
            }
        }

        public void close() throws IOException {
            this.input.close();
        }

        public long getFilePointer() {
            return this.input.getFilePointer();
        }

        public long length() {
            return this.input.length();
        }

        public IndexInput clone() {
            throw new UnsupportedOperationException();
        }

        public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
            throw new UnsupportedOperationException();
        }

        public long getStoredChecksum() {
            try {
                return CodecUtil.readBELong((DataInput)new ByteArrayDataInput(this.checksum));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public long verify() throws CorruptIndexException {
            long storedChecksum = this.getStoredChecksum();
            if (this.getChecksum() == storedChecksum) {
                return storedChecksum;
            }
            throw new CorruptIndexException("verification failed : calculated=" + Store.digestToString(this.getChecksum()) + " stored=" + Store.digestToString(storedChecksum), (DataInput)this);
        }
    }

    public static final class RecoveryDiff {
        public final List<StoreFileMetadata> identical;
        public final List<StoreFileMetadata> different;
        public final List<StoreFileMetadata> missing;

        RecoveryDiff(List<StoreFileMetadata> identical, List<StoreFileMetadata> different, List<StoreFileMetadata> missing) {
            this.identical = identical;
            this.different = different;
            this.missing = missing;
        }

        public int size() {
            return this.identical.size() + this.different.size() + this.missing.size();
        }

        public String toString() {
            return "RecoveryDiff{identical=" + this.identical + ", different=" + this.different + ", missing=" + this.missing + "}";
        }
    }
}

