/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Query;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.query.SimpleQueryStringFlag;
import org.elasticsearch.index.search.QueryParserHelper;
import org.elasticsearch.index.search.SimpleQueryStringQueryParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class SimpleQueryStringBuilder
extends AbstractQueryBuilder<SimpleQueryStringBuilder> {
    public static final boolean DEFAULT_LENIENT = false;
    public static final boolean DEFAULT_ANALYZE_WILDCARD = false;
    public static final Operator DEFAULT_OPERATOR = Operator.OR;
    public static final int DEFAULT_FLAGS = SimpleQueryStringFlag.ALL.value;
    public static final int DEFAULT_FUZZY_PREFIX_LENGTH = 0;
    public static final int DEFAULT_FUZZY_MAX_EXPANSIONS = 50;
    public static final boolean DEFAULT_FUZZY_TRANSPOSITIONS = true;
    public static final MultiMatchQueryBuilder.Type DEFAULT_TYPE = MultiMatchQueryBuilder.Type.MOST_FIELDS;
    public static final String NAME = "simple_query_string";
    public static final TransportVersion TYPE_FIELD_ADDED_VERSION = TransportVersions.V_8_500_023;
    private static final ParseField MINIMUM_SHOULD_MATCH_FIELD = new ParseField("minimum_should_match", new String[0]);
    private static final ParseField ANALYZE_WILDCARD_FIELD = new ParseField("analyze_wildcard", new String[0]);
    private static final ParseField LENIENT_FIELD = new ParseField("lenient", new String[0]);
    private static final ParseField FLAGS_FIELD = new ParseField("flags", new String[0]);
    private static final ParseField DEFAULT_OPERATOR_FIELD = new ParseField("default_operator", new String[0]);
    private static final ParseField ANALYZER_FIELD = new ParseField("analyzer", new String[0]);
    private static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
    private static final ParseField FIELDS_FIELD = new ParseField("fields", new String[0]);
    private static final ParseField QUOTE_FIELD_SUFFIX_FIELD = new ParseField("quote_field_suffix", new String[0]);
    private static final ParseField GENERATE_SYNONYMS_PHRASE_QUERY = new ParseField("auto_generate_synonyms_phrase_query", new String[0]);
    private static final ParseField FUZZY_PREFIX_LENGTH_FIELD = new ParseField("fuzzy_prefix_length", new String[0]);
    private static final ParseField FUZZY_MAX_EXPANSIONS_FIELD = new ParseField("fuzzy_max_expansions", new String[0]);
    private static final ParseField FUZZY_TRANSPOSITIONS_FIELD = new ParseField("fuzzy_transpositions", new String[0]);
    private static final ParseField TYPE_FIELD = new ParseField("type", new String[0]);
    private final String queryText;
    private Map<String, Float> fieldsAndWeights = new HashMap<String, Float>();
    private String analyzer;
    private Operator defaultOperator = DEFAULT_OPERATOR;
    private String minimumShouldMatch;
    private int flags = DEFAULT_FLAGS;
    private boolean lenientSet = false;
    private SimpleQueryStringQueryParser.Settings settings = new SimpleQueryStringQueryParser.Settings();
    private MultiMatchQueryBuilder.Type type = DEFAULT_TYPE;

    public SimpleQueryStringBuilder(String queryText) {
        if (queryText == null) {
            throw new IllegalArgumentException("query text missing");
        }
        this.queryText = queryText;
    }

    public SimpleQueryStringBuilder(StreamInput in) throws IOException {
        super(in);
        this.queryText = in.readString();
        int size = in.readInt();
        HashMap<String, Float> fields = new HashMap<String, Float>();
        for (int i = 0; i < size; ++i) {
            String field = in.readString();
            Float weight = Float.valueOf(in.readFloat());
            this.checkNegativeBoost(weight.floatValue());
            fields.put(field, weight);
        }
        this.fieldsAndWeights.putAll(fields);
        this.flags = in.readInt();
        this.analyzer = in.readOptionalString();
        this.defaultOperator = Operator.readFromStream(in);
        this.settings.lenient(in.readBoolean());
        this.lenientSet = in.readBoolean();
        this.settings.analyzeWildcard(in.readBoolean());
        this.minimumShouldMatch = in.readOptionalString();
        this.settings.quoteFieldSuffix(in.readOptionalString());
        this.settings.autoGenerateSynonymsPhraseQuery(in.readBoolean());
        this.settings.fuzzyPrefixLength(in.readVInt());
        this.settings.fuzzyMaxExpansions(in.readVInt());
        this.settings.fuzzyTranspositions(in.readBoolean());
        this.type = in.getTransportVersion().onOrAfter(TYPE_FIELD_ADDED_VERSION) ? MultiMatchQueryBuilder.Type.readFromStream(in) : DEFAULT_TYPE;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.queryText);
        out.writeInt(this.fieldsAndWeights.size());
        for (Map.Entry<String, Float> entry : this.fieldsAndWeights.entrySet()) {
            out.writeString(entry.getKey());
            out.writeFloat(entry.getValue().floatValue());
        }
        out.writeInt(this.flags);
        out.writeOptionalString(this.analyzer);
        this.defaultOperator.writeTo(out);
        out.writeBoolean(this.settings.lenient());
        out.writeBoolean(this.lenientSet);
        out.writeBoolean(this.settings.analyzeWildcard());
        out.writeOptionalString(this.minimumShouldMatch);
        out.writeOptionalString(this.settings.quoteFieldSuffix());
        out.writeBoolean(this.settings.autoGenerateSynonymsPhraseQuery());
        out.writeVInt(this.settings.fuzzyPrefixLength());
        out.writeVInt(this.settings.fuzzyMaxExpansions());
        out.writeBoolean(this.settings.fuzzyTranspositions());
        if (out.getTransportVersion().onOrAfter(TYPE_FIELD_ADDED_VERSION)) {
            this.type.writeTo(out);
        }
    }

    public String value() {
        return this.queryText;
    }

    public SimpleQueryStringBuilder field(String field) {
        if (Strings.isEmpty(field)) {
            throw new IllegalArgumentException("supplied field is null or empty");
        }
        this.fieldsAndWeights.put(field, Float.valueOf(1.0f));
        return this;
    }

    public SimpleQueryStringBuilder field(String field, float boost) {
        if (Strings.isEmpty(field)) {
            throw new IllegalArgumentException("supplied field is null or empty");
        }
        this.checkNegativeBoost(boost);
        this.fieldsAndWeights.put(field, Float.valueOf(boost));
        return this;
    }

    public SimpleQueryStringBuilder fields(Map<String, Float> fields) {
        Objects.requireNonNull(fields, "fields cannot be null");
        for (float fieldBoost : fields.values()) {
            this.checkNegativeBoost(fieldBoost);
        }
        this.fieldsAndWeights.putAll(fields);
        return this;
    }

    public Map<String, Float> fields() {
        return this.fieldsAndWeights;
    }

    public SimpleQueryStringBuilder analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public String analyzer() {
        return this.analyzer;
    }

    public SimpleQueryStringBuilder defaultOperator(Operator defaultOperator) {
        this.defaultOperator = defaultOperator != null ? defaultOperator : DEFAULT_OPERATOR;
        return this;
    }

    public Operator defaultOperator() {
        return this.defaultOperator;
    }

    public SimpleQueryStringBuilder flags(SimpleQueryStringFlag ... flags) {
        if (!CollectionUtils.isEmpty((Object[])flags)) {
            int value = 0;
            for (SimpleQueryStringFlag flag : flags) {
                value |= flag.value;
            }
            this.flags = value;
        } else {
            this.flags = DEFAULT_FLAGS;
        }
        return this;
    }

    SimpleQueryStringBuilder flags(int flags) {
        this.flags = flags;
        return this;
    }

    int flags() {
        return this.flags;
    }

    public SimpleQueryStringBuilder quoteFieldSuffix(String suffix) {
        this.settings.quoteFieldSuffix(suffix);
        return this;
    }

    public String quoteFieldSuffix() {
        return this.settings.quoteFieldSuffix();
    }

    public SimpleQueryStringBuilder lenient(boolean lenient) {
        this.settings.lenient(lenient);
        this.lenientSet = true;
        return this;
    }

    public boolean lenient() {
        return this.settings.lenient();
    }

    public SimpleQueryStringBuilder analyzeWildcard(boolean analyzeWildcard) {
        this.settings.analyzeWildcard(analyzeWildcard);
        return this;
    }

    public boolean analyzeWildcard() {
        return this.settings.analyzeWildcard();
    }

    public SimpleQueryStringBuilder minimumShouldMatch(String minimumShouldMatch) {
        this.minimumShouldMatch = minimumShouldMatch;
        return this;
    }

    public String minimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    public SimpleQueryStringBuilder autoGenerateSynonymsPhraseQuery(boolean value) {
        this.settings.autoGenerateSynonymsPhraseQuery(value);
        return this;
    }

    public boolean autoGenerateSynonymsPhraseQuery() {
        return this.settings.autoGenerateSynonymsPhraseQuery();
    }

    public SimpleQueryStringBuilder fuzzyPrefixLength(int fuzzyPrefixLength) {
        this.settings.fuzzyPrefixLength(fuzzyPrefixLength);
        return this;
    }

    public int fuzzyPrefixLength() {
        return this.settings.fuzzyPrefixLength();
    }

    public SimpleQueryStringBuilder fuzzyMaxExpansions(int fuzzyMaxExpansions) {
        this.settings.fuzzyMaxExpansions(fuzzyMaxExpansions);
        return this;
    }

    public int fuzzyMaxExpansions() {
        return this.settings.fuzzyMaxExpansions();
    }

    public boolean fuzzyTranspositions() {
        return this.settings.fuzzyTranspositions();
    }

    public SimpleQueryStringBuilder fuzzyTranspositions(boolean fuzzyTranspositions) {
        this.settings.fuzzyTranspositions(fuzzyTranspositions);
        return this;
    }

    public SimpleQueryStringBuilder type(MultiMatchQueryBuilder.Type type) {
        this.type = type == null ? DEFAULT_TYPE : type;
        return this;
    }

    public MultiMatchQueryBuilder.Type type() {
        return this.type;
    }

    @Override
    protected Query doToQuery(SearchExecutionContext context) throws IOException {
        SimpleQueryStringQueryParser sqp;
        boolean isAllField;
        Map<String, Float> resolvedFieldsAndWeights;
        SimpleQueryStringQueryParser.Settings newSettings = new SimpleQueryStringQueryParser.Settings(this.settings);
        if (!this.fieldsAndWeights.isEmpty()) {
            resolvedFieldsAndWeights = QueryParserHelper.resolveMappingFields(context, this.fieldsAndWeights);
            isAllField = QueryParserHelper.hasAllFieldsWildcard(this.fieldsAndWeights.keySet());
        } else {
            List<String> defaultFields = context.defaultFields();
            resolvedFieldsAndWeights = QueryParserHelper.resolveMappingFields(context, QueryParserHelper.parseFieldsAndWeights(defaultFields));
            isAllField = QueryParserHelper.hasAllFieldsWildcard(defaultFields);
        }
        if (isAllField) {
            newSettings.lenient(this.lenientSet ? this.settings.lenient() : true);
        }
        if (this.analyzer == null) {
            sqp = new SimpleQueryStringQueryParser(resolvedFieldsAndWeights, this.flags, newSettings, context);
        } else {
            NamedAnalyzer luceneAnalyzer = context.getIndexAnalyzers().get(this.analyzer);
            if (luceneAnalyzer == null) {
                throw new QueryShardException((QueryRewriteContext)context, "[simple_query_string] analyzer [" + this.analyzer + "] not found", new Object[0]);
            }
            sqp = new SimpleQueryStringQueryParser((Analyzer)luceneAnalyzer, resolvedFieldsAndWeights, this.flags, newSettings, context);
        }
        sqp.setDefaultOperator(this.defaultOperator.toBooleanClauseOccur());
        sqp.setType(this.type);
        Query query = sqp.parse(this.queryText);
        return Queries.maybeApplyMinimumShouldMatch(query, this.minimumShouldMatch);
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(QUERY_FIELD.getPreferredName(), this.queryText);
        if (this.fieldsAndWeights.size() > 0) {
            builder.startArray(FIELDS_FIELD.getPreferredName());
            for (Map.Entry<String, Float> entry : this.fieldsAndWeights.entrySet()) {
                builder.value(entry.getKey() + "^" + entry.getValue());
            }
            builder.endArray();
        }
        if (this.analyzer != null) {
            builder.field(ANALYZER_FIELD.getPreferredName(), this.analyzer);
        }
        if (this.flags != DEFAULT_FLAGS) {
            builder.field(FLAGS_FIELD.getPreferredName(), this.flags);
        }
        if (this.defaultOperator != DEFAULT_OPERATOR) {
            builder.field(DEFAULT_OPERATOR_FIELD.getPreferredName(), this.defaultOperator.name().toLowerCase(Locale.ROOT));
        }
        if (this.lenientSet) {
            builder.field(LENIENT_FIELD.getPreferredName(), this.settings.lenient());
        }
        if (this.settings.analyzeWildcard()) {
            builder.field(ANALYZE_WILDCARD_FIELD.getPreferredName(), this.settings.analyzeWildcard());
        }
        if (this.settings.quoteFieldSuffix() != null) {
            builder.field(QUOTE_FIELD_SUFFIX_FIELD.getPreferredName(), this.settings.quoteFieldSuffix());
        }
        if (this.minimumShouldMatch != null) {
            builder.field(MINIMUM_SHOULD_MATCH_FIELD.getPreferredName(), this.minimumShouldMatch);
        }
        if (!this.settings.autoGenerateSynonymsPhraseQuery()) {
            builder.field(GENERATE_SYNONYMS_PHRASE_QUERY.getPreferredName(), this.settings.autoGenerateSynonymsPhraseQuery());
        }
        if (this.settings.fuzzyPrefixLength() != 0) {
            builder.field(FUZZY_PREFIX_LENGTH_FIELD.getPreferredName(), this.settings.fuzzyPrefixLength());
        }
        if (this.settings.fuzzyMaxExpansions() != 50) {
            builder.field(FUZZY_MAX_EXPANSIONS_FIELD.getPreferredName(), this.settings.fuzzyMaxExpansions());
        }
        if (!this.settings.fuzzyTranspositions()) {
            builder.field(FUZZY_TRANSPOSITIONS_FIELD.getPreferredName(), this.settings.fuzzyTranspositions());
        }
        if (this.type != DEFAULT_TYPE) {
            builder.field(TYPE_FIELD.getPreferredName(), this.type.toString().toLowerCase(Locale.ENGLISH));
        }
        this.boostAndQueryNameToXContent(builder);
        builder.endObject();
    }

    public static SimpleQueryStringBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String currentFieldName = null;
        String queryBody = null;
        float boost = 1.0f;
        String queryName = null;
        String minimumShouldMatch = null;
        Map<String, Float> fieldsAndWeights = null;
        Operator defaultOperator = null;
        String analyzerName = null;
        int flags = SimpleQueryStringFlag.ALL.value();
        Boolean lenient = null;
        boolean analyzeWildcard = false;
        String quoteFieldSuffix = null;
        boolean autoGenerateSynonymsPhraseQuery = true;
        int fuzzyPrefixLenght = 0;
        int fuzzyMaxExpansions = 50;
        boolean fuzzyTranspositions = true;
        MultiMatchQueryBuilder.Type type = DEFAULT_TYPE;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (FIELDS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    ArrayList<String> fields = new ArrayList<String>();
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        fields.add(parser.text());
                    }
                    fieldsAndWeights = QueryParserHelper.parseFieldsAndWeights(fields);
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[simple_query_string] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (token.isValue()) {
                if (QUERY_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    queryBody = parser.text();
                    continue;
                }
                if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    boost = parser.floatValue();
                    continue;
                }
                if (ANALYZER_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    analyzerName = parser.text();
                    continue;
                }
                if (DEFAULT_OPERATOR_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    defaultOperator = Operator.fromString(parser.text());
                    continue;
                }
                if (FLAGS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    if (parser.currentToken() != XContentParser.Token.VALUE_NUMBER) {
                        flags = SimpleQueryStringFlag.resolveFlags(parser.text());
                        continue;
                    }
                    flags = parser.intValue();
                    if (flags >= 0) continue;
                    flags = SimpleQueryStringFlag.ALL.value();
                    continue;
                }
                if (LENIENT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    lenient = parser.booleanValue();
                    continue;
                }
                if (ANALYZE_WILDCARD_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    analyzeWildcard = parser.booleanValue();
                    continue;
                }
                if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    queryName = parser.text();
                    continue;
                }
                if (MINIMUM_SHOULD_MATCH_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    minimumShouldMatch = parser.textOrNull();
                    continue;
                }
                if (QUOTE_FIELD_SUFFIX_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    quoteFieldSuffix = parser.textOrNull();
                    continue;
                }
                if (GENERATE_SYNONYMS_PHRASE_QUERY.match(currentFieldName, parser.getDeprecationHandler())) {
                    autoGenerateSynonymsPhraseQuery = parser.booleanValue();
                    continue;
                }
                if (FUZZY_PREFIX_LENGTH_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    fuzzyPrefixLenght = parser.intValue();
                    continue;
                }
                if (FUZZY_MAX_EXPANSIONS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    fuzzyMaxExpansions = parser.intValue();
                    continue;
                }
                if (FUZZY_TRANSPOSITIONS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    fuzzyTranspositions = parser.booleanValue();
                    continue;
                }
                if (TYPE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    type = MultiMatchQueryBuilder.Type.parse(parser.text(), parser.getDeprecationHandler());
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[simple_query_string] unsupported field [" + parser.currentName() + "]", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "[simple_query_string] unknown token [" + token + "] after [" + currentFieldName + "]", new Object[0]);
        }
        if (queryBody == null) {
            throw new ParsingException(parser.getTokenLocation(), "[simple_query_string] query text missing", new Object[0]);
        }
        SimpleQueryStringBuilder qb = new SimpleQueryStringBuilder(queryBody);
        if (fieldsAndWeights != null) {
            qb.fields(fieldsAndWeights);
        }
        ((SimpleQueryStringBuilder)((SimpleQueryStringBuilder)qb.boost(boost)).analyzer(analyzerName).queryName(queryName)).minimumShouldMatch(minimumShouldMatch);
        qb.flags(flags).defaultOperator(defaultOperator);
        if (lenient != null) {
            qb.lenient(lenient);
        }
        ((SimpleQueryStringBuilder)qb.analyzeWildcard(analyzeWildcard).boost(boost)).quoteFieldSuffix(quoteFieldSuffix);
        qb.autoGenerateSynonymsPhraseQuery(autoGenerateSynonymsPhraseQuery);
        qb.fuzzyPrefixLength(fuzzyPrefixLenght);
        qb.fuzzyMaxExpansions(fuzzyMaxExpansions);
        qb.fuzzyTranspositions(fuzzyTranspositions);
        qb.type(type);
        return qb;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.fieldsAndWeights, this.analyzer, this.defaultOperator, this.queryText, this.minimumShouldMatch, this.settings, this.flags, this.type);
    }

    @Override
    protected boolean doEquals(SimpleQueryStringBuilder other) {
        return Objects.equals(this.fieldsAndWeights, other.fieldsAndWeights) && Objects.equals(this.analyzer, other.analyzer) && Objects.equals(this.defaultOperator, other.defaultOperator) && Objects.equals(this.queryText, other.queryText) && Objects.equals(this.minimumShouldMatch, other.minimumShouldMatch) && Objects.equals(this.settings, other.settings) && this.flags == other.flags && Objects.equals(this.type, other.type);
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ZERO;
    }
}

