/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.TextFieldMapper;
import org.elasticsearch.index.query.CoordinatorRewriteContext;
import org.elasticsearch.index.query.DataRewriteContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.ScriptCompiler;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.xcontent.XContentParserConfiguration;

public class QueryRewriteContext {
    protected final MapperService mapperService;
    protected final MappingLookup mappingLookup;
    protected final Map<String, MappedFieldType> runtimeMappings;
    protected final IndexSettings indexSettings;
    protected final Index fullyQualifiedIndex;
    protected final Predicate<String> indexNameMatcher;
    protected final NamedWriteableRegistry writeableRegistry;
    protected final ValuesSourceRegistry valuesSourceRegistry;
    protected final BooleanSupplier allowExpensiveQueries;
    protected final ScriptCompiler scriptService;
    private final XContentParserConfiguration parserConfiguration;
    protected final Client client;
    protected final LongSupplier nowInMillis;
    private final List<BiConsumer<Client, ActionListener<?>>> asyncActions = new ArrayList();
    protected boolean allowUnmappedFields;
    protected boolean mapUnmappedFieldAsString;
    protected Predicate<String> allowedFields;

    public QueryRewriteContext(XContentParserConfiguration parserConfiguration, Client client, LongSupplier nowInMillis, MapperService mapperService, MappingLookup mappingLookup, Map<String, MappedFieldType> runtimeMappings, Predicate<String> allowedFields, IndexSettings indexSettings, Index fullyQualifiedIndex, Predicate<String> indexNameMatcher, NamedWriteableRegistry namedWriteableRegistry, ValuesSourceRegistry valuesSourceRegistry, BooleanSupplier allowExpensiveQueries, ScriptCompiler scriptService) {
        this.parserConfiguration = parserConfiguration;
        this.client = client;
        this.nowInMillis = nowInMillis;
        this.mapperService = mapperService;
        this.mappingLookup = Objects.requireNonNull(mappingLookup);
        this.allowUnmappedFields = indexSettings == null || indexSettings.isDefaultAllowUnmappedFields();
        this.runtimeMappings = runtimeMappings;
        this.allowedFields = allowedFields;
        this.indexSettings = indexSettings;
        this.fullyQualifiedIndex = fullyQualifiedIndex;
        this.indexNameMatcher = indexNameMatcher;
        this.writeableRegistry = namedWriteableRegistry;
        this.valuesSourceRegistry = valuesSourceRegistry;
        this.allowExpensiveQueries = allowExpensiveQueries;
        this.scriptService = scriptService;
    }

    public QueryRewriteContext(XContentParserConfiguration parserConfiguration, Client client, LongSupplier nowInMillis) {
        this(parserConfiguration, client, nowInMillis, null, MappingLookup.EMPTY, Collections.emptyMap(), null, null, null, null, null, null, null, null);
    }

    public XContentParserConfiguration getParserConfig() {
        return this.parserConfiguration;
    }

    public long nowInMillis() {
        return this.nowInMillis.getAsLong();
    }

    public SearchExecutionContext convertToSearchExecutionContext() {
        return null;
    }

    public CoordinatorRewriteContext convertToCoordinatorRewriteContext() {
        return null;
    }

    public QueryRewriteContext convertToIndexMetadataContext() {
        return this.mapperService != null ? this : null;
    }

    public DataRewriteContext convertToDataRewriteContext() {
        return null;
    }

    public MappedFieldType getFieldType(String name) {
        return this.failIfFieldMappingNotFound(name, this.fieldType(name));
    }

    protected MappedFieldType fieldType(String name) {
        if (this.allowedFields != null && !this.allowedFields.test(name)) {
            return null;
        }
        MappedFieldType fieldType = this.runtimeMappings.get(name);
        return fieldType == null ? this.mappingLookup.getFieldType(name) : fieldType;
    }

    public IndexAnalyzers getIndexAnalyzers() {
        if (this.mapperService == null) {
            return IndexAnalyzers.of(Collections.emptyMap());
        }
        return this.mapperService.getIndexAnalyzers();
    }

    MappedFieldType failIfFieldMappingNotFound(String name, MappedFieldType fieldMapping) {
        if (fieldMapping != null || this.allowUnmappedFields) {
            return fieldMapping;
        }
        if (this.mapUnmappedFieldAsString) {
            TextFieldMapper.Builder builder = new TextFieldMapper.Builder(name, this.getIndexAnalyzers());
            return builder.build(MapperBuilderContext.root(false, false)).fieldType();
        }
        throw new QueryShardException(this, "No field mapping can be found for the field with name [{}]", name);
    }

    public void setAllowUnmappedFields(boolean allowUnmappedFields) {
        this.allowUnmappedFields = allowUnmappedFields;
    }

    public void setMapUnmappedFieldAsString(boolean mapUnmappedFieldAsString) {
        this.mapUnmappedFieldAsString = mapUnmappedFieldAsString;
    }

    public NamedWriteableRegistry getWriteableRegistry() {
        return this.writeableRegistry;
    }

    public ValuesSourceRegistry getValuesSourceRegistry() {
        return this.valuesSourceRegistry;
    }

    public boolean allowExpensiveQueries() {
        assert (this.allowExpensiveQueries != null);
        return this.allowExpensiveQueries.getAsBoolean();
    }

    public void registerAsyncAction(BiConsumer<Client, ActionListener<?>> asyncAction) {
        this.asyncActions.add(asyncAction);
    }

    public boolean hasAsyncActions() {
        return !this.asyncActions.isEmpty();
    }

    public void executeAsyncActions(final ActionListener listener) {
        if (this.asyncActions.isEmpty()) {
            listener.onResponse(null);
        } else {
            final CountDown countDown = new CountDown(this.asyncActions.size());
            ActionListener internalListener = new ActionListener(){

                public void onResponse(Object o) {
                    if (countDown.countDown()) {
                        listener.onResponse(null);
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    if (countDown.fastForward()) {
                        listener.onFailure(e);
                    }
                }
            };
            ArrayList biConsumers = new ArrayList(this.asyncActions);
            this.asyncActions.clear();
            for (BiConsumer biConsumer : biConsumers) {
                biConsumer.accept(this.client, internalListener);
            }
        }
    }

    public Index getFullyQualifiedIndex() {
        return this.fullyQualifiedIndex;
    }

    public IndexSettings getIndexSettings() {
        return this.indexSettings;
    }

    public boolean indexMatches(String pattern) {
        assert (this.indexNameMatcher != null);
        return this.indexNameMatcher.test(pattern);
    }

    public Set<String> getMatchingFieldNames(String pattern) {
        if (this.runtimeMappings.isEmpty()) {
            return this.mappingLookup.getMatchingFieldNames(pattern);
        }
        HashSet<String> matches = new HashSet<String>(this.mappingLookup.getMatchingFieldNames(pattern));
        if ("*".equals(pattern)) {
            matches.addAll(this.runtimeMappings.keySet());
        } else if (!Regex.isSimpleMatchPattern(pattern)) {
            if (this.runtimeMappings.containsKey(pattern)) {
                matches.add(pattern);
            }
        } else {
            for (String name : this.runtimeMappings.keySet()) {
                if (!Regex.simpleMatch(pattern, name)) continue;
                matches.add(name);
            }
        }
        return matches;
    }

    public Iterable<String> getAllFieldNames() {
        Set<String> allFromMapping = this.mappingLookup.getMatchingFieldNames("*");
        return this.runtimeMappings.isEmpty() ? allFromMapping : () -> Iterators.concat(allFromMapping.iterator(), this.runtimeMappings.keySet().iterator());
    }
}

