/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.index.LeafReader;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.index.fieldvisitor.LeafStoredFieldLoader;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.json.JsonXContent;

public interface SourceLoader {
    public static final SourceLoader FROM_STORED_SOURCE = new SourceLoader(){

        @Override
        public boolean reordersFieldValues() {
            return false;
        }

        @Override
        public Leaf leaf(LeafReader reader, int[] docIdsInLeaf) {
            return (storedFieldLoader, docId) -> Source.fromBytes(storedFieldLoader.source());
        }

        @Override
        public Set<String> requiredStoredFields() {
            return Set.of();
        }
    };

    public boolean reordersFieldValues();

    public Leaf leaf(LeafReader var1, int[] var2) throws IOException;

    public Set<String> requiredStoredFields();

    public static interface SyntheticFieldLoader {
        public static final SyntheticFieldLoader NOTHING = new SyntheticFieldLoader(){

            @Override
            public Stream<Map.Entry<String, StoredFieldLoader>> storedFieldLoaders() {
                return Stream.of(new Map.Entry[0]);
            }

            @Override
            public DocValuesLoader docValuesLoader(LeafReader leafReader, int[] docIdsInLeaf) throws IOException {
                return null;
            }

            @Override
            public boolean hasValue() {
                return false;
            }

            @Override
            public void write(XContentBuilder b) {
            }
        };

        public Stream<Map.Entry<String, StoredFieldLoader>> storedFieldLoaders();

        public DocValuesLoader docValuesLoader(LeafReader var1, int[] var2) throws IOException;

        public boolean hasValue();

        public void write(XContentBuilder var1) throws IOException;

        public static interface DocValuesLoader {
            public boolean advanceToDoc(int var1) throws IOException;
        }

        public static interface StoredFieldLoader {
            public void load(List<Object> var1);
        }
    }

    public static class Synthetic
    implements SourceLoader {
        private final SyntheticFieldLoader loader;
        private final Map<String, SyntheticFieldLoader.StoredFieldLoader> storedFieldLoaders;

        public Synthetic(Mapping mapping) {
            this.loader = mapping.syntheticFieldLoader();
            this.storedFieldLoaders = Map.copyOf(this.loader.storedFieldLoaders().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }

        @Override
        public boolean reordersFieldValues() {
            return true;
        }

        @Override
        public Set<String> requiredStoredFields() {
            return this.storedFieldLoaders.keySet();
        }

        @Override
        public Leaf leaf(LeafReader reader, int[] docIdsInLeaf) throws IOException {
            return new SyntheticLeaf(this.loader.docValuesLoader(reader, docIdsInLeaf));
        }

        private class SyntheticLeaf
        implements Leaf {
            private final SyntheticFieldLoader.DocValuesLoader docValuesLoader;

            private SyntheticLeaf(SyntheticFieldLoader.DocValuesLoader docValuesLoader) {
                this.docValuesLoader = docValuesLoader;
            }

            @Override
            public Source source(LeafStoredFieldLoader storedFieldLoader, int docId) throws IOException {
                for (Map.Entry<String, List<Object>> e : storedFieldLoader.storedFields().entrySet()) {
                    SyntheticFieldLoader.StoredFieldLoader loader = Synthetic.this.storedFieldLoaders.get(e.getKey());
                    if (loader == null) continue;
                    loader.load(e.getValue());
                }
                if (this.docValuesLoader != null) {
                    this.docValuesLoader.advanceToDoc(docId);
                }
                try (XContentBuilder b = new XContentBuilder(JsonXContent.jsonXContent, (OutputStream)new ByteArrayOutputStream());){
                    if (Synthetic.this.loader.hasValue()) {
                        Synthetic.this.loader.write(b);
                    } else {
                        b.startObject().endObject();
                    }
                    Source source = Source.fromBytes(BytesReference.bytes(b), b.contentType());
                    return source;
                }
            }
        }
    }

    public static interface Leaf {
        public Source source(LeafStoredFieldLoader var1, int var2) throws IOException;
    }
}

