/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperErrors;
import org.elasticsearch.index.mapper.MapperException;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.NestedPathFieldMapper;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class NestedObjectMapper
extends ObjectMapper {
    public static final String CONTENT_TYPE = "nested";
    private Explicit<Boolean> includeInRoot;
    private Explicit<Boolean> includeInParent;
    private final String nestedTypePath;
    private final Query nestedTypeFilter;

    NestedObjectMapper(String name, String fullPath, Map<String, Mapper> mappers, Builder builder) {
        super(name, fullPath, builder.enabled, Explicit.IMPLICIT_TRUE, builder.dynamic, mappers);
        this.nestedTypePath = builder.indexCreatedVersion.before(IndexVersion.V_8_0_0) ? "__" + fullPath : fullPath;
        this.nestedTypeFilter = NestedPathFieldMapper.filter(builder.indexCreatedVersion, this.nestedTypePath);
        this.includeInParent = builder.includeInParent;
        this.includeInRoot = builder.includeInRoot;
    }

    public Query nestedTypeFilter() {
        return this.nestedTypeFilter;
    }

    public String nestedTypePath() {
        return this.nestedTypePath;
    }

    @Override
    public boolean isNested() {
        return true;
    }

    public boolean isIncludeInParent() {
        return this.includeInParent.value();
    }

    public boolean isIncludeInRoot() {
        return this.includeInRoot.value();
    }

    public Map<String, Mapper> getChildren() {
        return this.mappers;
    }

    @Override
    public ObjectMapper.Builder newBuilder(IndexVersion indexVersionCreated) {
        Builder builder = new Builder(this.simpleName(), indexVersionCreated);
        builder.enabled = this.enabled;
        builder.dynamic = this.dynamic;
        builder.includeInRoot = this.includeInRoot;
        builder.includeInParent = this.includeInParent;
        return builder;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.simpleName());
        builder.field("type", CONTENT_TYPE);
        if (this.includeInParent.explicit() && this.includeInParent.value().booleanValue()) {
            builder.field("include_in_parent", this.includeInParent.value());
        }
        if (this.includeInRoot.value().booleanValue()) {
            builder.field("include_in_root", this.includeInRoot.value());
        }
        if (this.dynamic != null) {
            builder.field("dynamic", this.dynamic.name().toLowerCase(Locale.ROOT));
        }
        if (!this.isEnabled()) {
            builder.field("enabled", (Boolean)this.enabled.value());
        }
        this.serializeMappers(builder, params);
        return builder.endObject();
    }

    @Override
    public ObjectMapper merge(Mapper mergeWith, MapperService.MergeReason reason, MapperBuilderContext parentBuilderContext) {
        if (!(mergeWith instanceof NestedObjectMapper)) {
            MapperErrors.throwNestedMappingConflictError(mergeWith.name());
        }
        NestedObjectMapper mergeWithObject = (NestedObjectMapper)mergeWith;
        NestedObjectMapper toMerge = (NestedObjectMapper)this.clone();
        if (reason == MapperService.MergeReason.INDEX_TEMPLATE) {
            if (mergeWithObject.includeInParent.explicit()) {
                toMerge.includeInParent = mergeWithObject.includeInParent;
            }
            if (mergeWithObject.includeInRoot.explicit()) {
                toMerge.includeInRoot = mergeWithObject.includeInRoot;
            }
        } else {
            if (this.includeInParent.value() != mergeWithObject.includeInParent.value()) {
                throw new MapperException("the [include_in_parent] parameter can't be updated on a nested object mapping");
            }
            if (this.includeInRoot.value() != mergeWithObject.includeInRoot.value()) {
                throw new MapperException("the [include_in_root] parameter can't be updated on a nested object mapping");
            }
        }
        if (parentBuilderContext instanceof NestedMapperBuilderContext) {
            NestedMapperBuilderContext nc = (NestedMapperBuilderContext)parentBuilderContext;
            if (nc.parentIncludedInRoot && toMerge.includeInParent.value().booleanValue()) {
                toMerge.includeInRoot = Explicit.IMPLICIT_FALSE;
            }
        } else if (toMerge.includeInParent.value().booleanValue()) {
            toMerge.includeInRoot = Explicit.IMPLICIT_FALSE;
        }
        toMerge.doMerge(mergeWithObject, reason, parentBuilderContext);
        return toMerge;
    }

    @Override
    protected MapperBuilderContext createChildContext(MapperBuilderContext mapperBuilderContext, String name) {
        boolean parentIncludedInRoot = this.includeInRoot.value();
        if (!(mapperBuilderContext instanceof NestedMapperBuilderContext)) {
            parentIncludedInRoot |= this.includeInParent.value().booleanValue();
        }
        return new NestedMapperBuilderContext(mapperBuilderContext.buildFullName(name), parentIncludedInRoot);
    }

    @Override
    public SourceLoader.SyntheticFieldLoader syntheticFieldLoader() {
        throw new IllegalArgumentException("field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support synthetic source");
    }

    public static class Builder
    extends ObjectMapper.Builder {
        private Explicit<Boolean> includeInRoot = Explicit.IMPLICIT_FALSE;
        private Explicit<Boolean> includeInParent = Explicit.IMPLICIT_FALSE;
        private final IndexVersion indexCreatedVersion;

        public Builder(String name, IndexVersion indexCreatedVersion) {
            super(name, Explicit.IMPLICIT_TRUE);
            this.indexCreatedVersion = indexCreatedVersion;
        }

        Builder includeInRoot(boolean includeInRoot) {
            this.includeInRoot = Explicit.explicitBoolean(includeInRoot);
            return this;
        }

        Builder includeInParent(boolean includeInParent) {
            this.includeInParent = Explicit.explicitBoolean(includeInParent);
            return this;
        }

        @Override
        public NestedObjectMapper build(MapperBuilderContext context) {
            boolean parentIncludedInRoot = this.includeInRoot.value();
            if (context instanceof NestedMapperBuilderContext) {
                NestedMapperBuilderContext nc = (NestedMapperBuilderContext)context;
                if (nc.parentIncludedInRoot && this.includeInParent.value().booleanValue()) {
                    this.includeInRoot = Explicit.IMPLICIT_FALSE;
                }
            } else {
                parentIncludedInRoot |= this.includeInParent.value().booleanValue();
                if (this.includeInParent.value().booleanValue()) {
                    this.includeInRoot = Explicit.IMPLICIT_FALSE;
                }
            }
            NestedMapperBuilderContext nestedContext = new NestedMapperBuilderContext(context.buildFullName(this.name), parentIncludedInRoot);
            return new NestedObjectMapper(this.name, context.buildFullName(this.name), this.buildMappers(nestedContext), this);
        }
    }

    private static class NestedMapperBuilderContext
    extends MapperBuilderContext {
        final boolean parentIncludedInRoot;

        NestedMapperBuilderContext(String path, boolean parentIncludedInRoot) {
            super(path, false, false);
            this.parentIncludedInRoot = parentIncludedInRoot;
        }

        @Override
        public MapperBuilderContext createChildContext(String name) {
            return new NestedMapperBuilderContext(this.buildFullName(name), this.parentIncludedInRoot);
        }
    }

    public static class TypeParser
    extends ObjectMapper.TypeParser {
        @Override
        public Mapper.Builder parse(String name, Map<String, Object> node, MappingParserContext parserContext) throws MapperParsingException {
            if (TypeParser.parseSubobjects(node).explicit()) {
                throw new MapperParsingException("Nested type [" + name + "] does not support [subobjects] parameter");
            }
            Builder builder = new Builder(name, parserContext.indexVersionCreated());
            TypeParser.parseNested(name, node, builder);
            TypeParser.parseObjectFields(node, parserContext, builder);
            return builder;
        }

        protected static void parseNested(String name, Map<String, Object> node, Builder builder) {
            Object fieldNode = node.get("include_in_parent");
            if (fieldNode != null) {
                boolean includeInParent = XContentMapValues.nodeBooleanValue(fieldNode, name + ".include_in_parent");
                builder.includeInParent(includeInParent);
                node.remove("include_in_parent");
            }
            if ((fieldNode = node.get("include_in_root")) != null) {
                boolean includeInRoot = XContentMapValues.nodeBooleanValue(fieldNode, name + ".include_in_root");
                builder.includeInRoot(includeInRoot);
                node.remove("include_in_root");
            }
        }
    }
}

