/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.DocumentParser;
import org.elasticsearch.index.mapper.DynamicTemplate;
import org.elasticsearch.index.mapper.IdFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperRegistry;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MappingParser;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.NestedLookup;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.indices.IndicesModule;
import org.elasticsearch.plugins.internal.DocumentParsingObserver;
import org.elasticsearch.script.ScriptCompiler;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public class MapperService
extends AbstractIndexComponent
implements Closeable {
    public static final String SINGLE_MAPPING_NAME = "_doc";
    public static final String TYPE_FIELD_NAME = "_type";
    public static final Setting<Long> INDEX_MAPPING_NESTED_FIELDS_LIMIT_SETTING = Setting.longSetting("index.mapping.nested_fields.limit", 50L, 0L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Long> INDEX_MAPPING_NESTED_DOCS_LIMIT_SETTING = Setting.longSetting("index.mapping.nested_objects.limit", 10000L, 0L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Long> INDEX_MAPPING_TOTAL_FIELDS_LIMIT_SETTING = Setting.longSetting("index.mapping.total_fields.limit", 1000L, 0L, Setting.Property.Dynamic, Setting.Property.IndexScope, Setting.Property.ServerlessPublic);
    public static final Setting<Long> INDEX_MAPPING_DEPTH_LIMIT_SETTING = Setting.longSetting("index.mapping.depth.limit", 20L, 1L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Long> INDEX_MAPPING_FIELD_NAME_LENGTH_LIMIT_SETTING = Setting.longSetting("index.mapping.field_name_length.limit", Long.MAX_VALUE, 1L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Long> INDEX_MAPPING_DIMENSION_FIELDS_LIMIT_SETTING = Setting.longSetting("index.mapping.dimension_fields.limit", 21L, 0L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    private final IndexAnalyzers indexAnalyzers;
    private final MappingParser mappingParser;
    private final DocumentParser documentParser;
    private final IndexVersion indexVersionCreated;
    private final MapperRegistry mapperRegistry;
    private final Supplier<MappingParserContext> mappingParserContextSupplier;
    private volatile DocumentMapper mapper;

    public MapperService(ClusterService clusterService, IndexSettings indexSettings, IndexAnalyzers indexAnalyzers, XContentParserConfiguration parserConfiguration, SimilarityService similarityService, MapperRegistry mapperRegistry, Supplier<SearchExecutionContext> searchExecutionContextSupplier, IdFieldMapper idFieldMapper, ScriptCompiler scriptCompiler, Supplier<DocumentParsingObserver> documentParsingObserverSupplier) {
        this(() -> clusterService.state().getMinTransportVersion(), indexSettings, indexAnalyzers, parserConfiguration, similarityService, mapperRegistry, searchExecutionContextSupplier, idFieldMapper, scriptCompiler, documentParsingObserverSupplier);
    }

    public MapperService(Supplier<TransportVersion> clusterTransportVersion, IndexSettings indexSettings, IndexAnalyzers indexAnalyzers, XContentParserConfiguration parserConfiguration, SimilarityService similarityService, MapperRegistry mapperRegistry, Supplier<SearchExecutionContext> searchExecutionContextSupplier, IdFieldMapper idFieldMapper, ScriptCompiler scriptCompiler, Supplier<DocumentParsingObserver> documentParsingObserverSupplier) {
        super(indexSettings);
        this.indexVersionCreated = indexSettings.getIndexVersionCreated();
        this.indexAnalyzers = indexAnalyzers;
        this.mapperRegistry = mapperRegistry;
        this.mappingParserContextSupplier = () -> new MappingParserContext(similarityService::getSimilarity, type -> mapperRegistry.getMapperParser((String)type, this.indexVersionCreated), mapperRegistry.getRuntimeFieldParsers()::get, this.indexVersionCreated, clusterTransportVersion, searchExecutionContextSupplier, scriptCompiler, indexAnalyzers, indexSettings, idFieldMapper);
        this.documentParser = new DocumentParser(parserConfiguration, this.mappingParserContextSupplier.get(), documentParsingObserverSupplier);
        Map<String, MetadataFieldMapper.TypeParser> metadataMapperParsers = mapperRegistry.getMetadataMapperParsers(indexSettings.getIndexVersionCreated());
        this.mappingParser = new MappingParser(this.mappingParserContextSupplier, metadataMapperParsers, this::getMetadataMappers, this::resolveDocumentType);
    }

    public boolean hasNested() {
        return this.mappingLookup().nestedLookup() != NestedLookup.EMPTY;
    }

    public IndexAnalyzers getIndexAnalyzers() {
        return this.indexAnalyzers;
    }

    public MappingParserContext parserContext() {
        return this.mappingParserContextSupplier.get();
    }

    public DocumentParser documentParser() {
        return this.documentParser;
    }

    Map<Class<? extends MetadataFieldMapper>, MetadataFieldMapper> getMetadataMappers() {
        MappingParserContext mappingParserContext = this.parserContext();
        DocumentMapper existingMapper = this.mapper;
        Map<String, MetadataFieldMapper.TypeParser> metadataMapperParsers = this.mapperRegistry.getMetadataMapperParsers(this.indexSettings.getIndexVersionCreated());
        LinkedHashMap<Class<? extends MetadataFieldMapper>, MetadataFieldMapper> metadataMappers = new LinkedHashMap<Class<? extends MetadataFieldMapper>, MetadataFieldMapper>();
        if (existingMapper == null) {
            for (MetadataFieldMapper.TypeParser parser : metadataMapperParsers.values()) {
                MetadataFieldMapper metadataFieldMapper = parser.getDefault(mappingParserContext);
                if (metadataFieldMapper == null) continue;
                metadataMappers.put(metadataFieldMapper.getClass(), metadataFieldMapper);
            }
        } else {
            metadataMappers.putAll(existingMapper.mapping().getMetadataMappersMap());
        }
        return metadataMappers;
    }

    public static Map<String, Object> parseMapping(NamedXContentRegistry xContentRegistry, String mappingSource) throws IOException {
        if ("{}".equals(mappingSource)) {
            return Map.of();
        }
        try (XContentParser parser = XContentType.JSON.xContent().createParser(MapperService.parserConfig(xContentRegistry), mappingSource);){
            Map map = parser.map();
            return map;
        }
    }

    public static Map<String, Object> parseMapping(NamedXContentRegistry xContentRegistry, CompressedXContent mappingSource) throws IOException {
        try (InputStream in = CompressorFactory.COMPRESSOR.threadLocalInputStream(mappingSource.compressedReference().streamInput());){
            Map map;
            block12: {
                XContentParser parser = XContentType.JSON.xContent().createParser(MapperService.parserConfig(xContentRegistry), in);
                try {
                    map = parser.map();
                    if (parser == null) break block12;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return map;
        }
    }

    private static XContentParserConfiguration parserConfig(NamedXContentRegistry xContentRegistry) {
        return XContentParserConfiguration.EMPTY.withRegistry(xContentRegistry).withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMapping(IndexMetadata currentIndexMetadata, IndexMetadata newIndexMetadata) {
        assert (newIndexMetadata.getIndex().equals(this.index())) : "index mismatch: expected " + this.index() + " but was " + newIndexMetadata.getIndex();
        if (currentIndexMetadata != null && currentIndexMetadata.getMappingVersion() == newIndexMetadata.getMappingVersion()) {
            assert (this.assertNoUpdateRequired(newIndexMetadata));
            return;
        }
        MappingMetadata newMappingMetadata = newIndexMetadata.mapping();
        if (newMappingMetadata != null) {
            String op;
            DocumentMapper previousMapper;
            String type = newMappingMetadata.type();
            CompressedXContent incomingMappingSource = newMappingMetadata.source();
            Mapping incomingMapping = this.parseMapping(type, incomingMappingSource);
            MapperService mapperService = this;
            synchronized (mapperService) {
                previousMapper = this.mapper;
                assert (this.assertRefreshIsNotNeeded(previousMapper, type, incomingMapping));
                this.mapper = this.newDocumentMapper(incomingMapping, MergeReason.MAPPING_RECOVERY, incomingMappingSource);
            }
            String string = op = previousMapper != null ? "updated" : "added";
            if (this.logger.isDebugEnabled() && incomingMappingSource.compressed().length < 512) {
                this.logger.debug("[{}] {} mapping, source [{}]", (Object)this.index(), (Object)op, (Object)incomingMappingSource.string());
            } else if (this.logger.isTraceEnabled()) {
                this.logger.trace("[{}] {} mapping, source [{}]", (Object)this.index(), (Object)op, (Object)incomingMappingSource.string());
            } else {
                this.logger.debug("[{}] {} mapping (source suppressed due to length, use TRACE level if needed)", (Object)this.index(), (Object)op);
            }
        }
    }

    private boolean assertRefreshIsNotNeeded(DocumentMapper currentMapper, String type, Mapping incomingMapping) {
        CompressedXContent incomingMappingSource;
        CompressedXContent mergedMappingSource;
        Mapping mergedMapping = MapperService.mergeMappings(currentMapper, incomingMapping, MergeReason.MAPPING_RECOVERY);
        ToXContent.MapParams params = new ToXContent.MapParams(Collections.singletonMap("skip_runtime", "true"));
        try {
            mergedMappingSource = new CompressedXContent((ToXContent)mergedMapping, (ToXContent.Params)params);
        }
        catch (Exception e) {
            throw new AssertionError("failed to serialize source for type [" + type + "]", e);
        }
        try {
            incomingMappingSource = new CompressedXContent((ToXContent)incomingMapping, (ToXContent.Params)params);
        }
        catch (Exception e) {
            throw new AssertionError("failed to serialize source for type [" + type + "]", e);
        }
        assert (mergedMappingSource.equals(incomingMappingSource)) : "[" + this.index() + "] parsed mapping, and got different sources\nincoming:\n" + incomingMappingSource + "\nmerged:\n" + mergedMappingSource;
        return true;
    }

    boolean assertNoUpdateRequired(IndexMetadata newIndexMetadata) {
        MappingMetadata mapping = newIndexMetadata.mapping();
        if (mapping != null) {
            CompressedXContent newSource;
            Mapping newMapping = this.parseMapping(mapping.type(), mapping.source());
            CompressedXContent currentSource = this.mapper.mappingSource();
            if (!Objects.equals(currentSource, newSource = newMapping.toCompressedXContent()) && !this.mapper.isSyntheticSourceMalformed(currentSource, this.indexVersionCreated)) {
                throw new IllegalStateException("expected current mapping [" + currentSource + "] to be the same as new mapping [" + newSource + "]");
            }
        }
        return true;
    }

    public void merge(IndexMetadata indexMetadata, MergeReason reason) {
        assert (reason != MergeReason.MAPPING_UPDATE_PREFLIGHT);
        MappingMetadata mappingMetadata = indexMetadata.mapping();
        if (mappingMetadata != null) {
            this.merge(mappingMetadata.type(), mappingMetadata.source(), reason);
        }
    }

    public DocumentMapper merge(String type, List<CompressedXContent> mappingSources, MergeReason reason) {
        DocumentMapper currentMapper = this.mapper;
        if (currentMapper != null && mappingSources.size() == 1 && currentMapper.mappingSource().equals(mappingSources.get(0))) {
            return currentMapper;
        }
        Map<String, Object> mergedRawMapping = null;
        for (CompressedXContent mappingSource : mappingSources) {
            Map<String, Object> rawMapping = MappingParser.convertToMap(mappingSource);
            if (rawMapping.containsKey(type)) {
                if (rawMapping.size() > 1) {
                    throw new MapperParsingException("cannot merge a map with multiple roots, one of which is [" + type + "]");
                }
            } else {
                rawMapping = Map.of(type, rawMapping);
            }
            if (mergedRawMapping == null) {
                mergedRawMapping = rawMapping;
                continue;
            }
            XContentHelper.merge(type, mergedRawMapping, rawMapping, RawFieldMappingMerge.INSTANCE);
        }
        if (mergedRawMapping != null && mergedRawMapping.size() > 1) {
            throw new MapperParsingException("cannot merge mapping sources with different roots");
        }
        return mergedRawMapping != null ? this.doMerge(type, reason, mergedRawMapping) : null;
    }

    public DocumentMapper merge(String type, CompressedXContent mappingSource, MergeReason reason) {
        DocumentMapper currentMapper = this.mapper;
        if (currentMapper != null && currentMapper.mappingSource().equals(mappingSource)) {
            return currentMapper;
        }
        Map<String, Object> mappingSourceAsMap = MappingParser.convertToMap(mappingSource);
        return this.doMerge(type, reason, mappingSourceAsMap);
    }

    private synchronized DocumentMapper doMerge(String type, MergeReason reason, Map<String, Object> mappingSourceAsMap) {
        Mapping incomingMapping = this.parseMapping(type, mappingSourceAsMap);
        Mapping mapping = MapperService.mergeMappings(this.mapper, incomingMapping, reason);
        DocumentMapper newMapper = this.newDocumentMapper(mapping, reason, mapping.toCompressedXContent());
        if (reason == MergeReason.MAPPING_UPDATE_PREFLIGHT) {
            return newMapper;
        }
        this.mapper = newMapper;
        assert (this.assertSerialization(newMapper));
        return newMapper;
    }

    private DocumentMapper newDocumentMapper(Mapping mapping, MergeReason reason, CompressedXContent mappingSource) {
        DocumentMapper newMapper = new DocumentMapper(this.documentParser, mapping, mappingSource, this.indexVersionCreated);
        newMapper.validate(this.indexSettings, reason != MergeReason.MAPPING_RECOVERY);
        return newMapper;
    }

    public Mapping parseMapping(String mappingType, CompressedXContent mappingSource) {
        try {
            return this.mappingParser.parse(mappingType, mappingSource);
        }
        catch (Exception e) {
            throw new MapperParsingException("Failed to parse mapping: {}", (Throwable)e, e.getMessage());
        }
    }

    public Mapping parseMapping(String mappingType, Map<String, Object> mappingSource) {
        try {
            return this.mappingParser.parse(mappingType, mappingSource);
        }
        catch (Exception e) {
            throw new MapperParsingException("Failed to parse mapping: {}", (Throwable)e, e.getMessage());
        }
    }

    public static Mapping mergeMappings(DocumentMapper currentMapper, Mapping incomingMapping, MergeReason reason) {
        Mapping newMapping = currentMapper == null ? incomingMapping : currentMapper.mapping().merge(incomingMapping, reason);
        return newMapping;
    }

    private boolean assertSerialization(DocumentMapper mapper) {
        CompressedXContent mappingSource = mapper.mappingSource();
        Mapping newMapping = this.parseMapping(mapper.type(), mappingSource);
        if (!newMapping.toCompressedXContent().equals(mappingSource)) {
            throw new AssertionError((Object)("Mapping serialization result is different from source. \n--> Source [" + mappingSource + "]\n--> Result [" + newMapping.toCompressedXContent() + "]"));
        }
        return true;
    }

    public DocumentMapper documentMapper() {
        return this.mapper;
    }

    public static boolean isMappingSourceTyped(String type, Map<String, Object> mapping) {
        return mapping.size() == 1 && mapping.keySet().iterator().next().equals(type);
    }

    private String resolveDocumentType(String type) {
        if (SINGLE_MAPPING_NAME.equals(type) && this.mapper != null) {
            return this.mapper.type();
        }
        return type;
    }

    public MappedFieldType fieldType(String fullName) {
        return this.mappingLookup().fieldTypesLookup().get(fullName);
    }

    public MappingLookup mappingLookup() {
        DocumentMapper mapper = this.mapper;
        return mapper == null ? MappingLookup.EMPTY : mapper.mappers();
    }

    public Iterable<MappedFieldType> getEagerGlobalOrdinalsFields() {
        DocumentMapper mapper = this.mapper;
        if (mapper == null) {
            return Collections.emptySet();
        }
        MappingLookup mappingLookup = mapper.mappers();
        return mappingLookup.getMatchingFieldNames("*").stream().map(mappingLookup::getFieldType).filter(MappedFieldType::eagerGlobalOrdinals).toList();
    }

    public NamedAnalyzer indexAnalyzer(String field, Function<String, NamedAnalyzer> unindexedFieldAnalyzer) {
        return this.mappingLookup().indexAnalyzer(field, unindexedFieldAnalyzer);
    }

    @Override
    public void close() throws IOException {
        this.indexAnalyzers.close();
    }

    @Deprecated
    public static boolean isMetadataFieldStatic(String fieldName) {
        if (IndicesModule.getBuiltInMetadataFields().contains(fieldName)) {
            return true;
        }
        return fieldName.equals("_size");
    }

    public boolean isMetadataField(String field) {
        return this.mapperRegistry.getMetadataMapperParsers(this.indexVersionCreated).containsKey(field);
    }

    public boolean isMultiField(String field) {
        return this.mappingLookup().isMultiField(field);
    }

    public synchronized List<String> reloadSearchAnalyzers(AnalysisRegistry registry, @Nullable String resource, boolean preview) throws IOException {
        this.logger.info("reloading search analyzers");
        return this.indexAnalyzers.reload(registry, this.indexSettings, resource, preview);
    }

    public DynamicTemplate[] getAllDynamicTemplates() {
        return this.documentMapper().mapping().getRoot().dynamicTemplates();
    }

    public MapperRegistry getMapperRegistry() {
        return this.mapperRegistry;
    }

    public static enum MergeReason {
        MAPPING_UPDATE_PREFLIGHT,
        MAPPING_UPDATE,
        INDEX_TEMPLATE,
        MAPPING_RECOVERY;

    }

    private static class RawFieldMappingMerge
    implements XContentHelper.CustomMerge {
        private static final XContentHelper.CustomMerge INSTANCE = new RawFieldMappingMerge();
        private static final Set<String> MERGEABLE_OBJECT_TYPES = Set.of("object", "nested");

        private RawFieldMappingMerge() {
        }

        @Override
        public Object merge(String parent, String key, Object oldValue, Object newValue) {
            if (oldValue instanceof Map && newValue instanceof Map) {
                if ("properties".equals(parent)) {
                    Map baseMap = (Map)oldValue;
                    Map mapToMerge = (Map)newValue;
                    if (this.shouldMergeFieldMappings(baseMap, mapToMerge)) {
                        HashMap<String, Object> mergedMappings = new HashMap<String, Object>();
                        if (baseMap.containsKey("properties")) {
                            mergedMappings.put("properties", new HashMap((Map)baseMap.get("properties")));
                        }
                        if (baseMap.containsKey("subobjects")) {
                            mergedMappings.put("subobjects", baseMap.get("subobjects"));
                        }
                        XContentHelper.merge(key, mergedMappings, mapToMerge, INSTANCE);
                        return mergedMappings;
                    }
                    return mapToMerge;
                }
                return null;
            }
            if (key.equals("required") && "_routing".equals(parent) && oldValue != newValue) {
                throw new MapperParsingException("contradicting `_routing.required` settings");
            }
            return newValue;
        }

        private boolean shouldMergeFieldMappings(Map<String, Object> mappings1, Map<String, Object> mappings2) {
            String type2;
            String type1 = (String)mappings1.get("type");
            if (type1 == null && mappings1.get("properties") != null) {
                type1 = "object";
            }
            if ((type2 = (String)mappings2.get("type")) == null && mappings2.get("properties") != null) {
                type2 = "object";
            }
            if (type1 == null || type2 == null) {
                return false;
            }
            return MERGEABLE_OBJECT_TYPES.contains(type1) && MERGEABLE_OBJECT_TYPES.contains(type2);
        }
    }
}

