/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.time.ZoneId;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.index.fielddata.BooleanScriptFieldData;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.mapper.AbstractScriptFieldType;
import org.elasticsearch.index.mapper.OnScriptError;
import org.elasticsearch.index.mapper.RuntimeField;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.BooleanFieldScript;
import org.elasticsearch.script.CompositeFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.field.BooleanDocValuesField;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.runtime.BooleanScriptFieldExistsQuery;
import org.elasticsearch.search.runtime.BooleanScriptFieldTermQuery;

public final class BooleanScriptFieldType
extends AbstractScriptFieldType<BooleanFieldScript.LeafFactory> {
    public static final RuntimeField.Parser PARSER = new RuntimeField.Parser(Builder::new);

    public static RuntimeField sourceOnly(String name) {
        return new Builder(name).createRuntimeField(BooleanFieldScript.PARSE_FROM_SOURCE);
    }

    BooleanScriptFieldType(String name, BooleanFieldScript.Factory scriptFactory, Script script, Map<String, String> meta, OnScriptError onScriptError) {
        super(name, (SearchLookup searchLookup) -> scriptFactory.newFactory(name, script.getParams(), (SearchLookup)searchLookup, onScriptError), script, scriptFactory.isResultDeterministic(), meta);
    }

    @Override
    public String typeName() {
        return "boolean";
    }

    @Override
    public Object valueForDisplay(Object value) {
        if (value == null) {
            return null;
        }
        return switch (value.toString()) {
            case "F" -> false;
            case "T" -> true;
            default -> throw new IllegalArgumentException("Expected [T] or [F] but got [" + value + "]");
        };
    }

    @Override
    public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
        this.checkNoFormat(format);
        this.checkNoTimeZone(timeZone);
        return DocValueFormat.BOOLEAN;
    }

    @Override
    public BooleanScriptFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
        return new BooleanScriptFieldData.Builder(this.name(), (BooleanFieldScript.LeafFactory)this.leafFactory(fieldDataContext.lookupSupplier().get()), BooleanDocValuesField::new);
    }

    @Override
    public Query existsQuery(SearchExecutionContext context) {
        this.applyScriptContext(context);
        return new BooleanScriptFieldExistsQuery(this.script, (BooleanFieldScript.LeafFactory)this.leafFactory(context), this.name());
    }

    @Override
    public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ZoneId timeZone, DateMathParser parser, SearchExecutionContext context) {
        boolean falseAllowed;
        boolean trueAllowed;
        if (BooleanScriptFieldType.toBoolean(lowerTerm)) {
            if (includeLower) {
                trueAllowed = true;
                falseAllowed = false;
            } else {
                trueAllowed = false;
                falseAllowed = false;
            }
        } else if (includeLower) {
            trueAllowed = true;
            falseAllowed = true;
        } else {
            trueAllowed = true;
            falseAllowed = false;
        }
        if (BooleanScriptFieldType.toBoolean(upperTerm)) {
            if (includeUpper) {
                trueAllowed &= true;
                falseAllowed &= true;
            } else {
                trueAllowed &= false;
                falseAllowed &= true;
            }
        } else if (includeUpper) {
            trueAllowed &= false;
            falseAllowed &= true;
        } else {
            trueAllowed &= false;
            falseAllowed &= false;
        }
        return this.termsQuery(trueAllowed, falseAllowed, context);
    }

    @Override
    public Query termQueryCaseInsensitive(Object value, SearchExecutionContext context) {
        this.applyScriptContext(context);
        return new BooleanScriptFieldTermQuery(this.script, (BooleanFieldScript.LeafFactory)this.leafFactory(context.lookup()), this.name(), BooleanScriptFieldType.toBoolean(value, true));
    }

    @Override
    public Query termQuery(Object value, SearchExecutionContext context) {
        this.applyScriptContext(context);
        return new BooleanScriptFieldTermQuery(this.script, (BooleanFieldScript.LeafFactory)this.leafFactory(context), this.name(), BooleanScriptFieldType.toBoolean(value, false));
    }

    @Override
    public Query termsQuery(Collection<?> values, SearchExecutionContext context) {
        if (values.isEmpty()) {
            return Queries.newMatchNoDocsQuery("Empty terms query");
        }
        boolean trueAllowed = false;
        boolean falseAllowed = false;
        for (Object value : values) {
            if (BooleanScriptFieldType.toBoolean(value, false)) {
                trueAllowed = true;
                continue;
            }
            falseAllowed = true;
        }
        return this.termsQuery(trueAllowed, falseAllowed, context);
    }

    private Query termsQuery(boolean trueAllowed, boolean falseAllowed, SearchExecutionContext context) {
        if (trueAllowed) {
            if (falseAllowed) {
                return this.existsQuery(context);
            }
            this.applyScriptContext(context);
            return new BooleanScriptFieldTermQuery(this.script, (BooleanFieldScript.LeafFactory)this.leafFactory(context), this.name(), true);
        }
        if (falseAllowed) {
            this.applyScriptContext(context);
            return new BooleanScriptFieldTermQuery(this.script, (BooleanFieldScript.LeafFactory)this.leafFactory(context), this.name(), false);
        }
        return new MatchNoDocsQuery("neither true nor false allowed");
    }

    private static boolean toBoolean(Object value) {
        return BooleanScriptFieldType.toBoolean(value, false);
    }

    private static boolean toBoolean(Object value, boolean caseInsensitive) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        String sValue = value instanceof BytesRef ? ((BytesRef)value).utf8ToString() : value.toString();
        if (caseInsensitive) {
            sValue = Strings.toLowercaseAscii(sValue);
        }
        return Booleans.parseBoolean((String)sValue);
    }

    private static class Builder
    extends AbstractScriptFieldType.Builder<BooleanFieldScript.Factory> {
        Builder(String name) {
            super(name, BooleanFieldScript.CONTEXT);
        }

        @Override
        protected AbstractScriptFieldType<?> createFieldType(String name, BooleanFieldScript.Factory factory, Script script, Map<String, String> meta, OnScriptError onScriptError) {
            return new BooleanScriptFieldType(name, factory, script, meta, onScriptError);
        }

        @Override
        protected BooleanFieldScript.Factory getParseFromSourceFactory() {
            return BooleanFieldScript.PARSE_FROM_SOURCE;
        }

        @Override
        protected BooleanFieldScript.Factory getCompositeLeafFactory(Function<SearchLookup, CompositeFieldScript.LeafFactory> parentScriptFactory) {
            return BooleanFieldScript.leafAdapter(parentScriptFactory);
        }
    }
}

