/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FilterCodecReader;
import org.apache.lucene.index.FilterNumericDocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.OneMergeWrappingMergePolicy;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.search.ConjunctionUtils;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.elasticsearch.search.internal.FilterStoredFieldVisitor;

final class RecoverySourcePruneMergePolicy
extends OneMergeWrappingMergePolicy {
    RecoverySourcePruneMergePolicy(String recoverySourceField, boolean pruneIdField, Supplier<Query> retainSourceQuerySupplier, MergePolicy in) {
        super(in, toWrap -> new MergePolicy.OneMerge(toWrap.segments, (MergePolicy.OneMerge)toWrap, recoverySourceField, pruneIdField, retainSourceQuerySupplier){
            final /* synthetic */ MergePolicy.OneMerge val$toWrap;
            final /* synthetic */ String val$recoverySourceField;
            final /* synthetic */ boolean val$pruneIdField;
            final /* synthetic */ Supplier val$retainSourceQuerySupplier;
            {
                this.val$toWrap = oneMerge;
                this.val$recoverySourceField = string;
                this.val$pruneIdField = bl;
                this.val$retainSourceQuerySupplier = supplier;
                super(arg0);
            }

            public CodecReader wrapForMerge(CodecReader reader) throws IOException {
                CodecReader wrapped = this.val$toWrap.wrapForMerge(reader);
                return RecoverySourcePruneMergePolicy.wrapReader(this.val$recoverySourceField, this.val$pruneIdField, wrapped, this.val$retainSourceQuerySupplier);
            }
        });
    }

    private static CodecReader wrapReader(String recoverySourceField, boolean pruneIdField, CodecReader reader, Supplier<Query> retainSourceQuerySupplier) throws IOException {
        NumericDocValues recoverySource = reader.getNumericDocValues(recoverySourceField);
        if (recoverySource == null || recoverySource.nextDoc() == Integer.MAX_VALUE) {
            return reader;
        }
        IndexSearcher s = new IndexSearcher((IndexReader)reader);
        s.setQueryCache(null);
        Weight weight = s.createWeight(s.rewrite(retainSourceQuerySupplier.get()), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        Scorer scorer = weight.scorer(reader.getContext());
        if (scorer != null) {
            BitSet recoverySourceToKeep = BitSet.of((DocIdSetIterator)scorer.iterator(), (int)reader.maxDoc());
            if (recoverySourceToKeep.cardinality() == reader.maxDoc()) {
                return reader;
            }
            return new SourcePruningFilterCodecReader(recoverySourceField, pruneIdField, reader, recoverySourceToKeep);
        }
        return new SourcePruningFilterCodecReader(recoverySourceField, pruneIdField, reader, null);
    }

    private static class SourcePruningFilterCodecReader
    extends FilterCodecReader {
        private final BitSet recoverySourceToKeep;
        private final String recoverySourceField;
        private final boolean pruneIdField;

        SourcePruningFilterCodecReader(String recoverySourceField, boolean pruneIdField, CodecReader reader, BitSet recoverySourceToKeep) {
            super(reader);
            this.recoverySourceField = recoverySourceField;
            this.recoverySourceToKeep = recoverySourceToKeep;
            this.pruneIdField = pruneIdField;
        }

        public DocValuesProducer getDocValuesReader() {
            DocValuesProducer docValuesReader = super.getDocValuesReader();
            return new FilterDocValuesProducer(docValuesReader){

                @Override
                public NumericDocValues getNumeric(FieldInfo field) throws IOException {
                    NumericDocValues numeric = super.getNumeric(field);
                    if (recoverySourceField.equals(field.name)) {
                        assert (numeric != null) : recoverySourceField + " must have numeric DV but was null";
                        final DocIdSetIterator intersection = recoverySourceToKeep == null ? DocIdSetIterator.empty() : ConjunctionUtils.intersectIterators(Arrays.asList(numeric, new BitSetIterator(recoverySourceToKeep, (long)recoverySourceToKeep.length())));
                        return new FilterNumericDocValues(numeric){

                            public int nextDoc() throws IOException {
                                return intersection.nextDoc();
                            }

                            public int advance(int target) {
                                throw new UnsupportedOperationException();
                            }

                            public boolean advanceExact(int target) {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }
                    return numeric;
                }
            };
        }

        public StoredFieldsReader getFieldsReader() {
            return new RecoverySourcePruningStoredFieldsReader(super.getFieldsReader(), this.recoverySourceToKeep, this.recoverySourceField, this.pruneIdField);
        }

        public IndexReader.CacheHelper getCoreCacheHelper() {
            return null;
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return null;
        }

        private static class RecoverySourcePruningStoredFieldsReader
        extends FilterStoredFieldsReader {
            private final BitSet recoverySourceToKeep;
            private final String recoverySourceField;
            private final boolean pruneIdField;

            RecoverySourcePruningStoredFieldsReader(StoredFieldsReader in, BitSet recoverySourceToKeep, String recoverySourceField, boolean pruneIdField) {
                super(in);
                this.recoverySourceToKeep = recoverySourceToKeep;
                this.recoverySourceField = Objects.requireNonNull(recoverySourceField);
                this.pruneIdField = pruneIdField;
            }

            @Override
            public void document(int docID, StoredFieldVisitor visitor) throws IOException {
                if (this.recoverySourceToKeep != null && this.recoverySourceToKeep.get(docID)) {
                    super.document(docID, visitor);
                } else {
                    super.document(docID, new FilterStoredFieldVisitor(visitor){

                        @Override
                        public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
                            if (recoverySourceField.equals(fieldInfo.name)) {
                                return StoredFieldVisitor.Status.NO;
                            }
                            if (pruneIdField && "_id".equals(fieldInfo.name)) {
                                return StoredFieldVisitor.Status.NO;
                            }
                            return super.needsField(fieldInfo);
                        }
                    });
                }
            }

            public StoredFieldsReader getMergeInstance() {
                return new RecoverySourcePruningStoredFieldsReader(this.in.getMergeInstance(), this.recoverySourceToKeep, this.recoverySourceField, this.pruneIdField);
            }

            @Override
            public StoredFieldsReader clone() {
                return new RecoverySourcePruningStoredFieldsReader(this.in.clone(), this.recoverySourceToKeep, this.recoverySourceField, this.pruneIdField);
            }
        }

        private static abstract class FilterStoredFieldsReader
        extends StoredFieldsReader {
            protected final StoredFieldsReader in;

            FilterStoredFieldsReader(StoredFieldsReader fieldsReader) {
                this.in = fieldsReader;
            }

            public void close() throws IOException {
                this.in.close();
            }

            public void document(int docID, StoredFieldVisitor visitor) throws IOException {
                this.in.document(docID, visitor);
            }

            public abstract StoredFieldsReader clone();

            public void checkIntegrity() throws IOException {
                this.in.checkIntegrity();
            }
        }

        private static class FilterDocValuesProducer
        extends DocValuesProducer {
            private final DocValuesProducer in;

            FilterDocValuesProducer(DocValuesProducer in) {
                this.in = in;
            }

            public NumericDocValues getNumeric(FieldInfo field) throws IOException {
                return this.in.getNumeric(field);
            }

            public BinaryDocValues getBinary(FieldInfo field) throws IOException {
                return this.in.getBinary(field);
            }

            public SortedDocValues getSorted(FieldInfo field) throws IOException {
                return this.in.getSorted(field);
            }

            public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
                return this.in.getSortedNumeric(field);
            }

            public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
                return this.in.getSortedSet(field);
            }

            public void checkIntegrity() throws IOException {
                this.in.checkIntegrity();
            }

            public void close() throws IOException {
                this.in.close();
            }
        }
    }
}

