/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import org.apache.lucene.util.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.internal.VersionExtension;
import org.elasticsearch.plugins.ExtensionLoader;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public record IndexVersion(int id, Version luceneVersion) implements VersionId<IndexVersion>,
ToXContentFragment
{
    private static Map<String, Integer> IDS = new HashMap<String, Integer>();
    public static final IndexVersion ZERO = IndexVersion.registerIndexVersion(0, Version.LATEST, "00000000-0000-0000-0000-000000000000");
    public static final IndexVersion V_7_0_0 = IndexVersion.registerIndexVersion(7000099, Version.LUCENE_8_0_0, "b32be92d-c403-4858-a4a3-20d699a47ae6");
    public static final IndexVersion V_7_1_0 = IndexVersion.registerIndexVersion(7010099, Version.LUCENE_8_0_0, "f9964d87-9f20-4b26-af32-be1f979216ec");
    public static final IndexVersion V_7_2_0 = IndexVersion.registerIndexVersion(7020099, Version.LUCENE_8_0_0, "dba49448-87d4-45bb-ba19-f7b4eb85c757");
    public static final IndexVersion V_7_2_1 = IndexVersion.registerIndexVersion(7020199, Version.LUCENE_8_0_0, "58874b45-f9f8-4c04-92a9-67548a8b21c3");
    public static final IndexVersion V_7_3_0 = IndexVersion.registerIndexVersion(7030099, Version.LUCENE_8_1_0, "3d8a21df-58a4-4d7a-ba5d-438c92c16a7b");
    public static final IndexVersion V_7_4_0 = IndexVersion.registerIndexVersion(7040099, Version.LUCENE_8_2_0, "c1fe73ba-0173-476c-aba2-855c2b31ac18");
    public static final IndexVersion V_7_5_0 = IndexVersion.registerIndexVersion(7050099, Version.LUCENE_8_3_0, "ab08ae25-ede2-4e57-a43f-89d96aa989e4");
    public static final IndexVersion V_7_5_2 = IndexVersion.registerIndexVersion(7050299, Version.LUCENE_8_3_0, "706715ca-3b91-40d2-8c2e-c34c459b5d0d");
    public static final IndexVersion V_7_6_0 = IndexVersion.registerIndexVersion(7060099, Version.LUCENE_8_4_0, "63acbdb9-51c8-4976-bb3d-e55052a4fbd4");
    public static final IndexVersion V_7_7_0 = IndexVersion.registerIndexVersion(7070099, Version.LUCENE_8_5_1, "6fff8238-e6ce-4fb2-85de-196492026e49");
    public static final IndexVersion V_7_8_0 = IndexVersion.registerIndexVersion(7080099, Version.LUCENE_8_5_1, "81d7d459-f386-4c20-8235-f8fce8af7f0e");
    public static final IndexVersion V_7_9_0 = IndexVersion.registerIndexVersion(7090099, Version.LUCENE_8_6_0, "0fa951a2-43ce-4f76-91bf-066c1ecf8a93");
    public static final IndexVersion V_7_10_0 = IndexVersion.registerIndexVersion(7100099, Version.LUCENE_8_7_0, "92ccd91c-0251-4263-8873-9f1abfac3c10");
    public static final IndexVersion V_7_11_0 = IndexVersion.registerIndexVersion(7110099, Version.LUCENE_8_7_0, "e6d65f96-26d5-4669-ac5a-2964b9b1699f");
    public static final IndexVersion V_7_12_0 = IndexVersion.registerIndexVersion(7120099, Version.LUCENE_8_8_0, "39e2989a-a9a4-4f1a-b185-2e6015f74b1c");
    public static final IndexVersion V_7_13_0 = IndexVersion.registerIndexVersion(7130099, Version.LUCENE_8_8_2, "28b21fe0-4d1f-4c04-95cc-74df494ae0cf");
    public static final IndexVersion V_7_14_0 = IndexVersion.registerIndexVersion(7140099, Version.LUCENE_8_9_0, "b45bb223-bb73-4379-a46f-7dc74d38aaca");
    public static final IndexVersion V_7_15_0 = IndexVersion.registerIndexVersion(7150099, Version.LUCENE_8_9_0, "ab666b02-b866-4b64-9ba3-d511e86c55b5");
    public static final IndexVersion V_7_16_0 = IndexVersion.registerIndexVersion(7160099, Version.LUCENE_8_10_1, "a582e900-2d92-474c-9be3-2e08fa88be4b");
    public static final IndexVersion V_7_17_0 = IndexVersion.registerIndexVersion(7170099, Version.LUCENE_8_11_1, "18766ab8-4691-40a2-94f1-526f3b71420c");
    public static final IndexVersion V_8_0_0 = IndexVersion.registerIndexVersion(8000099, Version.LUCENE_9_0_0, "ff18a13c-1fa7-4cf7-a3b1-4fdcd9461d5b");
    public static final IndexVersion V_8_1_0 = IndexVersion.registerIndexVersion(8010099, Version.LUCENE_9_0_0, "b4742461-ee43-4fd0-a260-29f8388b82ec");
    public static final IndexVersion V_8_2_0 = IndexVersion.registerIndexVersion(8020099, Version.LUCENE_9_1_0, "af0ed990-2f32-42b5-aaf3-59d21a3dca7a");
    public static final IndexVersion V_8_3_0 = IndexVersion.registerIndexVersion(8030099, Version.LUCENE_9_2_0, "eca8e8a3-0724-4247-a58d-e4eafcec4b3f");
    public static final IndexVersion V_8_4_0 = IndexVersion.registerIndexVersion(8040099, Version.LUCENE_9_3_0, "d27324da-b36c-452a-93a8-9b69a6c302a1");
    public static final IndexVersion V_8_5_0 = IndexVersion.registerIndexVersion(8050099, Version.LUCENE_9_4_1, "c5284b51-7fee-4f34-a837-241bb57a7aa6");
    public static final IndexVersion V_8_6_0 = IndexVersion.registerIndexVersion(8060099, Version.LUCENE_9_4_2, "5e78c76c-74aa-464e-9383-89bdffb74db9");
    public static final IndexVersion V_8_7_0 = IndexVersion.registerIndexVersion(8070099, Version.LUCENE_9_5_0, "f9227941-d6f4-462b-957f-2bcd36c28382");
    public static final IndexVersion V_8_8_0 = IndexVersion.registerIndexVersion(8080099, Version.LUCENE_9_6_0, "d6ffc8d7-f6bd-469b-8495-01688c310000");
    public static final IndexVersion V_8_8_2 = IndexVersion.registerIndexVersion(8080299, Version.LUCENE_9_6_0, "9db9d888-6be8-4a58-825c-f423fd8c6b00");
    public static final IndexVersion V_8_9_0 = IndexVersion.registerIndexVersion(8090099, Version.LUCENE_9_7_0, "32f6dbab-cc24-4f5b-87b5-015a848480d9");
    public static final IndexVersion V_8_9_1 = IndexVersion.registerIndexVersion(8090199, Version.LUCENE_9_7_0, "955a80ac-f70c-40a5-9399-1d8a1e5d342d");
    public static final IndexVersion V_8_10_0 = IndexVersion.registerIndexVersion(8100099, Version.LUCENE_9_7_0, "2e107286-12ad-4c51-9a6f-f8943663b6e7");
    public static final IndexVersion V_8_500_000 = IndexVersion.registerIndexVersion(8500000, Version.LUCENE_9_7_0, "bf656f5e-5808-4eee-bf8a-e2bf6736ff55");
    public static final IndexVersion V_8_500_001 = IndexVersion.registerIndexVersion(8500001, Version.LUCENE_9_7_0, "45045a5a-fc57-4462-89f6-6bc04cda6015");
    public static final IndexVersion V_8_500_002 = IndexVersion.registerIndexVersion(8500002, Version.LUCENE_9_7_0, "50b39bf8-6c6a-443e-a5e5-069438d843c1");
    public static final IndexVersion V_8_500_003 = IndexVersion.registerIndexVersion(8500003, Version.LUCENE_9_8_0, "82bb022a-7ca2-463f-9c58-67821e24b72f");
    public static final IndexVersion MINIMUM_COMPATIBLE = V_7_0_0;
    private static final NavigableMap<Integer, IndexVersion> VERSION_IDS = IndexVersion.getAllVersionIds(IndexVersion.class);
    static final IndexVersion LATEST_DEFINED = VERSION_IDS.lastEntry().getValue();

    private static IndexVersion registerIndexVersion(int id, Version luceneVersion, String uniqueId) {
        if (IDS == null) {
            throw new IllegalStateException("The IDS map needs to be present to call this method");
        }
        Strings.requireNonEmpty(uniqueId, "Each IndexVersion needs a unique string id");
        Integer existing = IDS.put(uniqueId, id);
        if (existing != null) {
            throw new IllegalArgumentException("Versions " + id + " and " + existing + " have the same unique id");
        }
        return new IndexVersion(id, luceneVersion);
    }

    static NavigableMap<Integer, IndexVersion> getAllVersionIds(Class<?> cls) {
        HashMap<Integer, String> versionIdFields = new HashMap<Integer, String>();
        TreeMap<Integer, IndexVersion> builder = new TreeMap<Integer, IndexVersion>();
        Set<String> ignore = Set.of("ZERO", "CURRENT", "MINIMUM_COMPATIBLE");
        for (Field declaredField : cls.getFields()) {
            IndexVersion version;
            String fieldName;
            if (!declaredField.getType().equals(IndexVersion.class) || ignore.contains(fieldName = declaredField.getName())) continue;
            try {
                version = (IndexVersion)declaredField.get(null);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            builder.put(version.id, version);
            if (!Assertions.ENABLED) continue;
            String sameVersionNumber = versionIdFields.put(version.id, fieldName);
            assert (sameVersionNumber == null) : "Versions [" + sameVersionNumber + "] and [" + fieldName + "] have the same version number [" + version.id + "]. Each IndexVersion should have a different version number";
        }
        return Collections.unmodifiableNavigableMap(builder);
    }

    static Collection<IndexVersion> getAllVersions() {
        return VERSION_IDS.values();
    }

    public static IndexVersion readVersion(StreamInput in) throws IOException {
        return IndexVersion.fromId(in.readVInt());
    }

    public static IndexVersion fromId(int id) {
        IndexVersion known = (IndexVersion)VERSION_IDS.get(id);
        if (known != null) {
            return known;
        }
        Map.Entry<Integer, IndexVersion> prev = VERSION_IDS.floorEntry(id);
        Version luceneVersion = prev != null ? prev.getValue().luceneVersion : Version.fromBits((int)(IndexVersion.VERSION_IDS.firstEntry().getValue().luceneVersion.major - 1), (int)0, (int)0);
        return new IndexVersion(id, luceneVersion);
    }

    public static void writeVersion(IndexVersion version, StreamOutput out) throws IOException {
        out.writeVInt(version.id);
    }

    public static IndexVersion min(IndexVersion version1, IndexVersion version2) {
        return version1.id < version2.id ? version1 : version2;
    }

    public static IndexVersion max(IndexVersion version1, IndexVersion version2) {
        return version1.id > version2.id ? version1 : version2;
    }

    public static IndexVersion current() {
        return CurrentHolder.CURRENT;
    }

    public boolean isLegacyIndexVersion() {
        return this.before(MINIMUM_COMPATIBLE);
    }

    public static IndexVersion getMinimumCompatibleIndexVersion(int versionId) {
        int major = versionId / 1000000;
        if (major == IndexVersion.current().id() / 1000000) {
            return MINIMUM_COMPATIBLE;
        }
        int compatId = (major - 1) * 1000000;
        if (major <= 8) {
            compatId += 99;
        }
        return IndexVersion.fromId(compatId);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.value(this.id);
    }

    @Override
    public String toString() {
        return Integer.toString(this.id);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexVersion version = (IndexVersion)o;
        return this.id == version.id;
    }

    @Override
    public int hashCode() {
        return this.id;
    }

    static {
        IDS = null;
    }

    private static class CurrentHolder {
        private static final IndexVersion CURRENT = CurrentHolder.findCurrent();

        private CurrentHolder() {
        }

        private static IndexVersion findCurrent() {
            VersionExtension versionExtension = ExtensionLoader.loadSingleton(ServiceLoader.load(VersionExtension.class), () -> null);
            if (versionExtension == null) {
                return LATEST_DEFINED;
            }
            IndexVersion version = versionExtension.getCurrentIndexVersion(LATEST_DEFINED);
            assert (version.onOrAfter(LATEST_DEFINED));
            assert (version.luceneVersion.equals((Object)Version.LATEST)) : "IndexVersion must be upgraded to [" + Version.LATEST + "] is still set to [" + version.luceneVersion + "]";
            return version;
        }
    }
}

