/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStream;
import org.elasticsearch.common.io.stream.RecyclerBytesStreamOutput;
import org.elasticsearch.common.network.CloseableChannel;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.http.CorsHandler;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.http.HttpHandlingSettings;
import org.elasticsearch.http.HttpRequest;
import org.elasticsearch.http.HttpResponse;
import org.elasticsearch.http.HttpTracer;
import org.elasticsearch.http.HttpUtils;
import org.elasticsearch.rest.AbstractRestChannel;
import org.elasticsearch.rest.ChunkedRestResponseBody;
import org.elasticsearch.rest.LoggingChunkedRestResponseBody;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.telemetry.tracing.SpanId;
import org.elasticsearch.telemetry.tracing.Tracer;

public class DefaultRestChannel
extends AbstractRestChannel
implements RestChannel {
    static final String CLOSE = "close";
    static final String CONNECTION = "connection";
    static final String KEEP_ALIVE = "keep-alive";
    static final String CONTENT_TYPE = "content-type";
    static final String CONTENT_LENGTH = "content-length";
    static final String SET_COOKIE = "set-cookie";
    private final HttpRequest httpRequest;
    private final Recycler<BytesRef> recycler;
    private final HttpHandlingSettings settings;
    private final ThreadContext threadContext;
    private final HttpChannel httpChannel;
    private final CorsHandler corsHandler;
    private final Tracer tracer;
    @Nullable
    private final HttpTracer httpLogger;

    DefaultRestChannel(HttpChannel httpChannel, HttpRequest httpRequest, RestRequest request, Recycler<BytesRef> recycler, HttpHandlingSettings settings, ThreadContext threadContext, CorsHandler corsHandler, @Nullable HttpTracer httpLogger, Tracer tracer) {
        super(request, settings.detailedErrorsEnabled());
        this.httpChannel = httpChannel;
        this.httpRequest = httpRequest;
        this.recycler = recycler;
        this.settings = settings;
        this.threadContext = threadContext;
        this.corsHandler = corsHandler;
        this.httpLogger = httpLogger;
        this.tracer = tracer;
    }

    @Override
    protected BytesStream newBytesOutput() {
        return new RecyclerBytesStreamOutput(this.recycler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void sendResponse(RestResponse restResponse) {
        boolean isHeadRequest;
        String contentLength;
        String opaque;
        boolean success;
        ArrayList<Releasable> toClose;
        SpanId spanId;
        block31: {
            this.httpRequest.release();
            spanId = SpanId.forRestRequest(this.request);
            toClose = new ArrayList<Releasable>(4);
            if (HttpUtils.shouldCloseConnection(this.httpRequest)) {
                toClose.add(() -> CloseableChannel.closeChannel(this.httpChannel));
            }
            toClose.add(() -> this.tracer.stopTrace(this.request));
            success = false;
            opaque = null;
            contentLength = null;
            isHeadRequest = false;
            try {
                if (this.request.method() == RestRequest.Method.HEAD) {
                    isHeadRequest = true;
                }
            }
            catch (IllegalArgumentException ignored) {
                if ($assertionsDisabled || restResponse.status() == RestStatus.METHOD_NOT_ALLOWED) break block31;
                throw new AssertionError((Object)"request HTTP method is unsupported but HTTP status is not METHOD_NOT_ALLOWED(405)");
            }
        }
        try {
            HttpResponse httpResponse;
            if (!isHeadRequest && restResponse.isChunked()) {
                ChunkedRestResponseBody chunkedContent = restResponse.chunkedContent();
                toClose.add(chunkedContent);
                if (this.httpLogger != null && this.httpLogger.isBodyTracerEnabled()) {
                    OutputStream loggerStream = this.httpLogger.openResponseBodyLoggingStream(this.request.getRequestId());
                    toClose.add(() -> {
                        block2: {
                            try {
                                loggerStream.close();
                            }
                            catch (Exception e) {
                                if ($assertionsDisabled) break block2;
                                throw new AssertionError((Object)e);
                            }
                        }
                    });
                    chunkedContent = new LoggingChunkedRestResponseBody(chunkedContent, loggerStream);
                }
                httpResponse = this.httpRequest.createResponse(restResponse.status(), chunkedContent);
            } else {
                BytesReference finalContent;
                block32: {
                    BytesReference content = restResponse.content();
                    if (content instanceof Releasable) {
                        Releasable releasable = (Releasable)content;
                        toClose.add(releasable);
                    } else if (restResponse.isChunked()) {
                        toClose.add(restResponse.chunkedContent());
                    }
                    toClose.add(this::releaseOutputBuffer);
                    BytesReference bytesReference = finalContent = isHeadRequest ? BytesArray.EMPTY : content;
                    if (this.httpLogger != null && this.httpLogger.isBodyTracerEnabled()) {
                        try (OutputStream responseBodyLoggingStream = this.httpLogger.openResponseBodyLoggingStream(this.request.getRequestId());){
                            finalContent.writeTo(responseBodyLoggingStream);
                        }
                        catch (Exception e) {
                            if ($assertionsDisabled) break block32;
                            throw new AssertionError((Object)e);
                        }
                    }
                }
                httpResponse = this.httpRequest.createResponse(restResponse.status(), finalContent);
            }
            this.corsHandler.setCorsResponseHeaders(this.httpRequest, httpResponse);
            opaque = this.request.header("X-Opaque-Id");
            if (opaque != null) {
                DefaultRestChannel.setHeaderField(httpResponse, "X-Opaque-Id", opaque);
            }
            DefaultRestChannel.addCustomHeaders(httpResponse, restResponse.getHeaders());
            DefaultRestChannel.addCustomHeaders(httpResponse, restResponse.filterHeaders(this.threadContext.getResponseHeaders()));
            DefaultRestChannel.setHeaderField(httpResponse, CONTENT_TYPE, restResponse.contentType(), false);
            if (!restResponse.isChunked()) {
                contentLength = String.valueOf(restResponse.content().length());
                DefaultRestChannel.setHeaderField(httpResponse, CONTENT_LENGTH, contentLength, false);
            } else {
                DefaultRestChannel.setHeaderField(httpResponse, "Transfer-Encoding", "chunked");
            }
            this.addCookies(httpResponse);
            this.tracer.setAttribute(spanId, "http.status_code", restResponse.status().getStatus());
            restResponse.getHeaders().forEach((key, values) -> this.tracer.setAttribute(spanId, "http.response.headers." + key, String.join((CharSequence)"; ", values)));
            ActionListener<Void> listener = ActionListener.releasing(Releasables.wrap(toClose));
            if (this.httpLogger != null) {
                String finalContentLength = contentLength;
                String finalOpaque = opaque;
                listener = ActionListener.runAfter(listener, () -> this.httpLogger.logResponse(restResponse, this.httpChannel, finalContentLength, finalOpaque, this.request.getRequestId(), true));
            }
            try (ThreadContext.StoredContext ignored = this.threadContext.stashContext();){
                this.httpChannel.sendResponse(httpResponse, listener);
                return;
            }
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            Releasables.close(toClose);
            if (this.httpLogger == null) throw throwable;
            this.httpLogger.logResponse(restResponse, this.httpChannel, contentLength, opaque, this.request.getRequestId(), false);
            throw throwable;
        }
    }

    private static void setHeaderField(HttpResponse response, String headerField, String value) {
        DefaultRestChannel.setHeaderField(response, headerField, value, true);
    }

    private static void setHeaderField(HttpResponse response, String headerField, String value, boolean override) {
        if (override || !response.containsHeader(headerField)) {
            response.addHeader(headerField, value);
        }
    }

    private static void addCustomHeaders(HttpResponse response, Map<String, List<String>> customHeaders) {
        if (customHeaders != null) {
            for (Map.Entry<String, List<String>> headerEntry : customHeaders.entrySet()) {
                for (String headerValue : headerEntry.getValue()) {
                    DefaultRestChannel.setHeaderField(response, headerEntry.getKey(), headerValue);
                }
            }
        }
    }

    private void addCookies(HttpResponse response) {
        List<String> cookies;
        if (this.settings.resetCookies() && !(cookies = this.request.getHttpRequest().strictCookies()).isEmpty()) {
            for (String cookie : cookies) {
                response.addHeader(SET_COOKIE, cookie);
            }
        }
    }
}

