/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.health.node;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.health.node.DiskHealthInfo;
import org.elasticsearch.health.node.HealthInfoCache;
import org.elasticsearch.health.node.action.HealthNodeRequest;
import org.elasticsearch.health.node.action.TransportHealthNodeAction;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class UpdateHealthInfoCacheAction
extends ActionType<AcknowledgedResponse> {
    public static final UpdateHealthInfoCacheAction INSTANCE = new UpdateHealthInfoCacheAction();
    public static final String NAME = "cluster:monitor/update/health/info";

    private UpdateHealthInfoCacheAction() {
        super(NAME, AcknowledgedResponse::readFrom);
    }

    public static class TransportAction
    extends TransportHealthNodeAction<Request, AcknowledgedResponse> {
        private final HealthInfoCache nodeHealthOverview;

        @Inject
        public TransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, HealthInfoCache nodeHealthOverview) {
            super(UpdateHealthInfoCacheAction.NAME, transportService, clusterService, threadPool, actionFilters, Request::new, AcknowledgedResponse::readFrom, threadPool.executor("management"));
            this.nodeHealthOverview = nodeHealthOverview;
        }

        @Override
        protected void healthOperation(Task task, Request request, ClusterState clusterState, ActionListener<AcknowledgedResponse> listener) {
            this.nodeHealthOverview.updateNodeHealth(request.getNodeId(), request.getDiskHealthInfo());
            listener.onResponse(AcknowledgedResponse.of(true));
        }
    }

    public static class Request
    extends HealthNodeRequest {
        private final String nodeId;
        private final DiskHealthInfo diskHealthInfo;

        public Request(String nodeId, DiskHealthInfo diskHealthInfo) {
            this.nodeId = nodeId;
            this.diskHealthInfo = diskHealthInfo;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.nodeId = in.readString();
            this.diskHealthInfo = new DiskHealthInfo(in);
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public DiskHealthInfo getDiskHealthInfo() {
            return this.diskHealthInfo;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.nodeId);
            this.diskHealthInfo.writeTo(out);
        }

        @Override
        public String getDescription() {
            return "Update health info cache for node [" + this.nodeId + "] with health info [" + this.diskHealthInfo + "].";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.nodeId, request.nodeId) && Objects.equals(this.diskHealthInfo, request.diskHealthInfo);
        }

        public int hashCode() {
            return Objects.hash(this.nodeId, this.diskHealthInfo);
        }
    }
}

