/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.coordination.Coordinator;
import org.elasticsearch.cluster.coordination.ElectionStrategy;
import org.elasticsearch.cluster.coordination.LeaderHeartbeatService;
import org.elasticsearch.cluster.coordination.PreVoteCollector;
import org.elasticsearch.cluster.coordination.Reconfigurator;
import org.elasticsearch.cluster.coordination.StatefulPreVoteCollector;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RerouteService;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterApplier;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.cluster.version.CompatibilityVersions;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.discovery.FileBasedSeedHostsProvider;
import org.elasticsearch.discovery.SeedHostsProvider;
import org.elasticsearch.discovery.SettingsBasedSeedHostsProvider;
import org.elasticsearch.gateway.GatewayMetaState;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.monitor.NodeHealthService;
import org.elasticsearch.node.Node;
import org.elasticsearch.plugins.ClusterCoordinationPlugin;
import org.elasticsearch.plugins.DiscoveryPlugin;
import org.elasticsearch.transport.TransportService;

public class DiscoveryModule {
    private static final Logger logger = LogManager.getLogger(DiscoveryModule.class);
    public static final String MULTI_NODE_DISCOVERY_TYPE = "multi-node";
    public static final String SINGLE_NODE_DISCOVERY_TYPE = "single-node";
    @Deprecated
    public static final String LEGACY_MULTI_NODE_DISCOVERY_TYPE = "zen";
    public static final Setting<String> DISCOVERY_TYPE_SETTING = new Setting("discovery.type", "multi-node", Function.identity(), Setting.Property.NodeScope);
    public static final Setting<List<String>> DISCOVERY_SEED_PROVIDERS_SETTING = Setting.stringListSetting("discovery.seed_providers", Setting.Property.NodeScope);
    public static final String DEFAULT_ELECTION_STRATEGY = "default";
    public static final Setting<String> ELECTION_STRATEGY_SETTING = new Setting("cluster.election.strategy", "default", Function.identity(), Setting.Property.NodeScope);
    private final Coordinator coordinator;
    private final Reconfigurator reconfigurator;

    public DiscoveryModule(Settings settings, TransportService transportService, Client client, NamedWriteableRegistry namedWriteableRegistry, NetworkService networkService, MasterService masterService, ClusterApplier clusterApplier, ClusterSettings clusterSettings, List<DiscoveryPlugin> discoveryPlugins, List<ClusterCoordinationPlugin> clusterCoordinationPlugins, AllocationService allocationService, Path configFile, GatewayMetaState gatewayMetaState, RerouteService rerouteService, NodeHealthService nodeHealthService, CircuitBreakerService circuitBreakerService, CompatibilityVersions compatibilityVersions) {
        ArrayList<BiConsumer<DiscoveryNode, ClusterState>> joinValidators = new ArrayList<BiConsumer<DiscoveryNode, ClusterState>>();
        HashMap<String, Supplier<SeedHostsProvider>> hostProviders = new HashMap<String, Supplier<SeedHostsProvider>>();
        hostProviders.put("settings", () -> new SettingsBasedSeedHostsProvider(settings, transportService));
        hostProviders.put("file", () -> new FileBasedSeedHostsProvider(configFile));
        HashMap<String, ElectionStrategy> electionStrategies = new HashMap<String, ElectionStrategy>();
        electionStrategies.put(DEFAULT_ELECTION_STRATEGY, ElectionStrategy.DEFAULT_INSTANCE);
        for (DiscoveryPlugin discoveryPlugin : discoveryPlugins) {
            discoveryPlugin.getSeedHostProviders(transportService, networkService).forEach((key, value) -> {
                if (hostProviders.put((String)key, (Supplier<SeedHostsProvider>)value) != null) {
                    throw new IllegalArgumentException("Cannot register seed provider [" + key + "] twice");
                }
            });
        }
        for (ClusterCoordinationPlugin clusterCoordinationPlugin : clusterCoordinationPlugins) {
            BiConsumer<DiscoveryNode, ClusterState> joinValidator = clusterCoordinationPlugin.getJoinValidator();
            if (joinValidator != null) {
                joinValidators.add(joinValidator);
            }
            clusterCoordinationPlugin.getElectionStrategies().forEach((key, value) -> {
                if (electionStrategies.put((String)key, (ElectionStrategy)value) != null) {
                    throw new IllegalArgumentException("Cannot register election strategy [" + key + "] twice");
                }
            });
        }
        List<String> seedProviderNames = DISCOVERY_SEED_PROVIDERS_SETTING.get(settings);
        if (!seedProviderNames.contains("settings")) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("settings");
            arrayList.addAll(seedProviderNames);
            seedProviderNames = arrayList;
        }
        HashSet<String> hashSet = new HashSet<String>(seedProviderNames);
        hashSet.removeAll(hostProviders.keySet());
        if (!hashSet.isEmpty()) {
            throw new IllegalArgumentException("Unknown seed providers " + hashSet);
        }
        List<SeedHostsProvider> filteredSeedProviders = seedProviderNames.stream().map(hostProviders::get).map(Supplier::get).toList();
        String discoveryType = DISCOVERY_TYPE_SETTING.get(settings);
        SeedHostsProvider seedHostsProvider = hostsResolver -> {
            ArrayList<TransportAddress> addresses = new ArrayList<TransportAddress>();
            for (SeedHostsProvider provider : filteredSeedProviders) {
                addresses.addAll(provider.getSeedAddresses(hostsResolver));
            }
            return Collections.unmodifiableList(addresses);
        };
        ElectionStrategy electionStrategy = (ElectionStrategy)electionStrategies.get(ELECTION_STRATEGY_SETTING.get(settings));
        if (electionStrategy == null) {
            throw new IllegalArgumentException("Unknown election strategy " + ELECTION_STRATEGY_SETTING.get(settings));
        }
        if (LEGACY_MULTI_NODE_DISCOVERY_TYPE.equals(discoveryType)) {
            assert (Version.CURRENT.major == Version.V_7_0_0.major + 1);
            DeprecationLogger.getLogger(DiscoveryModule.class).critical(DeprecationCategory.SETTINGS, "legacy-discovery-type", "Support for setting [{}] to [{}] is deprecated and will be removed in a future version. Set this setting to [{}] instead.", DISCOVERY_TYPE_SETTING.getKey(), LEGACY_MULTI_NODE_DISCOVERY_TYPE, MULTI_NODE_DISCOVERY_TYPE);
        }
        this.reconfigurator = DiscoveryModule.getReconfigurator(settings, clusterSettings, clusterCoordinationPlugins);
        PreVoteCollector.Factory preVoteCollectorFactory = DiscoveryModule.getPreVoteCollectorFactory(clusterCoordinationPlugins);
        LeaderHeartbeatService leaderHeartbeatService = DiscoveryModule.getLeaderHeartbeatService(settings, clusterCoordinationPlugins);
        if (!(MULTI_NODE_DISCOVERY_TYPE.equals(discoveryType) || LEGACY_MULTI_NODE_DISCOVERY_TYPE.equals(discoveryType) || SINGLE_NODE_DISCOVERY_TYPE.equals(discoveryType))) {
            throw new IllegalArgumentException("Unknown discovery type [" + discoveryType + "]");
        }
        this.coordinator = new Coordinator(Node.NODE_NAME_SETTING.get(settings), settings, clusterSettings, transportService, client, namedWriteableRegistry, allocationService, masterService, gatewayMetaState::getPersistedState, seedHostsProvider, clusterApplier, joinValidators, new Random(Randomness.get().nextLong()), rerouteService, electionStrategy, nodeHealthService, circuitBreakerService, this.reconfigurator, leaderHeartbeatService, preVoteCollectorFactory, compatibilityVersions);
        logger.info("using discovery type [{}] and seed hosts providers {}", (Object)discoveryType, seedProviderNames);
    }

    static Reconfigurator getReconfigurator(Settings settings, ClusterSettings clusterSettings, List<ClusterCoordinationPlugin> clusterCoordinationPlugins) {
        List reconfiguratorFactories = clusterCoordinationPlugins.stream().map(ClusterCoordinationPlugin::getReconfiguratorFactory).flatMap(Optional::stream).toList();
        if (reconfiguratorFactories.size() > 1) {
            throw new IllegalStateException("multiple reconfigurator factories found: " + reconfiguratorFactories);
        }
        if (reconfiguratorFactories.size() == 1) {
            return ((ClusterCoordinationPlugin.ReconfiguratorFactory)reconfiguratorFactories.get(0)).newReconfigurator(settings, clusterSettings);
        }
        return new Reconfigurator(settings, clusterSettings);
    }

    static PreVoteCollector.Factory getPreVoteCollectorFactory(List<ClusterCoordinationPlugin> clusterCoordinationPlugins) {
        List preVoteCollectorFactories = clusterCoordinationPlugins.stream().map(ClusterCoordinationPlugin::getPreVoteCollectorFactory).flatMap(Optional::stream).toList();
        if (preVoteCollectorFactories.size() > 1) {
            throw new IllegalStateException("multiple pre-vote collector factories found: " + preVoteCollectorFactories);
        }
        if (preVoteCollectorFactories.size() == 1) {
            return (PreVoteCollector.Factory)preVoteCollectorFactories.get(0);
        }
        return StatefulPreVoteCollector::new;
    }

    static LeaderHeartbeatService getLeaderHeartbeatService(Settings settings, List<ClusterCoordinationPlugin> clusterCoordinationPlugins) {
        List heartbeatServices = clusterCoordinationPlugins.stream().map(plugin -> plugin.getLeaderHeartbeatService(settings)).flatMap(Optional::stream).toList();
        if (heartbeatServices.size() > 1) {
            throw new IllegalStateException("multiple leader heart beat service factories found: " + heartbeatServices);
        }
        if (heartbeatServices.size() == 1) {
            return (LeaderHeartbeatService)heartbeatServices.get(0);
        }
        return LeaderHeartbeatService.NO_OP;
    }

    public static boolean isSingleNodeDiscovery(Settings settings) {
        return SINGLE_NODE_DISCOVERY_TYPE.equals(DISCOVERY_TYPE_SETTING.get(settings));
    }

    public Coordinator getCoordinator() {
        return this.coordinator;
    }

    public Reconfigurator getReconfigurator() {
        return this.reconfigurator;
    }
}

