/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Build;
import org.elasticsearch.core.Booleans;

public class FeatureFlag {
    private final Logger logger = LogManager.getLogger(FeatureFlag.class);
    private final String name;
    private final boolean enabled;
    private static final Function<String, String> GET_SYSTEM_PROPERTY = System::getProperty;

    public FeatureFlag(String name) {
        this(name, "enabled", Build.current(), GET_SYSTEM_PROPERTY);
    }

    @Deprecated
    public static FeatureFlag legacyRegisteredFlag(String name) {
        return new FeatureFlag(name, "registered", Build.current(), GET_SYSTEM_PROPERTY);
    }

    FeatureFlag(String name, String suffix, Build build, Function<String, String> getSystemProperty) {
        this.name = name;
        assert (name.indexOf(46) == -1) : "Feature flag names may not contain a '.' character";
        assert (!name.contains("feature_flag")) : "Feature flag names may not contain the string 'feature_flag'";
        String propertyName = "es." + name + "_feature_flag_" + suffix;
        if (build.isSnapshot()) {
            this.enabled = this.parseSystemProperty(getSystemProperty, propertyName, true);
            if (!this.enabled) {
                throw new IllegalArgumentException("Feature flag " + name + " (via system property '" + propertyName + "') cannot be disabled in snapshot builds");
            }
            this.logger.info("The current build is a snapshot, feature flag [{}] is enabled", (Object)name);
        } else {
            this.enabled = this.parseSystemProperty(getSystemProperty, propertyName, false);
            this.logger.debug("The current build is a not snapshot, feature flag [{}] is {}", (Object)name, (Object)(this.enabled ? "enabled" : "disabled"));
        }
    }

    private boolean parseSystemProperty(Function<String, String> getProperty, String propertyName, boolean defaultValue) {
        String propertyValue = getProperty.apply(propertyName);
        this.logger.trace("Feature flag system property [{}] is set to [{}]", (Object)propertyName, (Object)propertyValue);
        try {
            return Booleans.parseBoolean((String)propertyValue, (boolean)defaultValue);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid value [" + propertyValue + "] for system property [" + propertyName + "]", e);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String toString() {
        return "Feature-Flag(" + this.name + "=" + this.enabled + ")";
    }
}

