/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.Version;
import org.elasticsearch.common.hash.MessageDigests;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.SecureSettings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.env.Environment;
import org.elasticsearch.reservedstate.service.ReservedStateVersion;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;

public class LocallyMountedSecrets
implements SecureSettings {
    public static final String SECRETS_FILE_NAME = "secrets.json";
    public static final String SECRETS_DIRECTORY = "secrets";
    public static final ParseField STRING_SECRETS_FIELD = new ParseField("string_secrets", new String[]{"secrets"});
    public static final ParseField FILE_SECRETS_FIELD = new ParseField("file_secrets", new String[0]);
    public static final ParseField METADATA_FIELD = new ParseField("metadata", new String[0]);
    private final ConstructingObjectParser<LocalFileSecrets, Void> secretsParser = new ConstructingObjectParser("locally_mounted_secrets", a -> {
        Base64.Decoder decoder = Base64.getDecoder();
        Map stringSecretsMap = a[0] == null ? Map.of() : ((Map)a[0]).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((String)e.getValue()).getBytes(StandardCharsets.UTF_8)));
        Map fileSecretsByteMap = a[1] == null ? Map.of() : ((Map)a[1]).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> decoder.decode((String)e.getValue())));
        Set duplicateKeys = fileSecretsByteMap.keySet().stream().filter(stringSecretsMap::containsKey).collect(Collectors.toSet());
        if (!duplicateKeys.isEmpty()) {
            throw new IllegalStateException("Some settings were defined as both string and file settings: " + duplicateKeys);
        }
        Map<String, byte[]> allSecrets = Stream.concat(stringSecretsMap.entrySet().stream(), fileSecretsByteMap.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return new LocalFileSecrets(allSecrets, (ReservedStateVersion)a[2]);
    });
    private final String secretsDir;
    private final String secretsFile;
    private final SetOnce<LocalFileSecrets> secrets = new SetOnce();

    public LocallyMountedSecrets(Environment environment) {
        Path secretsDirPath = LocallyMountedSecrets.resolveSecretsDir(environment);
        Path secretsFilePath = LocallyMountedSecrets.resolveSecretsFile(environment);
        this.secretsParser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), STRING_SECRETS_FIELD);
        this.secretsParser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), FILE_SECRETS_FIELD);
        this.secretsParser.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> ReservedStateVersion.parse(p), METADATA_FIELD);
        if (Files.exists(secretsDirPath, new LinkOption[0]) && Files.exists(secretsFilePath, new LinkOption[0])) {
            try {
                this.secrets.set((Object)this.processSecretsFile(secretsFilePath));
            }
            catch (IOException e) {
                throw new IllegalStateException("Error processing secrets file", e);
            }
        } else {
            this.secrets.set((Object)new LocalFileSecrets(Map.of(), new ReservedStateVersion(-1L, Version.CURRENT)));
        }
        this.secretsDir = secretsDirPath.toString();
        this.secretsFile = secretsFilePath.toString();
    }

    public static Path resolveSecretsDir(Environment environment) {
        return environment.configFile().toAbsolutePath().resolve(SECRETS_DIRECTORY);
    }

    public static Path resolveSecretsFile(Environment environment) {
        return LocallyMountedSecrets.resolveSecretsDir(environment).resolve(SECRETS_FILE_NAME);
    }

    public LocallyMountedSecrets(StreamInput in) throws IOException {
        this.secretsDir = in.readString();
        this.secretsFile = in.readString();
        if (in.readBoolean()) {
            this.secrets.set((Object)LocalFileSecrets.readFrom(in));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.secretsDir);
        out.writeString(this.secretsFile);
        if (this.secrets.get() == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            ((LocalFileSecrets)this.secrets.get()).writeTo(out);
        }
    }

    @Override
    public boolean isLoaded() {
        return this.secrets.get() != null;
    }

    @Override
    public Set<String> getSettingNames() {
        assert (this.isLoaded());
        return ((LocalFileSecrets)this.secrets.get()).entries().keySet();
    }

    @Override
    public SecureString getString(String setting) {
        assert (this.isLoaded());
        byte[] value = ((LocalFileSecrets)this.secrets.get()).entries().get(setting);
        if (value == null) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(value);
        CharBuffer charBuffer = StandardCharsets.UTF_8.decode(byteBuffer);
        return new SecureString(Arrays.copyOfRange(charBuffer.array(), charBuffer.position(), charBuffer.limit()));
    }

    @Override
    public InputStream getFile(String setting) throws GeneralSecurityException {
        assert (this.isLoaded());
        return new ByteArrayInputStream(((LocalFileSecrets)this.secrets.get()).entries().get(setting));
    }

    @Override
    public byte[] getSHA256Digest(String setting) throws GeneralSecurityException {
        assert (this.isLoaded());
        return MessageDigests.sha256().digest(((LocalFileSecrets)this.secrets.get()).entries().get(setting));
    }

    public long getVersion() {
        return ((LocalFileSecrets)this.secrets.get()).metadata.version();
    }

    @Override
    public void close() throws IOException {
        if (null != this.secrets.get() && !((LocalFileSecrets)this.secrets.get()).entries().isEmpty()) {
            for (Map.Entry<String, byte[]> entry : ((LocalFileSecrets)this.secrets.get()).entries().entrySet()) {
                entry.setValue(null);
            }
        }
    }

    /*
     * Exception decompiling
     */
    LocalFileSecrets processSecretsFile(Path path) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    record LocalFileSecrets(Map<String, byte[]> entries, ReservedStateVersion metadata) implements Writeable
    {
        public static LocalFileSecrets readFrom(StreamInput in) throws IOException {
            assert (in.getTransportVersion() == TransportVersion.current());
            return new LocalFileSecrets(in.readMap(StreamInput::readByteArray), ReservedStateVersion.readFrom(in));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            assert (out.getTransportVersion() == TransportVersion.current());
            out.writeMap(this.entries == null ? Map.of() : this.entries, StreamOutput::writeByteArray);
            this.metadata.writeTo(out);
        }
    }
}

