/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import java.io.IOException;
import java.util.Locale;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.util.BitUtil;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.geo.SpatialPoint;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.geometry.ShapeType;
import org.elasticsearch.geometry.utils.GeographyValidator;
import org.elasticsearch.geometry.utils.Geohash;
import org.elasticsearch.geometry.utils.GeometryValidator;
import org.elasticsearch.geometry.utils.WellKnownText;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class GeoPoint
implements SpatialPoint,
ToXContentFragment {
    protected double lat;
    protected double lon;

    public GeoPoint() {
    }

    public GeoPoint(String value) {
        this.resetFromString(value);
    }

    public GeoPoint(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
    }

    public GeoPoint(SpatialPoint template) {
        this(template.getY(), template.getX());
    }

    public GeoPoint reset(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
        return this;
    }

    public GeoPoint resetLat(double lat) {
        this.lat = lat;
        return this;
    }

    public GeoPoint resetLon(double lon) {
        this.lon = lon;
        return this;
    }

    public GeoPoint resetFromString(String value) {
        return this.resetFromString(value, false, GeoUtils.EffectivePoint.BOTTOM_LEFT);
    }

    public GeoPoint resetFromString(String value, boolean ignoreZValue, GeoUtils.EffectivePoint effectivePoint) {
        if (value.toLowerCase(Locale.ROOT).contains("point")) {
            return this.resetFromWKT(value, ignoreZValue);
        }
        if (value.contains(",")) {
            return this.resetFromCoordinates(value, ignoreZValue);
        }
        return this.parseGeoHash(value, effectivePoint);
    }

    public GeoPoint resetFromCoordinates(String value, boolean ignoreZValue) {
        double lon;
        double lat;
        String[] vals = value.split(",");
        if (vals.length > 3) {
            throw new ElasticsearchParseException("failed to parse [{}], expected 2 or 3 coordinates but found: [{}]", vals.length);
        }
        try {
            lat = Double.parseDouble(vals[0].trim());
        }
        catch (NumberFormatException ex) {
            throw new ElasticsearchParseException("latitude must be a number", new Object[0]);
        }
        try {
            lon = Double.parseDouble(vals[1].trim());
        }
        catch (NumberFormatException ex) {
            throw new ElasticsearchParseException("longitude must be a number", new Object[0]);
        }
        if (vals.length > 2) {
            GeoPoint.assertZValue(ignoreZValue, Double.parseDouble(vals[2].trim()));
        }
        return this.reset(lat, lon);
    }

    private GeoPoint resetFromWKT(String value, boolean ignoreZValue) {
        Geometry geometry;
        try {
            geometry = WellKnownText.fromWKT((GeometryValidator)GeographyValidator.instance((boolean)ignoreZValue), (boolean)false, (String)value);
        }
        catch (Exception e) {
            throw new ElasticsearchParseException("Invalid WKT format", (Throwable)e, new Object[0]);
        }
        if (geometry.type() != ShapeType.POINT) {
            throw new ElasticsearchParseException("[geo_point] supports only POINT among WKT primitives, but found " + geometry.type(), new Object[0]);
        }
        Point point = (Point)geometry;
        return this.reset(point.getY(), point.getX());
    }

    GeoPoint parseGeoHash(String geohash, GeoUtils.EffectivePoint effectivePoint) {
        if (effectivePoint == GeoUtils.EffectivePoint.BOTTOM_LEFT) {
            return this.resetFromGeoHash(geohash);
        }
        Rectangle rectangle = Geohash.toBoundingBox((String)geohash);
        return switch (effectivePoint) {
            case GeoUtils.EffectivePoint.TOP_LEFT -> this.reset(rectangle.getMaxY(), rectangle.getMinX());
            case GeoUtils.EffectivePoint.TOP_RIGHT -> this.reset(rectangle.getMaxY(), rectangle.getMaxX());
            case GeoUtils.EffectivePoint.BOTTOM_RIGHT -> this.reset(rectangle.getMinY(), rectangle.getMaxX());
            default -> throw new IllegalArgumentException("Unsupported effective point " + effectivePoint);
        };
    }

    public GeoPoint resetFromIndexHash(long hash) {
        this.lon = Geohash.decodeLongitude((long)hash);
        this.lat = Geohash.decodeLatitude((long)hash);
        return this;
    }

    public GeoPoint resetFromGeoHash(String geohash) {
        long hash;
        try {
            hash = Geohash.mortonEncode((String)geohash);
        }
        catch (IllegalArgumentException ex) {
            throw new ElasticsearchParseException(ex.getMessage(), (Throwable)ex, new Object[0]);
        }
        return this.reset(Geohash.decodeLatitude((long)hash), Geohash.decodeLongitude((long)hash));
    }

    public GeoPoint resetFromGeoHash(long geohashLong) {
        int level = (int)(12L - (geohashLong & 0xFL));
        return this.resetFromIndexHash(BitUtil.flipFlop((long)(geohashLong >>> 4 << level * 5 + 2)));
    }

    public double lat() {
        return this.lat;
    }

    public double getLat() {
        return this.lat;
    }

    public double lon() {
        return this.lon;
    }

    public double getLon() {
        return this.lon;
    }

    @Override
    public double getX() {
        return this.lon;
    }

    @Override
    public double getY() {
        return this.lat;
    }

    public String geohash() {
        return Geohash.stringEncode((double)this.lon, (double)this.lat);
    }

    public String getGeohash() {
        return Geohash.stringEncode((double)this.lon, (double)this.lat);
    }

    public long getEncoded() {
        int latitudeEncoded = GeoEncodingUtils.encodeLatitude((double)this.lat);
        int longitudeEncoded = GeoEncodingUtils.encodeLongitude((double)this.lon);
        return (long)latitudeEncoded << 32 | (long)longitudeEncoded & 0xFFFFFFFFL;
    }

    public GeoPoint resetFromEncoded(long encoded) {
        return this.resetFromEncoded((int)(encoded >>> 32), (int)encoded);
    }

    private GeoPoint resetFromEncoded(int encodedLat, int encodedLon) {
        return this.reset(GeoEncodingUtils.decodeLatitude((int)encodedLat), GeoEncodingUtils.decodeLongitude((int)encodedLon));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoPoint geoPoint = (GeoPoint)o;
        if (Double.compare(geoPoint.lat, this.lat) != 0) {
            return false;
        }
        return Double.compare(geoPoint.lon, this.lon) == 0;
    }

    public int hashCode() {
        long temp = this.lat != 0.0 ? Double.doubleToLongBits(this.lat) : 0L;
        int result = Long.hashCode(temp);
        temp = this.lon != 0.0 ? Double.doubleToLongBits(this.lon) : 0L;
        result = 31 * result + Long.hashCode(temp);
        return result;
    }

    public String toString() {
        return this.lat + ", " + this.lon;
    }

    public static GeoPoint fromGeohash(String geohash) {
        return new GeoPoint().resetFromGeoHash(geohash);
    }

    public static GeoPoint fromGeohash(long geohashLong) {
        return new GeoPoint().resetFromGeoHash(geohashLong);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.latlon(this.lat, this.lon);
    }

    public static double assertZValue(boolean ignoreZValue, double zValue) {
        if (!ignoreZValue) {
            throw new ElasticsearchParseException("Exception parsing coordinates: found Z value [{}] but [ignore_z_value] parameter is [{}]", zValue, ignoreZValue);
        }
        return zValue;
    }
}

