/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.bytes;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.AbstractBytesReference;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.util.ByteUtils;

public final class BytesArray
extends AbstractBytesReference {
    public static final BytesArray EMPTY = new BytesArray(BytesRef.EMPTY_BYTES, 0, 0);
    private final byte[] bytes;
    private final int offset;

    public BytesArray(String bytes) {
        this(new BytesRef((CharSequence)bytes));
    }

    public BytesArray(BytesRef bytesRef) {
        this(bytesRef, false);
    }

    public BytesArray(BytesRef bytesRef, boolean deepCopy) {
        super(bytesRef.length);
        if (deepCopy) {
            bytesRef = BytesRef.deepCopyOf((BytesRef)bytesRef);
        }
        this.bytes = bytesRef.bytes;
        this.offset = bytesRef.offset;
    }

    public BytesArray(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    public BytesArray(byte[] bytes, int offset, int length) {
        super(length);
        this.bytes = bytes;
        this.offset = offset;
    }

    @Override
    public byte get(int index) {
        return this.bytes[this.offset + index];
    }

    @Override
    public int indexOf(byte marker, int from) {
        for (int i = this.offset + from; i < this.offset + this.length; ++i) {
            if (this.bytes[i] != marker) continue;
            return i - this.offset;
        }
        return -1;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof BytesArray) {
            BytesArray that = (BytesArray)other;
            return Arrays.equals(this.bytes, this.offset, this.offset + this.length, that.bytes, that.offset, that.offset + that.length);
        }
        return super.equals(other);
    }

    @Override
    public BytesReference slice(int from, int length) {
        if (from == 0 && this.length == length) {
            return this;
        }
        Objects.checkFromIndexSize(from, length, this.length);
        return new BytesArray(this.bytes, this.offset + from, length);
    }

    @Override
    public boolean hasArray() {
        return true;
    }

    @Override
    public byte[] array() {
        return this.bytes;
    }

    @Override
    public int arrayOffset() {
        return this.offset;
    }

    @Override
    public BytesRef toBytesRef() {
        return new BytesRef(this.bytes, this.offset, this.length);
    }

    @Override
    public long ramBytesUsed() {
        return this.bytes.length;
    }

    @Override
    public StreamInput streamInput() {
        return StreamInput.wrap(this.bytes, this.offset, this.length);
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        os.write(this.bytes, this.offset, this.length);
    }

    @Override
    public int getIntLE(int index) {
        return ByteUtils.readIntLE(this.bytes, this.offset + index);
    }

    @Override
    public long getLongLE(int index) {
        return ByteUtils.readLongLE(this.bytes, this.offset + index);
    }

    @Override
    public double getDoubleLE(int index) {
        return ByteUtils.readDoubleLE(this.bytes, this.offset + index);
    }
}

