/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.DeleteResult;
import org.elasticsearch.common.blobstore.OperationPurpose;
import org.elasticsearch.common.blobstore.OptionalBytesReference;
import org.elasticsearch.common.blobstore.support.BlobMetadata;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.core.CheckedConsumer;

public interface BlobContainer {
    public BlobPath path();

    public boolean blobExists(OperationPurpose var1, String var2) throws IOException;

    public InputStream readBlob(OperationPurpose var1, String var2) throws IOException;

    public InputStream readBlob(OperationPurpose var1, String var2, long var3, long var5) throws IOException;

    default public long readBlobPreferredLength() {
        throw new UnsupportedOperationException();
    }

    public void writeBlob(OperationPurpose var1, String var2, InputStream var3, long var4, boolean var6) throws IOException;

    default public void writeBlob(OperationPurpose purpose, String blobName, BytesReference bytes, boolean failIfAlreadyExists) throws IOException {
        this.writeBlob(purpose, blobName, bytes.streamInput(), bytes.length(), failIfAlreadyExists);
    }

    public void writeMetadataBlob(OperationPurpose var1, String var2, boolean var3, boolean var4, CheckedConsumer<OutputStream, IOException> var5) throws IOException;

    public void writeBlobAtomic(OperationPurpose var1, String var2, BytesReference var3, boolean var4) throws IOException;

    public DeleteResult delete(OperationPurpose var1) throws IOException;

    public void deleteBlobsIgnoringIfNotExists(OperationPurpose var1, Iterator<String> var2) throws IOException;

    public Map<String, BlobMetadata> listBlobs(OperationPurpose var1) throws IOException;

    public Map<String, BlobContainer> children(OperationPurpose var1) throws IOException;

    public Map<String, BlobMetadata> listBlobsByPrefix(OperationPurpose var1, String var2) throws IOException;

    public void compareAndExchangeRegister(OperationPurpose var1, String var2, BytesReference var3, BytesReference var4, ActionListener<OptionalBytesReference> var5);

    default public void compareAndSetRegister(OperationPurpose purpose, String key, BytesReference expected, BytesReference updated, ActionListener<Boolean> listener) {
        this.compareAndExchangeRegister(purpose, key, expected, updated, listener.map(witness -> witness.isPresent() && witness.bytesReference().equals(expected)));
    }

    default public void getRegister(OperationPurpose purpose, String key, ActionListener<OptionalBytesReference> listener) {
        this.compareAndExchangeRegister(purpose, key, BytesArray.EMPTY, BytesArray.EMPTY, listener);
    }
}

