/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.service;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.client.internal.ClusterAdminClient;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.cluster.version.CompatibilityVersions;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;

public class TransportVersionsFixupListener
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(TransportVersionsFixupListener.class);
    private static final TimeValue RETRY_TIME = TimeValue.timeValueSeconds((long)30L);
    private final MasterServiceTaskQueue<NodeTransportVersionTask> taskQueue;
    private final ClusterAdminClient client;
    private final Scheduler scheduler;
    private final Executor executor;
    private final Set<String> pendingNodes = Collections.synchronizedSet(new HashSet());

    public TransportVersionsFixupListener(ClusterService service, ClusterAdminClient client, ThreadPool threadPool) {
        this(service.createTaskQueue("fixup-transport-versions", Priority.LOW, new TransportVersionUpdater()), client, threadPool, threadPool.executor("cluster_coordination"));
    }

    TransportVersionsFixupListener(MasterServiceTaskQueue<NodeTransportVersionTask> taskQueue, ClusterAdminClient client, Scheduler scheduler, Executor executor) {
        this.taskQueue = taskQueue;
        this.client = client;
        this.scheduler = scheduler;
        this.executor = executor;
    }

    @SuppressForbidden(reason="maintaining ClusterState#compatibilityVersions requires reading them")
    private static Map<String, CompatibilityVersions> getCompatibilityVersions(ClusterState clusterState) {
        return clusterState.compatibilityVersions();
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (!event.localNodeMaster()) {
            return;
        }
        if (event.state().nodes().getMinNodeVersion().after(Version.V_8_8_0) && event.state().getMinTransportVersion().equals(ClusterState.INFERRED_TRANSPORT_VERSION)) {
            Set<String> nodes = TransportVersionsFixupListener.getCompatibilityVersions(event.state()).entrySet().stream().filter(e -> ((CompatibilityVersions)e.getValue()).transportVersion().equals(ClusterState.INFERRED_TRANSPORT_VERSION)).map(Map.Entry::getKey).collect(Collectors.toSet());
            this.updateTransportVersions(nodes, 0);
        }
    }

    private void scheduleRetry(Set<String> nodes, int thisRetryNum) {
        logger.debug("Scheduling retry {} for nodes {}", new Object[]{thisRetryNum + 1, nodes});
        this.scheduler.schedule(() -> this.updateTransportVersions(nodes, thisRetryNum + 1), RETRY_TIME, this.executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTransportVersions(Set<String> nodes, final int retryNum) {
        final Set<String> outstandingNodes = Sets.newHashSetWithExpectedSize(nodes.size());
        Set<String> set = this.pendingNodes;
        synchronized (set) {
            for (String n : nodes) {
                if (!this.pendingNodes.add(n)) continue;
                outstandingNodes.add(n);
            }
        }
        if (outstandingNodes.isEmpty()) {
            return;
        }
        NodesInfoRequest request = new NodesInfoRequest((String[])outstandingNodes.toArray(String[]::new));
        request.clear();
        this.client.nodesInfo(request, new ActionListener<NodesInfoResponse>(){

            @Override
            public void onResponse(NodesInfoResponse response) {
                TransportVersionsFixupListener.this.pendingNodes.removeAll(outstandingNodes);
                TransportVersionsFixupListener.this.handleResponse(response, retryNum);
            }

            @Override
            public void onFailure(Exception e) {
                TransportVersionsFixupListener.this.pendingNodes.removeAll(outstandingNodes);
                logger.warn("Could not read transport versions for nodes {}", new Object[]{outstandingNodes, e});
                TransportVersionsFixupListener.this.scheduleRetry(outstandingNodes, retryNum);
            }
        });
    }

    private void handleResponse(NodesInfoResponse response, int retryNum) {
        Map<String, TransportVersion> results;
        if (response.hasFailures()) {
            HashSet<String> failedNodes = new HashSet<String>();
            for (FailedNodeException fne : response.failures()) {
                logger.warn("Failed to read transport version info from node {}", new Object[]{fne.nodeId(), fne});
                failedNodes.add(fne.nodeId());
            }
            this.scheduleRetry(failedNodes, retryNum);
        }
        if (!(results = response.getNodes().stream().collect(Collectors.toUnmodifiableMap(n -> n.getNode().getId(), NodeInfo::getTransportVersion))).isEmpty()) {
            this.taskQueue.submitTask("update-transport-version", new NodeTransportVersionTask(results, retryNum), null);
        }
    }

    private static class TransportVersionUpdater
    implements ClusterStateTaskExecutor<NodeTransportVersionTask> {
        private TransportVersionUpdater() {
        }

        @Override
        public ClusterState execute(ClusterStateTaskExecutor.BatchExecutionContext<NodeTransportVersionTask> context) throws Exception {
            ClusterState.Builder builder = ClusterState.builder(context.initialState());
            boolean modified = false;
            for (ClusterStateTaskExecutor.TaskContext<NodeTransportVersionTask> c : context.taskContexts()) {
                for (Map.Entry<String, TransportVersion> e : c.getTask().results().entrySet()) {
                    Map<String, CompatibilityVersions> cvMap = builder.compatibilityVersions();
                    TransportVersion recordedTv = Optional.ofNullable(cvMap.get(e.getKey())).map(CompatibilityVersions::transportVersion).orElse(null);
                    assert (recordedTv != null || !context.initialState().nodes().nodeExists(e.getKey())) : "Node " + e.getKey() + " is in the cluster but does not have an associated transport version recorded";
                    if (!Objects.equals(recordedTv, ClusterState.INFERRED_TRANSPORT_VERSION)) continue;
                    builder.putCompatibilityVersions(e.getKey(), e.getValue(), Map.of());
                    modified = true;
                }
                c.success(() -> {});
            }
            return modified ? builder.build() : context.initialState();
        }
    }

    class NodeTransportVersionTask
    implements ClusterStateTaskListener {
        private final Map<String, TransportVersion> results;
        private final int retryNum;

        NodeTransportVersionTask(Map<String, TransportVersion> results, int retryNum) {
            this.results = results;
            this.retryNum = retryNum;
        }

        @Override
        public void onFailure(Exception e) {
            logger.error("Could not apply transport version for nodes {} to cluster state", new Object[]{this.results.keySet(), e});
            TransportVersionsFixupListener.this.scheduleRetry(this.results.keySet(), this.retryNum);
        }

        public Map<String, TransportVersion> results() {
            return this.results;
        }
    }
}

