/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.index.shard.ShardId;

public class SnapshotInProgressAllocationDecider
extends AllocationDecider {
    public static final String NAME = "snapshot_in_progress";
    private static final Decision YES_NOT_RUNNING = Decision.single(Decision.Type.YES, "snapshot_in_progress", "no snapshots are currently running", new Object[0]);
    private static final Decision YES_NOT_SNAPSHOTTED = Decision.single(Decision.Type.YES, "snapshot_in_progress", "the shard is not being snapshotted", new Object[0]);

    @Override
    public Decision canRebalance(ShardRouting shardRouting, RoutingAllocation allocation) {
        return SnapshotInProgressAllocationDecider.canMove(shardRouting, allocation);
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return SnapshotInProgressAllocationDecider.canMove(shardRouting, allocation);
    }

    @Override
    public Decision canForceAllocateDuringReplace(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.canAllocate(shardRouting, node, allocation);
    }

    private static Decision canMove(ShardRouting shardRouting, RoutingAllocation allocation) {
        if (allocation.isSimulating()) {
            return allocation.decision(Decision.YES, NAME, "allocation is always enabled when simulating", new Object[0]);
        }
        if (!shardRouting.primary()) {
            return YES_NOT_SNAPSHOTTED;
        }
        SnapshotsInProgress snapshotsInProgress = SnapshotsInProgress.get(allocation.getClusterState());
        if (snapshotsInProgress.isEmpty()) {
            return YES_NOT_RUNNING;
        }
        ShardId shardId = shardRouting.shardId();
        return snapshotsInProgress.asStream().filter(entry -> entry.hasShardsInInitState() && !entry.isClone()).map(entry -> entry.shards().get(shardId)).filter(shardSnapshotStatus -> shardSnapshotStatus != null && !shardSnapshotStatus.state().completed() && shardSnapshotStatus.nodeId() != null && shardSnapshotStatus.nodeId().equals(shardRouting.currentNodeId())).findAny().map(shardSnapshotStatus -> allocation.decision(Decision.THROTTLE, NAME, "waiting for snapshotting of shard [%s] to complete on this node [%s]", shardId, shardSnapshotStatus.nodeId())).orElse(YES_NOT_SNAPSHOTTED);
    }
}

