/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.allocator;

import java.util.function.LongSupplier;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;

public class FrequencyCappedAction {
    private final LongSupplier currentTimeMillisSupplier;
    private TimeValue minInterval;
    private long next = -1L;

    public FrequencyCappedAction(ThreadPool threadPool) {
        this(threadPool::relativeTimeInMillis);
    }

    public FrequencyCappedAction(LongSupplier currentTimeMillisSupplier) {
        this.currentTimeMillisSupplier = currentTimeMillisSupplier;
        this.minInterval = TimeValue.MAX_VALUE;
    }

    public void setMinInterval(TimeValue minInterval) {
        this.minInterval = minInterval;
    }

    public void maybeExecute(Runnable runnable) {
        long current = this.currentTimeMillisSupplier.getAsLong();
        if (current >= this.next) {
            this.next = current + this.minInterval.millis();
            runnable.run();
        }
    }
}

