/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.DiskUsage;
import org.elasticsearch.cluster.RestoreInProgress;
import org.elasticsearch.cluster.metadata.DesiredNodes;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.SingleNodeShutdownMetadata;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.RoutingChangesObserver;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.IndexMetadataUpdater;
import org.elasticsearch.cluster.routing.allocation.ResizeSourceIndexSettingsUpdater;
import org.elasticsearch.cluster.routing.allocation.RoutingNodesChangedObserver;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.snapshots.RestoreService;
import org.elasticsearch.snapshots.SnapshotShardSizeInfo;

public class RoutingAllocation {
    private final AllocationDeciders deciders;
    @Nullable
    private final RoutingNodes routingNodes;
    private final ClusterState clusterState;
    private ClusterInfo clusterInfo;
    private final SnapshotShardSizeInfo shardSizeInfo;
    private Map<ShardId, Set<String>> ignoredShardToNodes = null;
    private boolean ignoreDisable = false;
    private DebugMode debugDecision = DebugMode.OFF;
    private boolean hasPendingAsyncFetch = false;
    private final long currentNanoTime;
    private final boolean isSimulating;
    private boolean isReconciling;
    private final IndexMetadataUpdater indexMetadataUpdater = new IndexMetadataUpdater();
    private final RoutingNodesChangedObserver nodesChangedObserver = new RoutingNodesChangedObserver();
    private final RestoreService.RestoreInProgressUpdater restoreInProgressUpdater = new RestoreService.RestoreInProgressUpdater();
    private final ResizeSourceIndexSettingsUpdater resizeSourceIndexUpdater = new ResizeSourceIndexSettingsUpdater();
    private final RoutingChangesObserver routingChangesObserver = new RoutingChangesObserver.DelegatingRoutingChangesObserver(this.nodesChangedObserver, this.indexMetadataUpdater, this.restoreInProgressUpdater, this.resizeSourceIndexUpdater);
    private final Map<String, SingleNodeShutdownMetadata> nodeReplacementTargets;
    @Nullable
    private final DesiredNodes desiredNodes;
    private final Map<String, Long> unaccountedSearchableSnapshotSizes;

    public RoutingAllocation(AllocationDeciders deciders, ClusterState clusterState, ClusterInfo clusterInfo, SnapshotShardSizeInfo shardSizeInfo, long currentNanoTime) {
        this(deciders, null, clusterState, clusterInfo, shardSizeInfo, currentNanoTime);
    }

    public RoutingAllocation(AllocationDeciders deciders, @Nullable RoutingNodes routingNodes, ClusterState clusterState, @Nullable ClusterInfo clusterInfo, SnapshotShardSizeInfo shardSizeInfo, long currentNanoTime) {
        this(deciders, routingNodes, clusterState, clusterInfo, shardSizeInfo, currentNanoTime, false);
    }

    private RoutingAllocation(AllocationDeciders deciders, @Nullable RoutingNodes routingNodes, ClusterState clusterState, ClusterInfo clusterInfo, SnapshotShardSizeInfo shardSizeInfo, long currentNanoTime, boolean isSimulating) {
        this.deciders = deciders;
        this.routingNodes = routingNodes;
        this.clusterState = clusterState;
        this.clusterInfo = clusterInfo;
        this.shardSizeInfo = shardSizeInfo;
        this.currentNanoTime = currentNanoTime;
        this.isSimulating = isSimulating;
        this.nodeReplacementTargets = RoutingAllocation.nodeReplacementTargets(clusterState);
        this.desiredNodes = DesiredNodes.latestFromClusterState(clusterState);
        this.unaccountedSearchableSnapshotSizes = RoutingAllocation.unaccountedSearchableSnapshotSizes(clusterState, clusterInfo);
    }

    private static Map<String, SingleNodeShutdownMetadata> nodeReplacementTargets(ClusterState clusterState) {
        HashMap<String, SingleNodeShutdownMetadata> nodeReplacementTargets = new HashMap<String, SingleNodeShutdownMetadata>();
        for (SingleNodeShutdownMetadata shutdown : clusterState.metadata().nodeShutdowns().getAll().values()) {
            if (shutdown.getType() != SingleNodeShutdownMetadata.Type.REPLACE) continue;
            nodeReplacementTargets.put(shutdown.getTargetNodeName(), shutdown);
        }
        return Map.copyOf(nodeReplacementTargets);
    }

    private static Map<String, Long> unaccountedSearchableSnapshotSizes(ClusterState clusterState, ClusterInfo clusterInfo) {
        HashMap<String, Long> unaccountedSearchableSnapshotSizes = new HashMap<String, Long>();
        if (clusterInfo != null) {
            for (RoutingNode node : clusterState.getRoutingNodes()) {
                DiskUsage usage = clusterInfo.getNodeMostAvailableDiskUsages().get(node.nodeId());
                ClusterInfo.ReservedSpace reservedSpace = clusterInfo.getReservedSpace(node.nodeId(), usage != null ? usage.getPath() : "");
                long totalSize = 0L;
                for (ShardRouting shard : node.started()) {
                    if (shard.getExpectedShardSize() <= 0L || !clusterState.metadata().getIndexSafe(shard.index()).isSearchableSnapshot() || reservedSpace.containsShardId(shard.shardId()) || clusterInfo.getShardSize(shard) != null) continue;
                    totalSize += shard.getExpectedShardSize();
                }
                if (totalSize <= 0L) continue;
                unaccountedSearchableSnapshotSizes.put(node.nodeId(), totalSize);
            }
        }
        return Collections.unmodifiableMap(unaccountedSearchableSnapshotSizes);
    }

    public long getCurrentNanoTime() {
        return this.currentNanoTime;
    }

    public AllocationDeciders deciders() {
        return this.deciders;
    }

    public RoutingTable routingTable() {
        return this.clusterState.routingTable();
    }

    public RoutingNodes routingNodes() {
        if (this.routingNodes != null) {
            return this.routingNodes;
        }
        return this.clusterState.getRoutingNodes();
    }

    public Metadata metadata() {
        return this.clusterState.metadata();
    }

    public DiscoveryNodes nodes() {
        return this.clusterState.nodes();
    }

    public ClusterState getClusterState() {
        return this.clusterState;
    }

    public ClusterInfo clusterInfo() {
        return this.clusterInfo;
    }

    public SnapshotShardSizeInfo snapshotShardSizeInfo() {
        return this.shardSizeInfo;
    }

    @Nullable
    public DesiredNodes desiredNodes() {
        return this.desiredNodes;
    }

    public Map<String, SingleNodeShutdownMetadata> replacementTargetShutdowns() {
        return this.nodeReplacementTargets;
    }

    public void ignoreDisable(boolean ignoreDisable) {
        this.ignoreDisable = ignoreDisable;
    }

    public boolean ignoreDisable() {
        return this.ignoreDisable;
    }

    public void setDebugMode(DebugMode debug) {
        this.debugDecision = debug;
    }

    public void debugDecision(boolean debug) {
        this.debugDecision = debug ? DebugMode.ON : DebugMode.OFF;
    }

    public boolean debugDecision() {
        return this.debugDecision != DebugMode.OFF;
    }

    public DebugMode getDebugMode() {
        return this.debugDecision;
    }

    public void addIgnoreShardForNode(ShardId shardId, String nodeId) {
        if (this.ignoredShardToNodes == null) {
            this.ignoredShardToNodes = new HashMap<ShardId, Set<String>>();
        }
        this.ignoredShardToNodes.computeIfAbsent(shardId, k -> new HashSet()).add(nodeId);
    }

    public boolean shouldIgnoreShardForNode(ShardId shardId, String nodeId) {
        if (this.ignoredShardToNodes == null) {
            return false;
        }
        Set<String> nodes = this.ignoredShardToNodes.get(shardId);
        return nodes != null && nodes.contains(nodeId);
    }

    public Set<String> getIgnoreNodes(ShardId shardId) {
        if (this.ignoredShardToNodes == null) {
            return Collections.emptySet();
        }
        Set<String> ignore = this.ignoredShardToNodes.get(shardId);
        if (ignore == null) {
            return Collections.emptySet();
        }
        return Set.copyOf(ignore);
    }

    public void removeAllocationId(ShardRouting shardRouting) {
        this.indexMetadataUpdater.removeAllocationId(shardRouting);
    }

    public RoutingChangesObserver changes() {
        return this.routingChangesObserver;
    }

    public Metadata updateMetadataWithRoutingChanges(RoutingTable newRoutingTable) {
        Metadata metadata = this.indexMetadataUpdater.applyChanges(this.metadata(), newRoutingTable);
        return this.resizeSourceIndexUpdater.applyChanges(metadata, newRoutingTable);
    }

    public RestoreInProgress updateRestoreInfoWithRoutingChanges(RestoreInProgress restoreInProgress) {
        return this.restoreInProgressUpdater.applyChanges(restoreInProgress);
    }

    public boolean routingNodesChanged() {
        return this.nodesChangedObserver.isChanged();
    }

    public Decision decision(Decision decision, String deciderLabel, String reason, Object ... params) {
        if (this.debugDecision()) {
            return Decision.single(decision.type(), deciderLabel, reason, params);
        }
        return decision;
    }

    public boolean hasPendingAsyncFetch() {
        return this.hasPendingAsyncFetch;
    }

    public void setHasPendingAsyncFetch() {
        this.hasPendingAsyncFetch = true;
    }

    public long unaccountedSearchableSnapshotSize(RoutingNode routingNode) {
        return this.unaccountedSearchableSnapshotSizes.getOrDefault(routingNode.nodeId(), 0L);
    }

    public boolean isSimulating() {
        return this.isSimulating;
    }

    public boolean isReconciling() {
        return this.isReconciling;
    }

    public Releasable withReconcilingFlag() {
        assert (!this.isReconciling) : "already reconciling";
        this.isReconciling = true;
        return () -> {
            this.isReconciling = false;
        };
    }

    public void setSimulatedClusterInfo(ClusterInfo clusterInfo) {
        assert (this.isSimulating) : "Should be called only while simulating";
        this.clusterInfo = clusterInfo;
    }

    public RoutingAllocation immutableClone() {
        return new RoutingAllocation(this.deciders, this.routingNodesChanged() ? ClusterState.builder(this.clusterState).routingTable(RoutingTable.of(this.clusterState.routingTable().version(), this.routingNodes)).build() : this.clusterState, this.clusterInfo, this.shardSizeInfo, this.currentNanoTime);
    }

    public RoutingAllocation mutableCloneForSimulation() {
        return new RoutingAllocation(this.deciders, this.clusterState.mutableRoutingNodes(), this.clusterState, this.clusterInfo, this.shardSizeInfo, this.currentNanoTime, true);
    }

    public static enum DebugMode {
        OFF,
        ON,
        EXCLUDE_YES_DECISIONS;

    }
}

