/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.node;

import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.index.IndexVersion;

public record VersionInformation(Version nodeVersion, IndexVersion minIndexVersion, IndexVersion maxIndexVersion) {
    public static final VersionInformation CURRENT = new VersionInformation(Version.CURRENT, IndexVersion.MINIMUM_COMPATIBLE, IndexVersion.current());

    public VersionInformation {
        Objects.requireNonNull(nodeVersion);
        Objects.requireNonNull(minIndexVersion);
        Objects.requireNonNull(maxIndexVersion);
    }

    public static VersionInformation inferVersions(Version nodeVersion) {
        if (nodeVersion == null) {
            return null;
        }
        if (nodeVersion.equals(Version.CURRENT)) {
            return CURRENT;
        }
        if (nodeVersion.before(Version.V_8_11_0)) {
            return new VersionInformation(nodeVersion, IndexVersion.getMinimumCompatibleIndexVersion(nodeVersion.id), IndexVersion.fromId(nodeVersion.id));
        }
        throw new IllegalArgumentException("Node versions can only be inferred before release version 8.10.0");
    }
}

