/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination.stateless;

import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.coordination.PreVoteCollector;
import org.elasticsearch.cluster.coordination.stateless.StoreHeartbeatService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.core.Releasable;

public class AtomicRegisterPreVoteCollector
extends PreVoteCollector {
    private final StoreHeartbeatService heartbeatService;
    private final Runnable startElection;

    public AtomicRegisterPreVoteCollector(StoreHeartbeatService heartbeatService, Runnable startElection) {
        this.heartbeatService = heartbeatService;
        this.startElection = startElection;
    }

    @Override
    public Releasable start(ClusterState clusterState, Iterable<DiscoveryNode> broadcastNodes) {
        AtomicBoolean shouldRun = new AtomicBoolean(true);
        this.heartbeatService.runIfNoRecentLeader(() -> {
            if (shouldRun.getAndSet(false)) {
                this.startElection.run();
            }
        });
        return () -> shouldRun.set(false);
    }
}

