/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.io.IOException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.stream.InputStreamStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.transport.TransportRequest;

public class ValidateJoinRequest
extends TransportRequest {
    private final CheckedSupplier<ClusterState, IOException> stateSupplier;
    private final RefCounted refCounted;

    public ValidateJoinRequest(StreamInput in) throws IOException {
        super(in);
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_3_0)) {
            ReleasableBytesReference bytes = in.readReleasableBytesReference();
            TransportVersion version = in.getTransportVersion();
            NamedWriteableRegistry namedWriteableRegistry = in.namedWriteableRegistry();
            this.stateSupplier = () -> ValidateJoinRequest.readCompressed(version, bytes, namedWriteableRegistry);
            this.refCounted = bytes;
        } else {
            ClusterState state = ClusterState.readFrom(in, null);
            this.stateSupplier = () -> state;
            this.refCounted = null;
        }
    }

    private static ClusterState readCompressed(TransportVersion version, BytesReference bytes, NamedWriteableRegistry namedWriteableRegistry) throws IOException {
        try (StreamInput bytesStreamInput = bytes.streamInput();){
            ClusterState clusterState;
            try (NamedWriteableAwareStreamInput in = new NamedWriteableAwareStreamInput(new InputStreamStreamInput(CompressorFactory.COMPRESSOR.threadLocalInputStream(bytesStreamInput)), namedWriteableRegistry);){
                in.setTransportVersion(version);
                clusterState = ClusterState.readFrom(in, null);
            }
            return clusterState;
        }
    }

    public ValidateJoinRequest(ClusterState state) {
        this.stateSupplier = () -> state;
        this.refCounted = null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        assert (out.getTransportVersion().before(TransportVersions.V_8_3_0));
        super.writeTo(out);
        this.stateSupplier.get().writeTo(out);
    }

    public ClusterState getOrReadState() throws IOException {
        return this.stateSupplier.get();
    }

    @Override
    public void incRef() {
        if (this.refCounted != null) {
            this.refCounted.incRef();
        }
    }

    @Override
    public boolean tryIncRef() {
        return this.refCounted == null || this.refCounted.tryIncRef();
    }

    @Override
    public boolean decRef() {
        return this.refCounted != null && this.refCounted.decRef();
    }

    @Override
    public boolean hasReferences() {
        return this.refCounted == null || this.refCounted.hasReferences();
    }
}

