/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.DiskUsage;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.StoreStats;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class ClusterInfo
implements ChunkedToXContent,
Writeable {
    public static final ClusterInfo EMPTY = new ClusterInfo();
    public static final TransportVersion DATA_SET_SIZE_SIZE_VERSION = TransportVersions.V_7_13_0;
    public static final TransportVersion DATA_PATH_NEW_KEY_VERSION = TransportVersions.V_8_6_0;
    private final Map<String, DiskUsage> leastAvailableSpaceUsage;
    private final Map<String, DiskUsage> mostAvailableSpaceUsage;
    final Map<String, Long> shardSizes;
    final Map<ShardId, Long> shardDataSetSizes;
    final Map<NodeAndShard, String> dataPath;
    final Map<NodeAndPath, ReservedSpace> reservedSpace;

    protected ClusterInfo() {
        this(Map.of(), Map.of(), Map.of(), Map.of(), Map.of(), Map.of());
    }

    public ClusterInfo(Map<String, DiskUsage> leastAvailableSpaceUsage, Map<String, DiskUsage> mostAvailableSpaceUsage, Map<String, Long> shardSizes, Map<ShardId, Long> shardDataSetSizes, Map<NodeAndShard, String> dataPath, Map<NodeAndPath, ReservedSpace> reservedSpace) {
        this.leastAvailableSpaceUsage = Map.copyOf(leastAvailableSpaceUsage);
        this.mostAvailableSpaceUsage = Map.copyOf(mostAvailableSpaceUsage);
        this.shardSizes = Map.copyOf(shardSizes);
        this.shardDataSetSizes = Map.copyOf(shardDataSetSizes);
        this.dataPath = Map.copyOf(dataPath);
        this.reservedSpace = Map.copyOf(reservedSpace);
    }

    public ClusterInfo(StreamInput in) throws IOException {
        this.leastAvailableSpaceUsage = in.readImmutableMap(DiskUsage::new);
        this.mostAvailableSpaceUsage = in.readImmutableMap(DiskUsage::new);
        this.shardSizes = in.readImmutableMap(StreamInput::readLong);
        this.shardDataSetSizes = in.getTransportVersion().onOrAfter(DATA_SET_SIZE_SIZE_VERSION) ? in.readImmutableMap(ShardId::new, StreamInput::readLong) : Map.of();
        this.dataPath = in.getTransportVersion().onOrAfter(DATA_PATH_NEW_KEY_VERSION) ? in.readImmutableMap(NodeAndShard::new, StreamInput::readString) : in.readImmutableMap(nested -> NodeAndShard.from(new ShardRouting(nested)), StreamInput::readString);
        this.reservedSpace = in.getTransportVersion().onOrAfter(StoreStats.RESERVED_BYTES_VERSION) ? in.readImmutableMap(NodeAndPath::new, ReservedSpace::new) : Map.of();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.leastAvailableSpaceUsage, StreamOutput::writeWriteable);
        out.writeMap(this.mostAvailableSpaceUsage, StreamOutput::writeWriteable);
        out.writeMap(this.shardSizes, (o, v) -> o.writeLong(v == null ? -1L : v));
        if (out.getTransportVersion().onOrAfter(DATA_SET_SIZE_SIZE_VERSION)) {
            out.writeMap(this.shardDataSetSizes, StreamOutput::writeWriteable, StreamOutput::writeLong);
        }
        if (out.getTransportVersion().onOrAfter(DATA_PATH_NEW_KEY_VERSION)) {
            out.writeMap(this.dataPath, StreamOutput::writeWriteable, StreamOutput::writeString);
        } else {
            out.writeMap(this.dataPath, (o, k) -> ClusterInfo.createFakeShardRoutingFromNodeAndShard(k).writeTo(o), StreamOutput::writeString);
        }
        if (out.getTransportVersion().onOrAfter(StoreStats.RESERVED_BYTES_VERSION)) {
            out.writeMap(this.reservedSpace);
        }
    }

    private static ShardRouting createFakeShardRoutingFromNodeAndShard(NodeAndShard nodeAndShard) {
        return ShardRouting.newUnassigned(nodeAndShard.shardId, true, RecoverySource.EmptyStoreRecoverySource.INSTANCE, new UnassignedInfo(UnassignedInfo.Reason.REINITIALIZED, "fake"), ShardRouting.Role.DEFAULT).initialize(nodeAndShard.nodeId, null, 0L).moveToStarted(0L);
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return Iterators.concat(ChunkedToXContentHelper.startObject("nodes"), Iterators.map(this.leastAvailableSpaceUsage.entrySet().iterator(), c -> (builder, p) -> {
            builder.startObject((String)c.getKey());
            builder.field("node_name", ((DiskUsage)c.getValue()).getNodeName());
            builder.startObject("least_available");
            ((DiskUsage)c.getValue()).toShortXContent(builder);
            builder.endObject();
            builder.startObject("most_available");
            DiskUsage most = this.mostAvailableSpaceUsage.get(c.getKey());
            if (most != null) {
                most.toShortXContent(builder);
            }
            builder.endObject();
            builder.endObject();
            return builder;
        }), ChunkedToXContentHelper.singleChunk((builder, p) -> builder.endObject(), (builder, p) -> builder.startObject("shard_sizes")), Iterators.map(this.shardSizes.entrySet().iterator(), c -> (builder, p) -> builder.humanReadableField((String)c.getKey() + "_bytes", (String)c.getKey(), (Object)ByteSizeValue.ofBytes((Long)c.getValue()))), ChunkedToXContentHelper.singleChunk((builder, p) -> builder.endObject(), (builder, p) -> builder.startObject("shard_data_set_sizes")), Iterators.map(this.shardDataSetSizes.entrySet().iterator(), c -> (builder, p) -> builder.humanReadableField(c.getKey() + "_bytes", ((ShardId)c.getKey()).toString(), (Object)ByteSizeValue.ofBytes((Long)c.getValue()))), ChunkedToXContentHelper.singleChunk((builder, p) -> builder.endObject(), (builder, p) -> builder.startObject("shard_paths")), Iterators.map(this.dataPath.entrySet().iterator(), c -> (builder, p) -> builder.field(((NodeAndShard)c.getKey()).toString(), (String)c.getValue())), ChunkedToXContentHelper.singleChunk((builder, p) -> builder.endObject(), (builder, p) -> builder.startArray("reserved_sizes")), Iterators.map(this.reservedSpace.entrySet().iterator(), c -> (builder, p) -> {
            builder.startObject();
            builder.field("node_id", ((NodeAndPath)c.getKey()).nodeId);
            builder.field("path", ((NodeAndPath)c.getKey()).path);
            ((ReservedSpace)c.getValue()).toXContent(builder, params);
            return builder.endObject();
        }), ChunkedToXContentHelper.endArray());
    }

    public Map<String, DiskUsage> getNodeLeastAvailableDiskUsages() {
        return this.leastAvailableSpaceUsage;
    }

    public Map<String, DiskUsage> getNodeMostAvailableDiskUsages() {
        return this.mostAvailableSpaceUsage;
    }

    public Long getShardSize(ShardId shardId, boolean primary) {
        return this.shardSizes.get(ClusterInfo.shardIdentifierFromRouting(shardId, primary));
    }

    public Long getShardSize(ShardRouting shardRouting) {
        return this.getShardSize(shardRouting.shardId(), shardRouting.primary());
    }

    public long getShardSize(ShardRouting shardRouting, long defaultValue) {
        Long shardSize = this.getShardSize(shardRouting);
        return shardSize == null ? defaultValue : shardSize;
    }

    public String getDataPath(ShardRouting shardRouting) {
        return this.dataPath.get(NodeAndShard.from(shardRouting));
    }

    public String getDataPath(NodeAndShard nodeAndShard) {
        return this.dataPath.get(nodeAndShard);
    }

    public Optional<Long> getShardDataSetSize(ShardId shardId) {
        return Optional.ofNullable(this.shardDataSetSizes.get(shardId));
    }

    public ReservedSpace getReservedSpace(String nodeId, String dataPath) {
        ReservedSpace result = this.reservedSpace.get(new NodeAndPath(nodeId, dataPath));
        return result == null ? ReservedSpace.EMPTY : result;
    }

    public static String shardIdentifierFromRouting(ShardRouting shardRouting) {
        return ClusterInfo.shardIdentifierFromRouting(shardRouting.shardId(), shardRouting.primary());
    }

    public static String shardIdentifierFromRouting(ShardId shardId, boolean primary) {
        return shardId.toString() + "[" + (primary ? "p" : "r") + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterInfo that = (ClusterInfo)o;
        return this.leastAvailableSpaceUsage.equals(that.leastAvailableSpaceUsage) && this.mostAvailableSpaceUsage.equals(that.mostAvailableSpaceUsage) && this.shardSizes.equals(that.shardSizes) && this.shardDataSetSizes.equals(that.shardDataSetSizes) && this.dataPath.equals(that.dataPath) && this.reservedSpace.equals(that.reservedSpace);
    }

    public int hashCode() {
        return Objects.hash(this.leastAvailableSpaceUsage, this.mostAvailableSpaceUsage, this.shardSizes, this.shardDataSetSizes, this.dataPath, this.reservedSpace);
    }

    public String toString() {
        return Strings.toString(this, true, false);
    }

    int getChunkCount() {
        return this.leastAvailableSpaceUsage.size() + this.shardSizes.size() + this.shardDataSetSizes.size() + this.dataPath.size() + this.reservedSpace.size() + 6;
    }

    public record NodeAndShard(String nodeId, ShardId shardId) implements Writeable
    {
        public NodeAndShard {
            Objects.requireNonNull(nodeId);
            Objects.requireNonNull(shardId);
        }

        public NodeAndShard(StreamInput in) throws IOException {
            this(in.readString(), new ShardId(in));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.nodeId);
            this.shardId.writeTo(out);
        }

        public static NodeAndShard from(ShardRouting shardRouting) {
            return new NodeAndShard(shardRouting.currentNodeId(), shardRouting.shardId());
        }
    }

    public record NodeAndPath(String nodeId, String path) implements Writeable
    {
        public NodeAndPath {
            Objects.requireNonNull(nodeId);
            Objects.requireNonNull(path);
        }

        public NodeAndPath(StreamInput in) throws IOException {
            this(in.readString(), in.readString());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.nodeId);
            out.writeString(this.path);
        }
    }

    public record ReservedSpace(long total, Set<ShardId> shardIds) implements Writeable
    {
        public static final ReservedSpace EMPTY = new ReservedSpace(0L, new HashSet<ShardId>());

        ReservedSpace(StreamInput in) throws IOException {
            this(in.readVLong(), in.readCollectionAsSet(ShardId::new));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.total);
            out.writeCollection(this.shardIds);
        }

        public long getTotal() {
            return this.total;
        }

        public boolean containsShardId(ShardId shardId) {
            return this.shardIds.contains(shardId);
        }

        void toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("total", this.total);
            builder.startArray("shards");
            for (ShardId shardIdCursor : this.shardIds) {
                shardIdCursor.toXContent(builder, params);
            }
            builder.endArray();
        }

        public static class Builder {
            private long total;
            private HashSet<ShardId> shardIds = new HashSet();

            public ReservedSpace build() {
                assert (this.shardIds != null) : "already built";
                ReservedSpace reservedSpace = new ReservedSpace(this.total, this.shardIds);
                this.shardIds = null;
                return reservedSpace;
            }

            public Builder add(ShardId shardId, long reservedBytes) {
                assert (this.shardIds != null) : "already built";
                assert (reservedBytes >= 0L) : reservedBytes;
                this.shardIds.add(shardId);
                this.total += reservedBytes;
                return this;
            }
        }
    }
}

