/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.Permission;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.VectorUtil;
import org.apache.lucene.util.Version;
import org.elasticsearch.Build;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.bootstrap.Bootstrap;
import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.bootstrap.BootstrapChecks;
import org.elasticsearch.bootstrap.BootstrapContext;
import org.elasticsearch.bootstrap.BootstrapInfo;
import org.elasticsearch.bootstrap.BootstrapSettings;
import org.elasticsearch.bootstrap.ConsoleCtrlHandler;
import org.elasticsearch.bootstrap.ConsoleLoader;
import org.elasticsearch.bootstrap.ElasticsearchUncaughtExceptionHandler;
import org.elasticsearch.bootstrap.JNAKernel32Library;
import org.elasticsearch.bootstrap.Natives;
import org.elasticsearch.bootstrap.Security;
import org.elasticsearch.bootstrap.ServerArgs;
import org.elasticsearch.bootstrap.Spawner;
import org.elasticsearch.common.ReferenceDocs;
import org.elasticsearch.common.filesystem.FileSystemNatives;
import org.elasticsearch.common.io.stream.InputStreamStreamInput;
import org.elasticsearch.common.logging.LogConfigurator;
import org.elasticsearch.common.network.IfConfig;
import org.elasticsearch.common.settings.SecureSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.util.concurrent.RunOnce;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.jdk.JarHell;
import org.elasticsearch.monitor.jvm.HotThreads;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.monitor.os.OsProbe;
import org.elasticsearch.monitor.process.ProcessProbe;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeValidationException;

class Elasticsearch {
    private static volatile Elasticsearch INSTANCE;
    private final Spawner spawner;
    private final Node node;
    private final CountDownLatch keepAliveLatch = new CountDownLatch(1);
    private final Thread keepAliveThread;

    public static void main(String[] args) {
        Bootstrap bootstrap = Elasticsearch.initPhase1();
        assert (bootstrap != null);
        try {
            Elasticsearch.initPhase2(bootstrap);
            Elasticsearch.initPhase3(bootstrap);
        }
        catch (NodeValidationException e) {
            bootstrap.exitWithNodeValidationException(e);
        }
        catch (Throwable t) {
            bootstrap.exitWithUnknownException(t);
        }
    }

    @SuppressForbidden(reason="grab stderr for communication with server-cli")
    private static PrintStream getStderr() {
        return System.err;
    }

    @SuppressForbidden(reason="grab stdout for communication with server-cli")
    private static PrintStream getStdout() {
        return System.out;
    }

    private static Bootstrap initPhase1() {
        ServerArgs args;
        PrintStream out = Elasticsearch.getStdout();
        PrintStream err = Elasticsearch.getStderr();
        try {
            Elasticsearch.initSecurityProperties();
            Security.setSecurityManager(new SecurityManager(){

                @Override
                public void checkPermission(Permission perm) {
                }
            });
            LogConfigurator.registerErrorListener();
            BootstrapInfo.init();
            InputStreamStreamInput in = new InputStreamStreamInput(System.in);
            args = new ServerArgs(in);
            Environment nodeEnv = new Environment(args.nodeSettings(), args.configDir());
            BootstrapInfo.setConsole(ConsoleLoader.loadConsole(nodeEnv));
            LogConfigurator.setNodeName(Node.NODE_NAME_SETTING.get(args.nodeSettings()));
            LogConfigurator.configure(nodeEnv, !args.quiet());
        }
        catch (Throwable t) {
            t.printStackTrace(err);
            err.flush();
            Bootstrap.exit(1);
            return null;
        }
        return new Bootstrap(out, err, args);
    }

    private static void initPhase2(Bootstrap bootstrap) throws IOException {
        ServerArgs args = bootstrap.args();
        SecureSettings secrets = args.secrets();
        bootstrap.setSecureSettings(secrets);
        Environment nodeEnv = Elasticsearch.createEnvironment(args.configDir(), args.nodeSettings(), secrets);
        bootstrap.setEnvironment(nodeEnv);
        Elasticsearch.initPidFile(args.pidFile());
        Thread.setDefaultUncaughtExceptionHandler(new ElasticsearchUncaughtExceptionHandler());
        bootstrap.spawner().spawnNativeControllers(nodeEnv);
        nodeEnv.validateNativesConfig();
        Elasticsearch.initializeNatives(nodeEnv.tmpFile(), BootstrapSettings.MEMORY_LOCK_SETTING.get(args.nodeSettings()), true, BootstrapSettings.CTRLHANDLER_SETTING.get(args.nodeSettings()));
        Elasticsearch.initializeProbes();
        Runtime.getRuntime().addShutdownHook(new Thread(Elasticsearch::shutdown));
        Logger logger = LogManager.getLogger(JarHell.class);
        JarHell.checkJarHell(arg_0 -> ((Logger)logger).debug(arg_0));
        IfConfig.logIfNecessary();
        Elasticsearch.ensureInitialized(ReferenceDocs.class, AbstractRefCounted.class, SubscribableListener.class, RunOnce.class, VectorUtil.class);
        Security.configure(nodeEnv, BootstrapSettings.SECURITY_FILTER_BAD_DEFAULTS_SETTING.get(args.nodeSettings()), args.pidFile());
    }

    private static void ensureInitialized(Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            try {
                MethodHandles.publicLookup().ensureInitialized(clazz);
            }
            catch (IllegalAccessException unexpected) {
                throw new AssertionError((Object)unexpected);
            }
        }
    }

    private static void initPhase3(Bootstrap bootstrap) throws IOException, NodeValidationException {
        Elasticsearch.checkLucene();
        Node node = new Node(bootstrap.environment()){

            @Override
            protected void validateNodeBeforeAcceptingRequests(BootstrapContext context, BoundTransportAddress boundTransportAddress, List<BootstrapCheck> checks) throws NodeValidationException {
                BootstrapChecks.check(context, boundTransportAddress, checks);
            }
        };
        INSTANCE = new Elasticsearch(bootstrap.spawner(), node);
        IOUtils.close((Closeable)bootstrap.secureSettings());
        INSTANCE.start();
        if (bootstrap.args().daemonize()) {
            LogConfigurator.removeConsoleAppender();
        }
        bootstrap.sendCliMarker('\u0018');
        if (bootstrap.args().daemonize()) {
            bootstrap.closeStreams();
        } else {
            Elasticsearch.startCliMonitorThread(System.in);
        }
    }

    static void initializeNatives(Path tmpFile, boolean mlockAll, boolean systemCallFilter, boolean ctrlHandler) {
        final Logger logger = LogManager.getLogger(Elasticsearch.class);
        if (Natives.definitelyRunningAsRoot()) {
            throw new RuntimeException("can not run elasticsearch as root");
        }
        if (systemCallFilter) {
            Natives.tryInstallSystemCallFilter(tmpFile);
        }
        if (mlockAll) {
            if (Constants.WINDOWS) {
                Natives.tryVirtualLock();
            } else {
                Natives.tryMlockall();
            }
        }
        if (ctrlHandler) {
            Natives.addConsoleCtrlHandler(new ConsoleCtrlHandler(){

                @Override
                public boolean handle(int code) {
                    if (2 == code) {
                        logger.info("running graceful exit on windows");
                        Elasticsearch.shutdown();
                        return true;
                    }
                    return false;
                }
            });
        }
        try {
            JNAKernel32Library.getInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Natives.trySetMaxNumberOfThreads();
        Natives.trySetMaxSizeVirtualMemory();
        Natives.trySetMaxFileSize();
        StringHelper.randomId();
        FileSystemNatives.init();
    }

    static void initializeProbes() {
        ProcessProbe.getInstance();
        OsProbe.getInstance();
        JvmInfo.jvmInfo();
        HotThreads.initializeRuntimeMonitoring();
    }

    static void checkLucene() {
        if (!IndexVersion.current().luceneVersion().equals((Object)Version.LATEST)) {
            throw new AssertionError((Object)("Lucene version mismatch this version of Elasticsearch requires lucene version [" + IndexVersion.current().luceneVersion() + "]  but the current lucene version is [" + Version.LATEST + "]"));
        }
    }

    private static void startCliMonitorThread(InputStream stdin) {
        new Thread(() -> {
            int msg = -1;
            try {
                msg = stdin.read();
            }
            catch (IOException iOException) {
            }
            finally {
                if (msg == 27) {
                    Bootstrap.exit(0);
                } else {
                    Bootstrap.exit(1);
                }
            }
        }).start();
    }

    private static void initPidFile(Path pidFile) throws IOException {
        if (pidFile == null) {
            return;
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                Files.deleteIfExists(pidFile);
            }
            catch (IOException e) {
                throw new ElasticsearchException("Failed to delete pid file " + pidFile, (Throwable)e, new Object[0]);
            }
        }, "elasticsearch[pidfile-cleanup]"));
        assert (pidFile.isAbsolute());
        if (!Files.exists(pidFile.getParent(), new LinkOption[0])) {
            Files.createDirectories(pidFile.getParent(), new FileAttribute[0]);
        }
        Files.writeString(pidFile, (CharSequence)Long.toString(ProcessHandle.current().pid()), new OpenOption[0]);
    }

    private static void initSecurityProperties() {
        for (String property : new String[]{"networkaddress.cache.ttl", "networkaddress.cache.negative.ttl"}) {
            String overrideProperty = "es." + property;
            String overrideValue = System.getProperty(overrideProperty);
            if (overrideValue == null) continue;
            try {
                java.security.Security.setProperty(property, Integer.toString(Integer.valueOf(overrideValue)));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("failed to parse [" + overrideProperty + "] with value [" + overrideValue + "]", e);
            }
        }
        java.security.Security.setProperty("policy.expandProperties", "true");
    }

    private static Environment createEnvironment(Path configDir, Settings initialSettings, SecureSettings secureSettings) {
        Settings.Builder builder = Settings.builder();
        builder.put(initialSettings);
        if (secureSettings != null) {
            builder.setSecureSettings(secureSettings);
        }
        return new Environment(builder.build(), configDir);
    }

    private Elasticsearch(Spawner spawner, Node node) {
        this.spawner = Objects.requireNonNull(spawner);
        this.node = Objects.requireNonNull(node);
        this.keepAliveThread = new Thread(() -> {
            try {
                this.keepAliveLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }, "elasticsearch[keepAlive/" + Build.current().version() + "]");
    }

    private void start() throws NodeValidationException {
        this.node.start();
        this.keepAliveThread.start();
    }

    private static void shutdown() {
        if (INSTANCE == null) {
            return;
        }
        Elasticsearch es = INSTANCE;
        try {
            es.node.prepareForClose();
            IOUtils.close((Closeable[])new Closeable[]{es.node, es.spawner});
            if (!es.node.awaitClose(10L, TimeUnit.SECONDS)) {
                throw new IllegalStateException("Node didn't stop within 10 seconds. Any outstanding requests or tasks might get killed.");
            }
        }
        catch (IOException ex) {
            throw new ElasticsearchException("Failure occurred while shutting down node", (Throwable)ex, new Object[0]);
        }
        catch (InterruptedException e) {
            LogManager.getLogger(Elasticsearch.class).warn("Thread got interrupted while waiting for the node to shutdown.");
            Thread.currentThread().interrupt();
        }
        finally {
            LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
            Configurator.shutdown((LoggerContext)context);
            es.keepAliveLatch.countDown();
        }
    }
}

