/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.synonyms;

import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.util.Strings;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class DeleteSynonymsAction
extends ActionType<AcknowledgedResponse> {
    public static final DeleteSynonymsAction INSTANCE = new DeleteSynonymsAction();
    public static final String NAME = "cluster:admin/synonyms/delete";

    public DeleteSynonymsAction() {
        super(NAME, AcknowledgedResponse::readFrom);
    }

    public static class Request
    extends ActionRequest {
        private final String synonymsSetId;

        public Request(StreamInput in) throws IOException {
            super(in);
            this.synonymsSetId = in.readString();
        }

        public Request(String synonymsSetId) {
            if (Strings.isBlank((String)synonymsSetId)) {
                throw new IllegalArgumentException("Synonym set ID cannot be null or blank");
            }
            this.synonymsSetId = synonymsSetId;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.synonymsSetId);
        }

        public String synonymsSetId() {
            return this.synonymsSetId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.synonymsSetId, request.synonymsSetId);
        }

        public int hashCode() {
            return Objects.hash(this.synonymsSetId);
        }
    }
}

