/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.broadcast.unpromotable;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.RefCountingListener;
import org.elasticsearch.action.support.broadcast.unpromotable.BroadcastUnpromotableRequest;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Strings;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;

public abstract class TransportBroadcastUnpromotableAction<Request extends BroadcastUnpromotableRequest, Response extends ActionResponse>
extends HandledTransportAction<Request, Response> {
    protected final ClusterService clusterService;
    protected final TransportService transportService;
    protected final ShardStateAction shardStateAction;
    protected final String transportUnpromotableAction;
    protected final Executor executor;

    protected TransportBroadcastUnpromotableAction(String actionName, ClusterService clusterService, TransportService transportService, ShardStateAction shardStateAction, ActionFilters actionFilters, Writeable.Reader<Request> requestReader, Executor executor) {
        super(actionName, transportService, actionFilters, requestReader, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.clusterService = clusterService;
        this.shardStateAction = shardStateAction;
        this.transportService = transportService;
        this.transportUnpromotableAction = actionName + "[u]";
        this.executor = executor;
        transportService.registerRequestHandler(this.transportUnpromotableAction, this.executor, requestReader, new UnpromotableTransportHandler());
    }

    protected abstract void unpromotableShardOperation(Task var1, Request var2, ActionListener<Response> var3);

    @Override
    protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
        List<ShardRouting> unpromotableShards = ((BroadcastUnpromotableRequest)request).indexShardRoutingTable.unpromotableShards();
        ArrayList responses = new ArrayList(unpromotableShards.size());
        try (RefCountingListener listeners = new RefCountingListener(listener.map(v -> this.combineUnpromotableShardResponses(responses)));){
            ActionListener.completeWith(listeners.acquire(), () -> {
                ClusterState clusterState = this.clusterService.state();
                if (task != null) {
                    request.setParentTask(this.clusterService.localNode().getId(), task.getId());
                }
                unpromotableShards.forEach(shardRouting -> {
                    DiscoveryNode node = clusterState.nodes().get(shardRouting.currentNodeId());
                    ActionListener<ActionResponse> shardRequestListener = listeners.acquire(response -> {
                        ArrayList arrayList = responses;
                        synchronized (arrayList) {
                            responses.add(response);
                        }
                    });
                    this.transportService.sendRequest(node, this.transportUnpromotableAction, (TransportRequest)request, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<ActionResponse>(request.failShardOnError() ? shardRequestListener.delegateResponse((l, e) -> this.failShard((ShardRouting)shardRouting, clusterState, (ActionListener<Response>)l, (Exception)e)) : shardRequestListener, this::readResponse, this.executor));
                });
                return null;
            });
        }
    }

    protected abstract Response combineUnpromotableShardResponses(List<Response> var1);

    protected abstract Response readResponse(StreamInput var1) throws IOException;

    protected abstract Response emptyResponse();

    private void failShard(final ShardRouting shardRouting, ClusterState clusterState, final ActionListener<Response> l, final Exception e) {
        this.shardStateAction.remoteShardFailed(shardRouting.shardId(), shardRouting.allocationId().getId(), clusterState.metadata().index(shardRouting.getIndexName()).primaryTerm(shardRouting.shardId().getId()), true, "mark unpromotable copy as stale after refresh failure", e, new ActionListener<Void>(){

            @Override
            public void onResponse(Void unused) {
                TransportBroadcastUnpromotableAction.this.logger.debug("Marked shard {} as failed", (Object)shardRouting.shardId());
                l.onResponse(TransportBroadcastUnpromotableAction.this.emptyResponse());
            }

            @Override
            public void onFailure(Exception sfe) {
                TransportBroadcastUnpromotableAction.this.logger.error(Strings.format((String)"Unable to mark shard [%s] as failed", (Object[])new Object[]{shardRouting.shardId()}), (Throwable)sfe);
                l.onFailure(e);
            }
        });
    }

    class UnpromotableTransportHandler
    implements TransportRequestHandler<Request> {
        UnpromotableTransportHandler() {
        }

        @Override
        public void messageReceived(Request request, TransportChannel channel, Task task) throws Exception {
            ChannelActionListener listener = new ChannelActionListener(channel);
            ActionListener.run(listener, l -> TransportBroadcastUnpromotableAction.this.unpromotableShardOperation(task, request, l));
        }
    }
}

