/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.ParsedScrollId;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollAsyncAction;
import org.elasticsearch.action.search.SearchScrollQueryAndFetchAsyncAction;
import org.elasticsearch.action.search.SearchScrollQueryThenFetchAsyncAction;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.action.search.SearchTransportService;
import org.elasticsearch.action.search.TransportSearchHelper;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

public class TransportSearchScrollAction
extends HandledTransportAction<SearchScrollRequest, SearchResponse> {
    private final ClusterService clusterService;
    private final SearchTransportService searchTransportService;

    @Inject
    public TransportSearchScrollAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, SearchTransportService searchTransportService) {
        super("indices:data/read/scroll", transportService, actionFilters, SearchScrollRequest::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.clusterService = clusterService;
        this.searchTransportService = searchTransportService;
    }

    @Override
    protected void doExecute(Task task, SearchScrollRequest request, ActionListener<SearchResponse> listener) {
        try {
            ParsedScrollId scrollId = TransportSearchHelper.parseScrollId(request.scrollId());
            SearchScrollAsyncAction action = switch (scrollId.getType()) {
                case "queryThenFetch" -> new SearchScrollQueryThenFetchAsyncAction(this.logger, this.clusterService, this.searchTransportService, request, (SearchTask)task, scrollId, listener);
                case "queryAndFetch" -> new SearchScrollQueryAndFetchAsyncAction(this.logger, this.clusterService, this.searchTransportService, request, (SearchTask)task, scrollId, listener);
                default -> throw new IllegalArgumentException("Scroll id type [" + scrollId.getType() + "] unrecognized");
            };
            action.run();
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }
}

