/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.builder.PointInTimeBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ToXContent;

public class SearchRequest
extends ActionRequest
implements IndicesRequest.Replaceable,
Rewriteable<SearchRequest> {
    public static final ToXContent.Params FORMAT_PARAMS = new ToXContent.MapParams(Collections.singletonMap("pretty", "false"));
    public static final int DEFAULT_PRE_FILTER_SHARD_SIZE = 128;
    public static final int DEFAULT_BATCHED_REDUCE_SIZE = 512;
    private static final long DEFAULT_ABSOLUTE_START_MILLIS = -1L;
    private final String localClusterAlias;
    private final long absoluteStartMillis;
    private final boolean finalReduce;
    private SearchType searchType = SearchType.DEFAULT;
    private String[] indices = Strings.EMPTY_ARRAY;
    @Nullable
    private String routing;
    @Nullable
    private String preference;
    private SearchSourceBuilder source;
    private Boolean requestCache;
    private Boolean allowPartialSearchResults;
    private Scroll scroll;
    private int batchedReduceSize = 512;
    private int maxConcurrentShardRequests = 0;
    public static final int DEFAULT_MAX_CONCURRENT_SHARD_REQUESTS = 5;
    private Integer preFilterShardSize;
    private boolean ccsMinimizeRoundtrips;
    @Nullable
    private final Version minCompatibleShardNode;
    public static final IndicesOptions DEFAULT_INDICES_OPTIONS = IndicesOptions.strictExpandOpenAndForbidClosedIgnoreThrottled();
    private IndicesOptions indicesOptions = DEFAULT_INDICES_OPTIONS;
    private Map<String, long[]> waitForCheckpoints = Collections.emptyMap();
    private TimeValue waitForCheckpointsTimeout = TimeValue.timeValueSeconds((long)30L);
    private boolean forceSyntheticSource = false;

    public SearchRequest() {
        this((Version)null);
    }

    public SearchRequest(Version minCompatibleShardNode) {
        this.localClusterAlias = null;
        this.absoluteStartMillis = -1L;
        this.finalReduce = true;
        this.minCompatibleShardNode = minCompatibleShardNode;
        this.ccsMinimizeRoundtrips = minCompatibleShardNode == null;
    }

    public SearchRequest(SearchRequest searchRequest) {
        this(searchRequest, searchRequest.indices, searchRequest.localClusterAlias, searchRequest.absoluteStartMillis, searchRequest.finalReduce);
    }

    public SearchRequest(String ... indices) {
        this(indices, new SearchSourceBuilder());
    }

    public SearchRequest(String[] indices, SearchSourceBuilder source) {
        this();
        if (source == null) {
            throw new IllegalArgumentException("source must not be null");
        }
        this.indices(indices);
        this.source = source;
    }

    @Override
    public boolean allowsRemoteIndices() {
        return true;
    }

    static SearchRequest subSearchRequest(TaskId parentTaskId, SearchRequest originalSearchRequest, String[] indices, String clusterAlias, long absoluteStartMillis, boolean finalReduce) {
        Objects.requireNonNull(parentTaskId, "parentTaskId must be specified");
        Objects.requireNonNull(originalSearchRequest, "search request must not be null");
        SearchRequest.validateIndices(indices);
        Objects.requireNonNull(clusterAlias, "cluster alias must not be null");
        if (absoluteStartMillis < 0L) {
            throw new IllegalArgumentException("absoluteStartMillis must not be negative but was [" + absoluteStartMillis + "]");
        }
        SearchRequest request = new SearchRequest(originalSearchRequest, indices, clusterAlias, absoluteStartMillis, finalReduce);
        request.setParentTask(parentTaskId);
        return request;
    }

    private SearchRequest(SearchRequest searchRequest, String[] indices, String localClusterAlias, long absoluteStartMillis, boolean finalReduce) {
        this.allowPartialSearchResults = searchRequest.allowPartialSearchResults;
        this.batchedReduceSize = searchRequest.batchedReduceSize;
        this.ccsMinimizeRoundtrips = searchRequest.ccsMinimizeRoundtrips;
        this.indices = indices;
        this.indicesOptions = searchRequest.indicesOptions;
        this.maxConcurrentShardRequests = searchRequest.maxConcurrentShardRequests;
        this.preference = searchRequest.preference;
        this.preFilterShardSize = searchRequest.preFilterShardSize;
        this.requestCache = searchRequest.requestCache;
        this.routing = searchRequest.routing;
        this.scroll = searchRequest.scroll;
        this.searchType = searchRequest.searchType;
        this.source = searchRequest.source;
        this.localClusterAlias = localClusterAlias;
        this.absoluteStartMillis = absoluteStartMillis;
        this.finalReduce = finalReduce;
        this.minCompatibleShardNode = searchRequest.minCompatibleShardNode;
        this.waitForCheckpoints = searchRequest.waitForCheckpoints;
        this.waitForCheckpointsTimeout = searchRequest.waitForCheckpointsTimeout;
        this.forceSyntheticSource = searchRequest.forceSyntheticSource;
    }

    public SearchRequest(StreamInput in) throws IOException {
        super(in);
        Object[] types;
        this.searchType = SearchType.fromId(in.readByte());
        this.indices = in.readStringArray();
        this.routing = in.readOptionalString();
        this.preference = in.readOptionalString();
        this.scroll = in.readOptionalWriteable(Scroll::new);
        this.source = in.readOptionalWriteable(SearchSourceBuilder::new);
        if (in.getTransportVersion().before(TransportVersions.V_8_0_0) && (types = in.readStringArray()).length > 0) {
            throw new IllegalStateException("types are no longer supported in search requests but found [" + Arrays.toString(types) + "]");
        }
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.requestCache = in.readOptionalBoolean();
        this.batchedReduceSize = in.readVInt();
        this.maxConcurrentShardRequests = in.readVInt();
        this.preFilterShardSize = in.readOptionalVInt();
        this.allowPartialSearchResults = in.readOptionalBoolean();
        this.localClusterAlias = in.readOptionalString();
        if (this.localClusterAlias != null) {
            this.absoluteStartMillis = in.readVLong();
            this.finalReduce = in.readBoolean();
        } else {
            this.absoluteStartMillis = -1L;
            this.finalReduce = true;
        }
        this.ccsMinimizeRoundtrips = in.readBoolean();
        this.minCompatibleShardNode = in.getTransportVersion().onOrAfter(TransportVersions.V_7_12_0) && in.readBoolean() ? Version.readVersion(in) : null;
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_7_16_0)) {
            this.waitForCheckpoints = in.readMap(StreamInput::readLongArray);
            this.waitForCheckpointsTimeout = in.readTimeValue();
        }
        this.forceSyntheticSource = in.getTransportVersion().onOrAfter(TransportVersions.V_8_4_0) ? in.readBoolean() : false;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeByte(this.searchType.id());
        out.writeStringArray(this.indices);
        out.writeOptionalString(this.routing);
        out.writeOptionalString(this.preference);
        out.writeOptionalWriteable(this.scroll);
        out.writeOptionalWriteable(this.source);
        if (out.getTransportVersion().before(TransportVersions.V_8_0_0)) {
            out.writeStringArray(Strings.EMPTY_ARRAY);
        }
        this.indicesOptions.writeIndicesOptions(out);
        out.writeOptionalBoolean(this.requestCache);
        out.writeVInt(this.batchedReduceSize);
        out.writeVInt(this.maxConcurrentShardRequests);
        out.writeOptionalVInt(this.preFilterShardSize);
        out.writeOptionalBoolean(this.allowPartialSearchResults);
        out.writeOptionalString(this.localClusterAlias);
        if (this.localClusterAlias != null) {
            out.writeVLong(this.absoluteStartMillis);
            out.writeBoolean(this.finalReduce);
        }
        out.writeBoolean(this.ccsMinimizeRoundtrips);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_7_12_0)) {
            out.writeBoolean(this.minCompatibleShardNode != null);
            if (this.minCompatibleShardNode != null) {
                Version.writeVersion(this.minCompatibleShardNode, out);
            }
        }
        TransportVersion waitForCheckpointsVersion = TransportVersions.V_7_16_0;
        if (out.getTransportVersion().onOrAfter(waitForCheckpointsVersion)) {
            out.writeMap(this.waitForCheckpoints, StreamOutput::writeLongArray);
            out.writeTimeValue(this.waitForCheckpointsTimeout);
        } else if (!this.waitForCheckpoints.isEmpty()) {
            throw new IllegalArgumentException("Remote transport version [" + out.getTransportVersion() + " incompatible with wait_for_checkpoints. All nodes must use transport version [" + waitForCheckpointsVersion + "] or greater.");
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_4_0)) {
            out.writeBoolean(this.forceSyntheticSource);
        } else if (this.forceSyntheticSource) {
            throw new IllegalArgumentException("force_synthetic_source is not supported before 8.4.0");
        }
    }

    @Override
    public ActionRequestValidationException validate() {
        boolean scroll;
        ActionRequestValidationException validationException = null;
        boolean bl = scroll = this.scroll() != null;
        if (scroll) {
            if (this.source != null) {
                if (this.source.trackTotalHitsUpTo() != null && this.source.trackTotalHitsUpTo() != Integer.MAX_VALUE) {
                    validationException = ValidateActions.addValidationError("disabling [track_total_hits] is not allowed in a scroll context", validationException);
                }
                if (this.source.from() > 0) {
                    validationException = ValidateActions.addValidationError("using [from] is not allowed in a scroll context", validationException);
                }
                if (this.source.size() == 0) {
                    validationException = ValidateActions.addValidationError("[size] cannot be [0] in a scroll context", validationException);
                }
                if (this.source.rescores() != null && !this.source.rescores().isEmpty()) {
                    validationException = ValidateActions.addValidationError("using [rescore] is not allowed in a scroll context", validationException);
                }
            }
            if (this.requestCache != null && this.requestCache.booleanValue()) {
                validationException = ValidateActions.addValidationError("[request_cache] cannot be used in a scroll context", validationException);
            }
        }
        if (this.source != null) {
            if (this.source.subSearches().size() >= 2 && this.source.rankBuilder() == null) {
                validationException = ValidateActions.addValidationError("[sub_searches] requires [rank]", validationException);
            }
            if (this.source.aggregations() != null) {
                validationException = this.source.aggregations().validate(validationException);
            }
            if (this.source.rankBuilder() != null) {
                int queryCount;
                int size;
                int n = size = this.source.size() == -1 ? 10 : this.source.size();
                if (size == 0) {
                    validationException = ValidateActions.addValidationError("[rank] requires [size] greater than [0]", validationException);
                }
                if (size > this.source.rankBuilder().windowSize()) {
                    validationException = ValidateActions.addValidationError("[rank] requires [window_size: " + this.source.rankBuilder().windowSize() + "] be greater than or equal to [size: " + size + "]", validationException);
                }
                if ((queryCount = this.source.subSearches().size() + this.source.knnSearch().size()) < 2) {
                    validationException = ValidateActions.addValidationError("[rank] requires a minimum of [2] result sets using a combination of sub searches and/or knn searches", validationException);
                }
                if (scroll) {
                    validationException = ValidateActions.addValidationError("[rank] cannot be used in a scroll context", validationException);
                }
                if (this.source.rescores() != null && !this.source.rescores().isEmpty()) {
                    validationException = ValidateActions.addValidationError("[rank] cannot be used with [rescore]", validationException);
                }
                if (this.source.sorts() != null && !this.source.sorts().isEmpty()) {
                    validationException = ValidateActions.addValidationError("[rank] cannot be used with [sort]", validationException);
                }
                if (this.source.collapse() != null) {
                    validationException = ValidateActions.addValidationError("[rank] cannot be used with [collapse]", validationException);
                }
                if (this.source.suggest() != null && !this.source.suggest().getSuggestions().isEmpty()) {
                    validationException = ValidateActions.addValidationError("[rank] cannot be used with [suggest]", validationException);
                }
                if (this.source.highlighter() != null) {
                    validationException = ValidateActions.addValidationError("[rank] cannot be used with [highlighter]", validationException);
                }
                if (this.source.pointInTimeBuilder() != null) {
                    validationException = ValidateActions.addValidationError("[rank] cannot be used with [point in time]", validationException);
                }
                if (this.source.profile()) {
                    validationException = ValidateActions.addValidationError("[rank] requires [profile] is [false]", validationException);
                }
                if (this.source.explain() != null && this.source.explain().booleanValue()) {
                    validationException = ValidateActions.addValidationError("[rank] requires [explain] is [false]", validationException);
                }
            }
        }
        if (this.pointInTimeBuilder() != null) {
            if (scroll) {
                validationException = ValidateActions.addValidationError("using [point in time] is not allowed in a scroll context", validationException);
            }
        } else if (this.source != null && this.source.sorts() != null) {
            for (SortBuilder<?> sortBuilder : this.source.sorts()) {
                if (!(sortBuilder instanceof FieldSortBuilder) || !"_shard_doc".equals(((FieldSortBuilder)sortBuilder).getFieldName())) continue;
                validationException = ValidateActions.addValidationError("[_shard_doc] sort field cannot be used without [point in time]", validationException);
            }
        }
        if (this.minCompatibleShardNode() != null && this.isCcsMinimizeRoundtrips()) {
            validationException = ValidateActions.addValidationError("[ccs_minimize_roundtrips] cannot be [true] when setting a minimum compatible shard version", validationException);
        }
        if (this.pointInTimeBuilder() != null && !this.waitForCheckpoints.isEmpty()) {
            validationException = ValidateActions.addValidationError("using [point in time] is not allowed with wait_for_checkpoints", validationException);
        }
        return validationException;
    }

    @Nullable
    String getLocalClusterAlias() {
        return this.localClusterAlias;
    }

    boolean isFinalReduce() {
        return this.finalReduce;
    }

    long getOrCreateAbsoluteStartMillis() {
        return this.absoluteStartMillis == -1L ? System.currentTimeMillis() : this.absoluteStartMillis;
    }

    long getAbsoluteStartMillis() {
        return this.absoluteStartMillis;
    }

    @Nullable
    public Version minCompatibleShardNode() {
        return this.minCompatibleShardNode;
    }

    @Override
    public SearchRequest indices(String ... indices) {
        SearchRequest.validateIndices(indices);
        this.indices = indices;
        return this;
    }

    private static void validateIndices(String ... indices) {
        Objects.requireNonNull(indices, "indices must not be null");
        for (String index : indices) {
            Objects.requireNonNull(index, "index must not be null");
        }
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public SearchRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = Objects.requireNonNull(indicesOptions, "indicesOptions must not be null");
        return this;
    }

    @Override
    public boolean includeDataStreams() {
        return true;
    }

    public boolean isCcsMinimizeRoundtrips() {
        return this.ccsMinimizeRoundtrips;
    }

    public void setCcsMinimizeRoundtrips(boolean ccsMinimizeRoundtrips) {
        this.ccsMinimizeRoundtrips = ccsMinimizeRoundtrips;
    }

    public static boolean defaultCcsMinimizeRoundtrips(SearchRequest request) {
        return request.minCompatibleShardNode == null;
    }

    public String routing() {
        return this.routing;
    }

    public SearchRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public SearchRequest routing(String ... routings) {
        this.routing = Strings.arrayToCommaDelimitedString(routings);
        return this;
    }

    public SearchRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public String preference() {
        return this.preference;
    }

    public SearchRequest searchType(SearchType searchType) {
        this.searchType = Objects.requireNonNull(searchType, "searchType must not be null");
        return this;
    }

    public SearchRequest searchType(String searchType) {
        return this.searchType(SearchType.fromString(searchType));
    }

    public SearchRequest source(SearchSourceBuilder sourceBuilder) {
        this.source = Objects.requireNonNull(sourceBuilder, "source must not be null");
        return this;
    }

    public SearchSourceBuilder source() {
        return this.source;
    }

    public PointInTimeBuilder pointInTimeBuilder() {
        if (this.source != null) {
            return this.source.pointInTimeBuilder();
        }
        return null;
    }

    public SearchType searchType() {
        return this.searchType;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    public Scroll scroll() {
        return this.scroll;
    }

    public SearchRequest scroll(Scroll scroll) {
        this.scroll = scroll;
        return this;
    }

    public SearchRequest scroll(TimeValue keepAlive) {
        return this.scroll(new Scroll(keepAlive));
    }

    public SearchRequest scroll(String keepAlive) {
        return this.scroll(new Scroll(TimeValue.parseTimeValue((String)keepAlive, null, (String)(this.getClass().getSimpleName() + ".Scroll.keepAlive"))));
    }

    public SearchRequest requestCache(Boolean requestCache) {
        this.requestCache = requestCache;
        return this;
    }

    public Boolean requestCache() {
        return this.requestCache;
    }

    public SearchRequest allowPartialSearchResults(boolean allowPartialSearchResults) {
        this.allowPartialSearchResults = allowPartialSearchResults;
        return this;
    }

    public Boolean allowPartialSearchResults() {
        return this.allowPartialSearchResults;
    }

    public void setBatchedReduceSize(int batchedReduceSize) {
        if (batchedReduceSize <= 1) {
            throw new IllegalArgumentException("batchedReduceSize must be >= 2");
        }
        this.batchedReduceSize = batchedReduceSize;
    }

    public int getBatchedReduceSize() {
        return this.batchedReduceSize;
    }

    public int getMaxConcurrentShardRequests() {
        return this.maxConcurrentShardRequests == 0 ? 5 : this.maxConcurrentShardRequests;
    }

    public void setMaxConcurrentShardRequests(int maxConcurrentShardRequests) {
        if (maxConcurrentShardRequests < 1) {
            throw new IllegalArgumentException("maxConcurrentShardRequests must be >= 1");
        }
        this.maxConcurrentShardRequests = maxConcurrentShardRequests;
    }

    public Map<String, long[]> getWaitForCheckpoints() {
        return this.waitForCheckpoints;
    }

    public void setWaitForCheckpoints(Map<String, long[]> afterCheckpointsRefreshed) {
        this.waitForCheckpoints = afterCheckpointsRefreshed;
    }

    public TimeValue getWaitForCheckpointsTimeout() {
        return this.waitForCheckpointsTimeout;
    }

    public void setWaitForCheckpointsTimeout(TimeValue waitForCheckpointsTimeout) {
        this.waitForCheckpointsTimeout = waitForCheckpointsTimeout;
    }

    public void setPreFilterShardSize(int preFilterShardSize) {
        if (preFilterShardSize < 1) {
            throw new IllegalArgumentException("preFilterShardSize must be >= 1");
        }
        this.preFilterShardSize = preFilterShardSize;
    }

    @Nullable
    public Integer getPreFilterShardSize() {
        return this.preFilterShardSize;
    }

    public boolean isSuggestOnly() {
        return this.source != null && this.source.isSuggestOnly();
    }

    public boolean hasKnnSearch() {
        return this.source != null && !this.source.knnSearch().isEmpty();
    }

    public int resolveTrackTotalHitsUpTo() {
        return SearchRequest.resolveTrackTotalHitsUpTo(this.scroll, this.source);
    }

    public boolean isForceSyntheticSource() {
        return this.forceSyntheticSource;
    }

    public void setForceSyntheticSource(boolean forceSyntheticSource) {
        this.forceSyntheticSource = forceSyntheticSource;
    }

    @Override
    public SearchRequest rewrite(QueryRewriteContext ctx) throws IOException {
        SortBuilder<?> lastSort;
        if (this.source == null) {
            return this;
        }
        SearchSourceBuilder source = this.source.rewrite(ctx);
        boolean hasChanged = source != this.source;
        Object[] searchAfter = source.searchAfter();
        if (!(source.pointInTimeBuilder() == null || source.sorts() == null || source.sorts().isEmpty() || searchAfter != null && searchAfter.length != source.sorts().size() + 1 || (lastSort = source.sorts().get(source.sorts().size() - 1)) instanceof FieldSortBuilder && "_shard_doc".equals(((FieldSortBuilder)lastSort).getFieldName()))) {
            ArrayList newSorts = new ArrayList(source.sorts());
            newSorts.add(SortBuilders.pitTiebreaker().unmappedType("long"));
            source = source.shallowCopy().sort(newSorts);
            hasChanged = true;
        }
        return hasChanged ? new SearchRequest(this).source(source) : this;
    }

    public static int resolveTrackTotalHitsUpTo(Scroll scroll, SearchSourceBuilder source) {
        if (scroll != null) {
            return Integer.MAX_VALUE;
        }
        return source == null ? 10000 : (source.trackTotalHitsUpTo() == null ? 10000 : source.trackTotalHitsUpTo());
    }

    @Override
    public SearchTask createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new SearchTask(id, type, action, this::buildDescription, parentTaskId, headers);
    }

    public final String buildDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("indices[");
        Strings.arrayToDelimitedString(this.indices, ",", sb);
        sb.append("]");
        sb.append(", search_type[").append((Object)this.searchType).append("]");
        if (this.scroll != null) {
            sb.append(", scroll[").append(this.scroll.keepAlive()).append("]");
        }
        if (this.source != null) {
            sb.append(", source[").append(this.source.toString(FORMAT_PARAMS)).append("]");
        } else {
            sb.append(", source[]");
        }
        if (this.routing != null) {
            sb.append(", routing[").append(this.routing).append("]");
        }
        if (this.preference != null) {
            sb.append(", preference[").append(this.preference).append("]");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchRequest that = (SearchRequest)o;
        return this.searchType == that.searchType && Arrays.equals(this.indices, that.indices) && Objects.equals(this.routing, that.routing) && Objects.equals(this.preference, that.preference) && Objects.equals(this.source, that.source) && Objects.equals(this.requestCache, that.requestCache) && Objects.equals(this.scroll, that.scroll) && Objects.equals(this.batchedReduceSize, that.batchedReduceSize) && Objects.equals(this.maxConcurrentShardRequests, that.maxConcurrentShardRequests) && Objects.equals(this.preFilterShardSize, that.preFilterShardSize) && Objects.equals(this.indicesOptions, that.indicesOptions) && Objects.equals(this.allowPartialSearchResults, that.allowPartialSearchResults) && Objects.equals(this.localClusterAlias, that.localClusterAlias) && this.absoluteStartMillis == that.absoluteStartMillis && this.ccsMinimizeRoundtrips == that.ccsMinimizeRoundtrips && Objects.equals(this.minCompatibleShardNode, that.minCompatibleShardNode) && this.forceSyntheticSource == that.forceSyntheticSource;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.searchType, Arrays.hashCode(this.indices), this.routing, this.preference, this.source, this.requestCache, this.scroll, this.indicesOptions, this.batchedReduceSize, this.maxConcurrentShardRequests, this.preFilterShardSize, this.allowPartialSearchResults, this.localClusterAlias, this.absoluteStartMillis, this.ccsMinimizeRoundtrips, this.minCompatibleShardNode, this.forceSyntheticSource});
    }

    @Override
    public String toString() {
        return "SearchRequest{searchType=" + this.searchType + ", indices=" + Arrays.toString(this.indices) + ", indicesOptions=" + this.indicesOptions + ", routing='" + this.routing + "', preference='" + this.preference + "', requestCache=" + this.requestCache + ", scroll=" + this.scroll + ", maxConcurrentShardRequests=" + this.maxConcurrentShardRequests + ", batchedReduceSize=" + this.batchedReduceSize + ", preFilterShardSize=" + this.preFilterShardSize + ", allowPartialSearchResults=" + this.allowPartialSearchResults + ", localClusterAlias=" + this.localClusterAlias + ", getOrCreateAbsoluteStartMillis=" + this.absoluteStartMillis + ", ccsMinimizeRoundtrips=" + this.ccsMinimizeRoundtrips + ", source=" + this.source + "}";
    }
}

